/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.ScriptedCommand;

public class AddSiteCommand
extends ScriptedCommand {
    private ISite site;
    private File sitePath;

    public AddSiteCommand(String fromSite) throws Exception {
        block6: {
            if (fromSite != null) {
                this.sitePath = new File(fromSite);
                if (!this.sitePath.exists()) {
                    throw new Exception(String.valueOf(Messages.Standalone_noSite) + fromSite);
                }
                URL fromSiteURL = this.sitePath.toURL();
                this.site = SiteManager.getSite(fromSiteURL, null);
                if (this.site == null) {
                    throw new Exception(String.valueOf(Messages.Standalone_noSite) + fromSite);
                }
                IConfiguredSite csite = this.site.getCurrentConfiguredSite();
                if (csite != null) {
                    throw new Exception(String.valueOf(Messages.Standalone_siteConfigured) + fromSite);
                }
                break block6;
            }
            throw new Exception(Messages.Standalone_noSite3);
        }
    }

    @Override
    public boolean run(IProgressMonitor monitor) {
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            UpdateCore.log(status);
            return false;
        }
        if (this.site == null) {
            return false;
        }
        try {
            IConfiguredSite csite = this.getConfiguration().createConfiguredSite(this.sitePath);
            this.getConfiguration().addConfiguredSite(csite);
            this.getConfiguration().getConfiguredSites();
            SiteManager.getLocalSite().save();
            return true;
        }
        catch (CoreException e) {
            UpdateCore.log(e);
            return false;
        }
    }
}

