/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObservableSetContentProvider
implements IStructuredContentProvider {
    private ObservableCollectionContentProvider impl = new Impl();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet getKnownElements() {
        return this.impl.getKnownElements();
    }

    private static class Impl
    extends ObservableCollectionContentProvider
    implements ISetChangeListener {
        private Impl() {
        }

        @Override
        protected void checkInput(Object input) {
            Assert.isTrue((boolean)(input instanceof IObservableSet), (String)"This content provider only works with input of type IObservableSet");
        }

        @Override
        protected void addCollectionChangeListener(IObservableCollection collection) {
            ((IObservableSet)collection).addSetChangeListener((ISetChangeListener)this);
        }

        @Override
        protected void removeCollectionChangeListener(IObservableCollection collection) {
            ((IObservableSet)collection).removeSetChangeListener((ISetChangeListener)this);
        }

        public void handleSetChange(SetChangeEvent event) {
            if (this.isViewerDisposed()) {
                return;
            }
            Set removals = event.diff.getRemovals();
            this.viewerUpdater.remove(removals.toArray());
            this.knownElements.removeAll((Collection)removals);
            Set additions = event.diff.getAdditions();
            this.knownElements.addAll((Collection)additions);
            this.viewerUpdater.add(additions.toArray());
        }
    }
}

