/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObservableListContentProvider
implements IStructuredContentProvider {
    private ObservableCollectionContentProvider impl = new Impl();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet getKnownElements() {
        return this.impl.getKnownElements();
    }

    private static class Impl
    extends ObservableCollectionContentProvider
    implements IListChangeListener {
        private Impl() {
        }

        @Override
        protected void checkInput(Object input) {
            Assert.isTrue((boolean)(input instanceof IObservableList), (String)"This content provider only works with input of type IObservableList");
        }

        @Override
        protected void addCollectionChangeListener(IObservableCollection collection) {
            ((IObservableList)collection).addListChangeListener((IListChangeListener)this);
        }

        @Override
        protected void removeCollectionChangeListener(IObservableCollection collection) {
            ((IObservableList)collection).removeListChangeListener((IListChangeListener)this);
        }

        public void handleListChange(ListChangeEvent event) {
            if (this.isViewerDisposed()) {
                return;
            }
            final Set removals = ViewerElementSet.withComparer(this.comparer);
            event.diff.accept(new ListDiffVisitor(){

                public void handleAdd(int index, Object element) {
                    Impl.this.knownElements.add(element);
                    Impl.this.viewerUpdater.insert(element, index);
                }

                public void handleRemove(int index, Object element) {
                    Impl.this.viewerUpdater.remove(element, index);
                    removals.add(element);
                }

                public void handleReplace(int index, Object oldElement, Object newElement) {
                    Impl.this.knownElements.add(newElement);
                    Impl.this.viewerUpdater.replace(oldElement, newElement, index);
                    removals.add(oldElement);
                }

                public void handleMove(int oldIndex, int newIndex, Object element) {
                    Impl.this.viewerUpdater.move(element, oldIndex, newIndex);
                }
            });
            removals.removeAll((Collection<?>)event.getObservableList());
            this.knownElements.removeAll((Collection)removals);
        }
    }
}

