/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.tabulator.actions;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.Tabulator;
import jp.sourceforge.concierge.plugin.tabulator.actions.TabulatorAction;
import jp.sourceforge.concierge.util.MailLauncher;
import jp.sourceforge.concierge.util.SystemUtil;
import jp.sourceforge.concierge.util.XMLWriter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public class MailAction
extends TabulatorAction {
    public MailAction(Tabulator tv) {
        super(tv);
    }

    public void run() {
        TableViewer tableview = this.tabulator.getTabulator().getView();
        IStructuredSelection selection = (IStructuredSelection)tableview.getSelection();
        if (selection.size() == 0) {
            return;
        }
        String tempdir = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + ".temp";
        File tempf = new File(tempdir);
        if (!tempf.exists()) {
            tempf.mkdir();
        }
        ArrayList<Document> docs = new ArrayList<Document>();
        for (Document doc : selection) {
            docs.add(doc);
        }
        String filename = String.valueOf(tempdir) + System.getProperty("file.separator") + "metadata.zip";
        File file = new File(filename);
        XMLWriter.ExportDataDocumentToZipFileWithProgress(docs, (File)file, (Shell)tableview.getControl().getShell());
        ArrayList<String> attachments = new ArrayList<String>();
        attachments.add(filename);
        if (SystemUtil.GetOSType() == 1) {
            MailLauncher.run(attachments);
        }
    }
}

