/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;

public class ProxyObservableSet
extends AbstractObservableSet {
    private IObservableSet wrappedSet;
    private Object elementType;
    private ISetChangeListener setChangeListener = new ISetChangeListener(){

        @Override
        public void handleSetChange(SetChangeEvent event) {
            ProxyObservableSet.this.fireSetChange(event.diff);
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        @Override
        public void handleStale(StaleEvent staleEvent) {
            ProxyObservableSet.this.fireStale();
        }
    };

    public ProxyObservableSet(IObservableSet wrappedSet) {
        super(wrappedSet.getRealm());
        this.wrappedSet = wrappedSet;
        this.elementType = wrappedSet.getElementType();
        wrappedSet.addSetChangeListener(this.setChangeListener);
        wrappedSet.addStaleListener(this.staleListener);
    }

    @Override
    protected Set getWrappedSet() {
        return this.wrappedSet == null ? Collections.EMPTY_SET : this.wrappedSet;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.wrappedSet == null ? false : this.wrappedSet.isStale();
    }

    @Override
    public void dispose() {
        if (this.wrappedSet != null) {
            this.wrappedSet.removeSetChangeListener(this.setChangeListener);
            this.setChangeListener = null;
            this.wrappedSet.removeStaleListener(this.staleListener);
            this.staleListener = null;
            this.wrappedSet = null;
        }
        this.elementType = null;
        super.dispose();
    }
}

