/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;

public class ObservableMap
extends AbstractObservable
implements IObservableMap {
    protected Map wrappedMap;
    private boolean stale = false;

    public ObservableMap(Map wrappedMap) {
        this(Realm.getDefault(), wrappedMap);
    }

    public ObservableMap(Realm realm, Map wrappedMap) {
        super(realm);
        this.wrappedMap = wrappedMap;
    }

    @Override
    public synchronized void addMapChangeListener(IMapChangeListener listener) {
        this.addListener(MapChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeMapChangeListener(IMapChangeListener listener) {
        this.removeListener(MapChangeEvent.TYPE, listener);
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    protected void fireMapChange(MapDiff diff) {
        this.checkRealm();
        super.fireChange();
        this.fireEvent(new MapChangeEvent(this, diff));
    }

    @Override
    public boolean containsKey(Object key) {
        this.getterCalled();
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.getterCalled();
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public Set entrySet() {
        this.getterCalled();
        return this.wrappedMap.entrySet();
    }

    @Override
    public Object get(Object key) {
        this.getterCalled();
        return this.wrappedMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.wrappedMap.isEmpty();
    }

    @Override
    public Set keySet() {
        this.getterCalled();
        return this.wrappedMap.keySet();
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.wrappedMap.size();
    }

    @Override
    public Collection values() {
        this.getterCalled();
        return this.wrappedMap.values();
    }

    @Override
    public boolean isStale() {
        this.checkRealm();
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.checkRealm();
        boolean wasStale = this.stale;
        this.stale = stale;
        if (!wasStale && stale) {
            this.fireStale();
        }
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
    }

    @Override
    public boolean equals(Object obj) {
        this.getterCalled();
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return this.wrappedMap.equals(((ObservableMap)obj).wrappedMap);
        }
        return this.wrappedMap.equals(obj);
    }

    @Override
    public int hashCode() {
        this.getterCalled();
        return this.wrappedMap.hashCode();
    }
}

