/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.projectbrowser.actions;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.plugin.projectbrowser.ProjectUtils;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.ProjectBrowserAction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public class MoveAction
extends ProjectBrowserAction {
    public MoveAction(TableViewer pv, TableViewer cv) {
        super(pv, cv);
    }

    public void run() {
        block10: {
            IStructuredSelection sel = (IStructuredSelection)this.projectview.getSelection();
            if (sel == null || sel.isEmpty()) {
                return;
            }
            Document doc = (Document)sel.getFirstElement();
            String path = DataDomImpl.getFilePath((Document)doc);
            File oldf = new File(path);
            if (!oldf.exists() || !oldf.isDirectory()) {
                return;
            }
            DirectoryDialog dd = new DirectoryDialog(this.projectview.getControl().getShell());
            dd.setFilterPath(path);
            dd.setMessage("Specify new location.");
            dd.setText("Move project");
            String newdir = dd.open();
            if (newdir == null || newdir.length() == 0) {
                return;
            }
            try {
                newdir = String.valueOf(newdir) + File.separator + FilenameUtils.getName((String)path);
                File newf = new File(newdir);
                if (newf.exists()) {
                    MessageDialog.openError((Shell)this.projectview.getControl().getShell(), (String)"Error", (String)"Specified location already exists.");
                    return;
                }
                FileUtils.copyDirectory((File)oldf, (File)newf, (boolean)true);
            }
            catch (Exception exception) {
                return;
            }
            try {
                ArrayList<Document> cdocs = ProjectUtils.getProjectFiles(doc);
                ArrayList<Document> rdocs = new ArrayList<Document>();
                DataDomImpl.setFilePath((Document)doc, (String)newdir);
                rdocs.add(doc);
                int i = 0;
                while (i < cdocs.size()) {
                    String cpath = DataDomImpl.getFilePath((Document)cdocs.get(i));
                    if (cpath.startsWith(path)) {
                        cpath = cpath.replaceFirst(path, newdir);
                        DataDomImpl.setFilePath((Document)cdocs.get(i), (String)cpath);
                    }
                    ++i;
                }
                rdocs.addAll(cdocs);
                FrameworkPlugin.updateDocuments((Request)new Request(3, rdocs, "data"), (Object)"jp.sourceforge.concierge.plugin.projectbrowser");
                FileUtils.deleteDirectory((File)oldf);
            }
            catch (Throwable t) {
                if (t.getMessage() == null) break block10;
                System.err.println(t.getMessage());
            }
        }
    }
}

