/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.widget;

import java.util.ArrayList;
import java.util.Iterator;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.util.DataDomTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Document;

public class BindingItemDialog
extends Dialog {
    private TableViewer tableviewer = null;
    private Document document = null;
    private ArrayList<Document> relateditems = new ArrayList();
    private Object sender = null;
    private Action removeAction = null;

    private boolean contains(Document doc) {
        long did = DomImpl.getID(doc);
        if (DomImpl.getID(this.document) == did) {
            return true;
        }
        int i = 0;
        while (i < this.relateditems.size()) {
            long id = DomImpl.getID(this.relateditems.get(i));
            if (did == id) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addItem(Document doc) {
        this.relateditems.add(doc);
    }

    public BindingItemDialog(Shell parentShell) {
        super(new Shell(parentShell));
        this.setShellStyle(1264);
    }

    protected void buttonPressed(int buttonId) {
        int idsz;
        if (buttonId == 0 && (idsz = this.relateditems.size()) > 0) {
            ArrayList<String> ids = new ArrayList<String>();
            int i = 0;
            while (i < idsz) {
                ids.add(String.valueOf(DomImpl.getID(this.relateditems.get(i))));
                ++i;
            }
            DataDomImpl.setRelatedIDs(this.document, ids);
            FrameworkPlugin.updateDocuments(new Request(3, this.document, "data"), this.sender);
        }
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)new GridLayout(1, false));
        Group header = new Group(comp, 0);
        header.setLayout((Layout)new GridLayout(2, false));
        GridData hgd = new GridData(4, 0x1000000, true, false);
        hgd.widthHint = 540;
        header.setLayoutData((Object)hgd);
        Label ttll = new Label((Composite)header, 0);
        ttll.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ttll.setText("Title");
        Label ttlv = new Label((Composite)header, 0);
        ttlv.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ttlv.setText(DataDomImpl.getTitle(this.document));
        Label fpl = new Label((Composite)header, 0);
        fpl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        fpl.setText("File");
        Label fpv = new Label((Composite)header, 0);
        fpv.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fpv.setText(DataDomImpl.getFilePath(this.document));
        Composite tvcomp = new Composite(comp, 0);
        tvcomp.setLayout((Layout)new GridLayout(1, false));
        GridData tvgd = new GridData(4, 4, true, true);
        tvgd.widthHint = 240;
        tvgd.heightHint = 320;
        tvcomp.setLayoutData((Object)tvgd);
        this.tableviewer = new TableViewer(tvcomp, 66304);
        GridData tgd = new GridData(4, 4, true, true);
        tgd.widthHint = 540;
        tgd.heightHint = 320;
        this.tableviewer.getControl().setLayoutData((Object)tgd);
        Table tbl = this.tableviewer.getTable();
        tbl.setLinesVisible(true);
        tbl.setHeaderVisible(true);
        TableColumn tc = new TableColumn(tbl, 16384);
        tc.setText("File");
        tc.setWidth(330);
        tc.setMoveable(false);
        tc.setResizable(true);
        tc = new TableColumn(tbl, 16384);
        tc.setText("Title");
        tc.setWidth(200);
        tc.setMoveable(false);
        tc.setResizable(true);
        this.tableviewer.setContentProvider((IContentProvider)new ItemContentProvider());
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.tableviewer.setInput(this.relateditems);
        DropTarget target = new DropTarget((Control)tbl, 3);
        target.setTransfer(new Transfer[]{DataDomTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropListener());
        this.getShell().setText("Edit related items");
        this.removeAction = new Action(){

            public void run() {
                IStructuredSelection sels = (IStructuredSelection)BindingItemDialog.this.tableviewer.getSelection();
                if (sels == null || sels.isEmpty()) {
                    return;
                }
                ArrayList input = (ArrayList)BindingItemDialog.this.tableviewer.getInput();
                Iterator itr = sels.iterator();
                while (itr.hasNext()) {
                    input.remove(itr.next());
                }
                BindingItemDialog.this.tableviewer.refresh();
            }
        };
        Menu menu = new Menu((Decorations)this.tableviewer.getControl().getShell(), 8);
        MenuItem rmitem = new MenuItem(menu, 8);
        rmitem.setText("Remove");
        rmitem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingItemDialog.this.removeAction.run();
            }
        });
        this.tableviewer.getControl().setMenu(menu);
        return comp;
    }

    protected void initializeBounds() {
        this.getShell().setLocation(200, 200);
        this.getShell().setSize(this.getShell().computeSize(-1, -1));
    }

    public void setDocument(Document doc, Object sender) {
        this.sender = sender;
        this.document = doc;
        ArrayList<Document> reldocs = DataDomImpl.getRelatedAsDocument(doc);
        if (reldocs != null) {
            this.relateditems.addAll(reldocs);
        }
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }

    private class DropListener
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent e) {
            if (e == null || e.currentDataType == null) {
                return;
            }
            if (!DataDomTransfer.getInstance().isSupportedType(e.currentDataType)) {
                return;
            }
            Document[] docs = (Document[])e.data;
            int i = 0;
            while (i < docs.length) {
                if (docs[i] != null && DataDomImpl.isInstance(docs[i]) && !BindingItemDialog.this.contains(docs[i])) {
                    BindingItemDialog.this.addItem(docs[i]);
                }
                ++i;
            }
            BindingItemDialog.this.tableviewer.refresh();
        }

        public void dropAccept(DropTargetEvent e) {
        }
    }

    private class ItemContentProvider
    implements IStructuredContentProvider {
        private ItemContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ItemLabelProvider
    implements ITableLabelProvider {
        private ItemLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return DataDomImpl.getFilePath((Document)element);
            }
            if (columnIndex == 1) {
                return DataDomImpl.getTitle((Document)element);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

