/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DelayedObservableValue
extends AbstractSWTObservableValue {
    private IStaleListener staleListener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            if (!DelayedObservableValue.this.updating) {
                DelayedObservableValue.this.fireStale();
            }
        }
    };
    private IValueChangeListener valueChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            if (!DelayedObservableValue.this.updating) {
                DelayedObservableValue.this.makeDirty();
            }
        }
    };
    private Listener focusOutListener = new Listener(){

        public void handleEvent(Event event) {
            if (DelayedObservableValue.this.dirty) {
                DelayedObservableValue.this.internalFireValueChange(DelayedObservableValue.this.cachedValue);
            }
        }
    };
    private final int delay;
    private ISWTObservableValue observable;
    private Control control;
    private boolean dirty = true;
    private Object cachedValue = null;
    private boolean updating = false;
    private ValueUpdater updater = null;

    public DelayedObservableValue(int delayMillis, ISWTObservableValue observable) {
        super(observable.getRealm(), observable.getWidget());
        this.delay = delayMillis;
        this.observable = observable;
        observable.addValueChangeListener(this.valueChangeListener);
        observable.addStaleListener(this.staleListener);
        Widget widget = observable.getWidget();
        if (widget instanceof Control) {
            this.control = (Control)widget;
            this.control.addListener(16, this.focusOutListener);
        }
        this.cachedValue = this.doGetValue();
    }

    protected Object doGetValue() {
        if (this.dirty) {
            this.cachedValue = this.observable.getValue();
            this.dirty = false;
            if (this.updater != null && !this.updater.running) {
                this.fireValueChange(Diffs.createValueDiff((Object)this.updater.oldValue, (Object)this.cachedValue));
                this.cancelScheduledUpdate();
            }
        }
        return this.cachedValue;
    }

    protected void doSetValue(Object value) {
        this.updating = true;
        try {
            this.dirty = false;
            this.cancelScheduledUpdate();
            Object oldValue = this.cachedValue;
            this.observable.setValue(value);
            this.cachedValue = this.observable.getValue();
            if (!Util.equals((Object)oldValue, (Object)this.cachedValue)) {
                this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)this.cachedValue));
            }
        }
        finally {
            this.updating = false;
        }
    }

    public boolean isStale() {
        ObservableTracker.getterCalled((IObservable)this);
        return this.dirty && this.updater != null || this.observable.isStale();
    }

    public Object getValueType() {
        return this.observable.getValueType();
    }

    public void dispose() {
        this.cancelScheduledUpdate();
        if (this.observable != null) {
            this.observable.dispose();
            this.observable.removeValueChangeListener(this.valueChangeListener);
            this.observable.removeStaleListener(this.staleListener);
            this.observable = null;
        }
        if (this.control != null) {
            this.control.removeListener(16, this.focusOutListener);
            this.control = null;
        }
        super.dispose();
    }

    private void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.fireStale();
        }
        this.cancelScheduledUpdate();
        this.scheduleUpdate();
    }

    private void cancelScheduledUpdate() {
        if (this.updater != null) {
            this.updater.cancel();
            this.updater = null;
        }
    }

    private void scheduleUpdate() {
        this.updater = new ValueUpdater(this.cachedValue);
        this.observable.getWidget().getDisplay().timerExec(this.delay, (Runnable)this.updater);
    }

    private void internalFireValueChange(final Object oldValue) {
        this.cancelScheduledUpdate();
        this.fireValueChange(new ValueDiff(){

            public Object getOldValue() {
                return oldValue;
            }

            public Object getNewValue() {
                return DelayedObservableValue.this.getValue();
            }
        });
    }

    class ValueUpdater
    implements Runnable {
        private final Object oldValue;
        boolean cancel = false;
        boolean running = false;

        ValueUpdater(Object oldValue) {
            this.oldValue = oldValue;
        }

        void cancel() {
            this.cancel = true;
        }

        public void run() {
            if (!this.cancel) {
                try {
                    this.running = true;
                    DelayedObservableValue.this.internalFireValueChange(this.oldValue);
                }
                finally {
                    this.running = false;
                }
            }
        }
    }
}

