/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.styledtexteditor;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.DataHeaderValue;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.EmbeddedObject;
import jp.sourceforge.concierge.plugin.labnote.utils.LineUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HTMLWriter {
    StyledText styledtext;
    ArrayList<EmbeddedObject> eobjects;

    public HTMLWriter(StyledText st, ArrayList<EmbeddedObject> eobjs) {
        this.styledtext = st;
        this.eobjects = eobjs;
    }

    private boolean isNoList(Bullet b) {
        return b == null || b.text == null || b.text.length() == 0;
    }

    private String createStyleString(StyleRange sr) {
        Color c;
        FontData fd;
        String attrval = "";
        String stval = "";
        int style = 0;
        if (sr.font != null) {
            fd = sr.font.getFontData()[0];
            style = fd.getStyle();
        } else {
            fd = null;
            style = sr.fontStyle;
        }
        stval = (style & 2) != 0 ? "font-style: italic;" : "font-style: normal;";
        if ((style & 1) != 0) {
            stval = String.valueOf(stval) + "font-weight: bold;";
        }
        String szval = fd != null ? "font-size: " + String.valueOf(fd.getHeight()) + "pt;" : "";
        String ffval = fd != null ? "font-family: '" + fd.getName() + "';" : "";
        String colval = "";
        if (sr.foreground != null) {
            c = sr.foreground;
            colval = "color: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");";
        }
        if (sr.background != null) {
            c = sr.background;
            colval = String.valueOf(colval) + "background: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");";
        }
        String txtval = "text-decoration:";
        if (sr.underline) {
            txtval = String.valueOf(txtval) + " underline";
        }
        if (sr.strikeout) {
            txtval = String.valueOf(txtval) + " line-through";
        }
        txtval = sr.underline || sr.strikeout ? String.valueOf(txtval) + ";" : String.valueOf(txtval) + " none;";
        attrval = String.valueOf(attrval) + stval + szval + ffval + colval + txtval;
        return attrval;
    }

    private Element createStyleTag(Document doc, StyleRange sr, String text) {
        Element e = doc.createElement("span");
        e.setAttribute("id", "span1");
        e.setAttribute("style", this.createStyleString(sr));
        DomImpl.setElementText((Element)e, (String)text);
        return e;
    }

    private Element createStyleLITag(Document html, ArrayList<StyleRange> styles, Bullet b) {
        Element e = html.createElement("span");
        e.setAttribute("id", "li");
        e.setAttribute("title", b.text);
        String style = "line-height:1.5;text0-valign:center;margin-left:" + b.style.metrics.width + "px;";
        e.setAttribute("style", style);
        Element ce = html.createElement("span");
        ce.setAttribute("id", "li-title");
        ce.setAttribute("style", "margin-right:5px");
        ce.setTextContent(b.text);
        e.appendChild(ce);
        int i = 0;
        while (i < styles.size()) {
            StyleRange sr = styles.get(i);
            String txt = this.styledtext.getTextRange(sr.start, sr.length);
            if (txt.length() > 1 && (txt.endsWith("\r") || txt.endsWith("\n"))) {
                txt = txt.substring(0, txt.length() - 1);
            }
            ce = null;
            if (txt.equals("\ufffc")) {
                ce = this.createImageTag(html, sr);
            } else if (!txt.equals("\n") && !txt.equals("\r")) {
                ce = this.createStyleTag(html, sr, txt);
            }
            if (ce != null) {
                e.appendChild(ce);
            }
            ++i;
        }
        return e;
    }

    private Element createImageTag(Document doc, StyleRange sr) {
        int i = 0;
        while (i < this.eobjects.size()) {
            EmbeddedObject ei = this.eobjects.get(i);
            if (ei.getOffset() == sr.start) {
                return ei.save(doc);
            }
            ++i;
        }
        return null;
    }

    private Element createBRTag(Document doc) {
        return doc.createElement("br");
    }

    private ArrayList<StyleRange> createStyleList() {
        String text = this.styledtext.getText();
        StyleRange[] srs = this.styledtext.getStyleRanges(true);
        int start = 0;
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int i = 0;
        while (i < srs.length) {
            if (srs[i].start == start) {
                styles.add((StyleRange)srs[i].clone());
                start = srs[i].start + srs[i].length;
            } else {
                StyleRange sr = new StyleRange();
                sr.start = start;
                sr.length = srs[i].start - start;
                sr.fontStyle = 0;
                styles.add(sr);
                start = srs[i].start;
                --i;
            }
            ++i;
        }
        if (start < text.length()) {
            StyleRange sr = new StyleRange();
            sr.start = start;
            sr.length = text.length() - start;
            sr.fontStyle = 0;
            styles.add(sr);
        }
        return styles;
    }

    private ArrayList<StyleRange> getStyleRanges(ArrayList<StyleRange> styles, int start, int end) {
        int sidx = -1;
        int eidx = -1;
        int i = 0;
        while (i < styles.size()) {
            StyleRange sr = styles.get(i);
            if (sr.start <= start && start < sr.start + sr.length) {
                sidx = i;
            }
            if (sr.start <= end && end < sr.start + sr.length) {
                eidx = i;
            }
            if (eidx >= 0) break;
            ++i;
        }
        ArrayList<StyleRange> al = new ArrayList<StyleRange>();
        if (sidx == -1 || eidx == -1) {
            return al;
        }
        int i2 = sidx;
        while (i2 <= eidx) {
            StyleRange sr = (StyleRange)styles.get(i2).clone();
            if (i2 == sidx) {
                sr.length = sr.start + sr.length - start;
                sr.start = start;
            }
            if (i2 == eidx) {
                sr.length = end - sr.start + 1;
            }
            al.add(sr);
            ++i2;
        }
        return al;
    }

    private void setTagByLine(Document html, Element parent, ArrayList<StyleRange> styles, int indent) {
        Element span = DomImpl.createElement((Document)html, (String)"span", null);
        DomImpl.setAttribute((Element)span, (String)"id", (String)"line");
        DomImpl.setAttribute((Element)span, (String)"style", (String)("line-height:1.2;margin-left:" + indent + ";margin-top:5px;margin-bottom:5px;"));
        parent.appendChild(span);
        parent = span;
        int i = 0;
        while (i < styles.size()) {
            StyleRange sr = styles.get(i);
            String txt = this.styledtext.getTextRange(sr.start, sr.length);
            if (txt.length() > 1 && (txt.endsWith("\r") || txt.endsWith("\n"))) {
                txt = txt.substring(0, txt.length() - 1);
            }
            Element e = null;
            if (txt.equals("\ufffc")) {
                e = this.createImageTag(html, sr);
            } else if (!txt.equals("\n") && !txt.equals("\r")) {
                e = this.createStyleTag(html, sr, txt);
            }
            if (e != null) {
                parent.appendChild(e);
            }
            ++i;
        }
    }

    public Document exportToDocument(ArrayList<DataHeaderValue> bheads, String cssstr) {
        ArrayList<StyleRange> styles = this.createStyleList();
        Document html = DomImpl.createDocument((String)"html");
        html.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        Element head = DomImpl.appendElement((Element)html.getDocumentElement(), (String)"head");
        Element meta = DomImpl.appendElement((Element)head, (String)"meta");
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", "text/html;charset=utf-8");
        if (cssstr != null) {
            Element css = DomImpl.appendElement((Element)head, (String)"style");
            css.setAttribute("type", "text/css");
            DomImpl.setElementText((Element)css, (String)cssstr);
        }
        Element body = DomImpl.appendElement((Element)html.getDocumentElement(), (String)"body");
        body.setAttribute("id", "body1");
        if (bheads != null) {
            Element td;
            Element tr;
            DataHeaderValue dhv;
            Element ttbl = DomImpl.appendElement((Element)body, (String)"table");
            ttbl.setAttribute("id", "title");
            Element itbl = DomImpl.appendElement((Element)body, (String)"table");
            itbl.setAttribute("id", "information");
            ArrayList<DataHeaderValue> ttlheader = new ArrayList<DataHeaderValue>();
            ArrayList<DataHeaderValue> infheader = new ArrayList<DataHeaderValue>();
            int i = 0;
            while (i < bheads.size()) {
                dhv = bheads.get(i);
                if (dhv.title) {
                    ttlheader.add(dhv);
                } else {
                    infheader.add(dhv);
                }
                ++i;
            }
            i = 0;
            while (i < ttlheader.size()) {
                dhv = (DataHeaderValue)ttlheader.get(i);
                tr = DomImpl.appendElement((Element)ttbl, (String)"tr");
                td = DomImpl.appendElement((Element)tr, (String)"td");
                td.setAttribute("style", "padding: 5px");
                DomImpl.setElementText((Element)td, (String)dhv.Marge(" "));
                ++i;
            }
            i = 0;
            while (i < infheader.size()) {
                dhv = (DataHeaderValue)infheader.get(i);
                tr = DomImpl.appendElement((Element)itbl, (String)"tr");
                td = DomImpl.appendElement((Element)tr, (String)"td");
                if (i == 0) {
                    td.setAttribute("style", "padding-top: 5px;padding-left: 20px");
                } else if (i == infheader.size() - 1) {
                    td.setAttribute("style", "padding-bottom: 5px;padding-left: 20px");
                } else {
                    td.setAttribute("style", "padding-left: 20px");
                }
                DomImpl.setElementText((Element)td, (String)dhv.Marge(" "));
                ++i;
            }
        }
        Element div = DomImpl.appendElement((Element)body, (String)"div");
        div.setAttribute("id", "content");
        Element parent = div;
        int lc = this.styledtext.getLineCount();
        int i = 0;
        while (i < lc) {
            block15: {
                block16: {
                    Bullet b;
                    ArrayList<StyleRange> sts;
                    block13: {
                        int indent;
                        block14: {
                            int ls = this.styledtext.getOffsetAtLine(i);
                            int le = LineUtils.getLastOffsetAtLine(this.styledtext, i);
                            sts = this.getStyleRanges(styles, ls, le);
                            b = this.styledtext.getLineBullet(i);
                            int n = indent = b == null ? 0 : b.style.metrics.width;
                            if (!this.isNoList(b)) break block13;
                            parent = div;
                            if (b == null || b.style.metrics.ascent != 1) break block14;
                            Color lineColor = this.styledtext.getLineBackground(i);
                            StyleRange styleRange = new StyleRange();
                            styleRange.background = lineColor;
                            Element h1e = html.createElement("h1");
                            h1e.setAttribute("style", this.createStyleString(styleRange));
                            h1e.setAttribute("id", "head1");
                            parent.appendChild(h1e);
                            this.setTagByLine(html, h1e, sts, -1);
                            break block15;
                        }
                        this.setTagByLine(html, parent, sts, indent);
                        break block16;
                    }
                    Element litag = this.createStyleLITag(html, sts, b);
                    parent.appendChild(litag);
                }
                if (i != lc - 1) {
                    parent.appendChild(this.createBRTag(html));
                }
            }
            ++i;
        }
        return html;
    }

    private void exportToFile(Document html, String dirname, String filename) {
        File of;
        Element el;
        File destdir = new File(dirname);
        if (!destdir.exists()) {
            destdir.mkdir();
        }
        NodeList nl = html.getElementsByTagName("img");
        int i = 0;
        while (i < nl.getLength()) {
            el = (Element)nl.item(i);
            String imgsrc = el.getAttribute("src");
            try {
                of = new File(imgsrc);
                FileUtils.copyFileToDirectory((File)of, (File)destdir);
                el.setAttribute("src", FilenameUtils.getName((String)imgsrc));
            }
            catch (Exception exception) {}
            ++i;
        }
        nl = html.getElementsByTagName("a");
        i = 0;
        while (i < nl.getLength()) {
            el = (Element)nl.item(i);
            String asrc = el.getAttribute("href");
            try {
                of = new File(asrc);
                if (of.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)of, (File)destdir);
                } else {
                    FileUtils.copyFileToDirectory((File)of, (File)destdir);
                }
                el.setAttribute("href", FilenameUtils.getName((String)asrc));
            }
            catch (Exception exception) {}
            ++i;
        }
        DomImpl.saveDocument((Document)html, (String)(String.valueOf(dirname) + File.separator + filename));
    }

    public void exportToFile(String dirname, String filename, String cssstr, ArrayList<DataHeaderValue> bheads) {
        Document html = this.exportToDocument(bheads, cssstr);
        this.exportToFile(html, dirname, filename);
    }

    public static Document convertToHtml(Element head, Element body) {
        Document html = DomImpl.createDocument((String)"html");
        html.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        if (head == null) {
            head = DomImpl.appendElement((Element)html.getDocumentElement(), (String)"head");
            Element meta = DomImpl.appendElement((Element)head, (String)"meta");
            meta.setAttribute("http-equiv", "Content-Type");
            meta.setAttribute("content", "text/html;charset=utf-8");
        } else {
            head = (Element)html.importNode(head, true);
            html.getDocumentElement().appendChild(head);
        }
        if (body == null) {
            body = DomImpl.appendElement((Element)html.getDocumentElement(), (String)"body");
            body.setAttribute("id", "body1");
            Element div = DomImpl.appendElement((Element)body, (String)"div");
            div.setAttribute("id", "content");
        } else {
            body = (Element)html.importNode(body, true);
            html.getDocumentElement().appendChild(body);
        }
        return html;
    }
}

