/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.dataupdater;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.dataupdater.IDataUpdater;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.LabNoteDocumentImpl;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.HTMLWriter;
import jp.sourceforge.concierge.util.CCGFileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LabNoteUpdater
implements IDataUpdater {
    private static final String OLDCONTENTELEMENT = "Content";

    private static void procTag(Element lelem) {
        NodeList imgs = lelem.getElementsByTagName("img");
        int i = imgs.getLength() - 1;
        while (i >= 0) {
            Element img = (Element)imgs.item(i);
            Element elema = (Element)img.getParentNode();
            if (!elema.getNodeName().equals("a")) {
                Element parent = (Element)img.getParentNode();
                elema = lelem.getOwnerDocument().createElement("a");
                parent.replaceChild(elema, img);
                elema.appendChild(img);
                elema.setAttribute("alt", img.getAttribute("alt"));
                try {
                    String path;
                    long id = Long.parseLong(img.getAttribute("alt"));
                    Document idoc = FrameworkPlugin.getDocumentByID((String)"data", (long)id);
                    if (idoc != null && (path = DataDomImpl.getFilePath((Document)idoc)) != null) {
                        elema.setAttribute("href", path);
                        img.setAttribute("src", LabNotePlugin.importImageFile(path, id));
                        img.setAttribute("alt", "");
                    }
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    String path;
                    long id = Long.parseLong(elema.getAttribute("alt"));
                    Document adoc = FrameworkPlugin.getDocumentByID((String)"data", (long)id);
                    if (adoc != null && (path = DataDomImpl.getFilePath((Document)adoc)) != null) {
                        elema.setAttribute("href", path);
                        String imgsrc = CCGFileUtils.isImage((String)path) ? path : LabNotePlugin.getDefault().getFilePath("icons/metadata.gif");
                        imgsrc = LabNotePlugin.importImageFile(imgsrc, id);
                        img.setAttribute("src", imgsrc);
                    }
                }
                catch (Throwable throwable) {}
            }
            --i;
        }
    }

    private static void extractHtml(Element lelem) {
        NodeList contnl = lelem.getElementsByTagName(OLDCONTENTELEMENT);
        if (contnl == null || contnl.getLength() == 0) {
            return;
        }
        NodeList nl = ((Element)contnl.item(0)).getElementsByTagName("head");
        Element head = nl == null || nl.getLength() == 0 ? null : (Element)nl.item(0);
        nl = ((Element)contnl.item(0)).getElementsByTagName("body");
        Element body = nl == null || nl.getLength() == 0 ? null : (Element)nl.item(0);
        Document html = HTMLWriter.convertToHtml(head, body);
        Document doc = lelem.getOwnerDocument();
        String path = String.valueOf(LabNotePlugin.getLabNoteSrcDirectory()) + File.separator + LabNoteDocumentImpl.getDate(doc) + "-" + DomImpl.getID((Document)doc) + ".html";
        DataDomImpl.setFilePath((Document)doc, (String)path);
        DomImpl.saveDocument((Document)html, (String)path);
        contnl.item(0).getParentNode().removeChild(contnl.item(0));
    }

    private static Document convert(Document doc) {
        String fpath;
        Element lelem = DataDomImpl.getDataOfType((Document)doc, (String)"Note");
        if (lelem == null) {
            return doc;
        }
        String vstr = DomImpl.getAttribute((Element)lelem, (String)"version");
        try {
            int version = Integer.parseInt(vstr);
            if (version >= 2) {
                return doc;
            }
        }
        catch (Throwable throwable) {}
        String title = LabNoteDocumentImpl.getTitle(doc);
        String keywd = LabNoteDocumentImpl.getKeywords(doc);
        if (title != null) {
            title = title.trim();
            DataDomImpl.setTitle((Document)doc, (String)title);
        }
        if (keywd != null) {
            keywd = keywd.trim();
            DataDomImpl.setKeywords((Document)doc, (String)keywd);
        }
        if ((fpath = DataDomImpl.getFilePath((Document)doc)) == null || fpath.length() == 0) {
            LabNoteUpdater.procTag(lelem);
            LabNoteUpdater.extractHtml(lelem);
        }
        Document html = LabNoteDocumentImpl.getContent(doc);
        NodeList nl = html.getElementsByTagName("a");
        ArrayList<String> ids = new ArrayList<String>();
        int nlsz = nl.getLength();
        int i = 0;
        while (i < nlsz) {
            Element elem = (Element)nl.item(i);
            String aalt = elem.getAttribute("alt");
            if (aalt != null && aalt.length() != 0) {
                try {
                    Long.parseLong(aalt);
                    ids.add(aalt);
                }
                catch (Throwable throwable) {}
            }
            ++i;
        }
        DataDomImpl.setRelatedIDs((Document)doc, ids);
        DomImpl.setAttribute((Element)lelem, (String)"version", (String)String.valueOf(2));
        return doc;
    }

    public int update(ArrayList<Document> docs) {
        int i = 0;
        while (i < docs.size()) {
            LabNoteUpdater.convert(docs.get(i));
            ++i;
        }
        return 0;
    }
}

