/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.ieice;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfoGetter;
import jp.sourceforge.concierge.plugin.ipapers.search.ArticleInfo;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.EncodingUtil;

public class IEICECore
extends PaperInfoGetter {
    public static final String IDTYPE = "ieice";
    private static String IEICE_JAPANESE_ENCODING = "EUC-JP";

    public IEICECore() {
        super(IDTYPE);
    }

    @Override
    public PaperInfo fetchInfo(String id) throws CannotGetPaperInfoException {
        String htmlBody = null;
        try {
            htmlBody = this.getHTMLBody(id);
            ArticleInfo info = new ArticleInfo();
            info.setAuthor(this.getAuthorString(this.getAuthors(htmlBody)));
            info.setTitle(this.getTitle(htmlBody));
            info.setJournal(this.getJournal(htmlBody));
            info.setVolume(this.getVolume(htmlBody));
            info.setYear(this.getYear(htmlBody));
            info.setIssue(this.getIssue(htmlBody));
            info.setPages(this.getPages(htmlBody));
            info.setAbstract(this.getAbstract(htmlBody));
            info.putID(IDTYPE, id);
            return info;
        }
        catch (HttpException httpException) {
            throw new CannotGetPaperInfoException(id, IDTYPE);
        }
        catch (IOException iOException) {
            throw new CannotGetPaperInfoException(id, IDTYPE);
        }
    }

    private String getTitle(String str) {
        String title = "";
        Pattern pattern = Pattern.compile("<span class=\\W+TEXT-TITLE\\W+>([\\p{Z}\\p{S}\\p{N}\\p{P}\\p{L}]+)</span><br><br><a h");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find(0)) {
            title = matcher.group(1);
        }
        return title;
    }

    private String getAbstract(String str) {
        String abstractText = "";
        Pattern pattern = Pattern.compile("\u7e3a\u3085\uff49\u7e3a\uff7e\u7e3a\ufffd&nbsp;</span><br><span class=\\W+TEXT-BODY\\W+>([\\p{M}\\p{Z}\\p{S}\\p{N}\\p{P}\\p{L}]+)</span><br>");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find(0)) {
            abstractText = matcher.group(1);
        }
        return abstractText;
    }

    private String getJournal(String str) {
        String journal = "";
        Pattern pattern = Pattern.compile("\u96b1\u609f\u9310</span><br>\\W+<span class=\\W+TEXT-BODY\\W+>([\\p{M}\\p{Z}\\p{S}\\p{N}\\p{P}\\p{L}]+?\\W[ABCD])</span>");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find(0)) {
            journal = matcher.group(1);
        }
        return journal;
    }

    private String getVolume(String str) {
        String volume = "";
        Pattern pattern = Pattern.compile("Vol.</span><span class=\\W+TEXT-BODY\\W+>(J\\d+-[ABCD]\\d*)</span>");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find(0)) {
            volume = matcher.group(1);
        }
        return volume;
    }

    private String getIssue(String str) {
        String number = "";
        Pattern pattern = Pattern.compile("No.</span><span class=\\W+TEXT-BODY\\W+>(\\d+)</span>");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find(0)) {
            number = matcher.group(1);
        }
        return number;
    }

    private String getPages(String str) {
        String pages = "";
        Pattern pattern = Pattern.compile("pp.</span><span class=\\W+TEXT-BODY\\W+>(\\d+-\\d+)</span>");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find(0)) {
            pages = matcher.group(1);
        }
        return pages;
    }

    private ArrayList<String> getAuthors(String str) throws UnsupportedEncodingException {
        ArrayList<String> authors = new ArrayList<String>();
        Pattern pattern = Pattern.compile("a_name=([%[0-9A-F]{2}]+)&category");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String tmp = matcher.group(1);
            authors.add(URLDecoder.decode(tmp, IEICE_JAPANESE_ENCODING));
        }
        return authors;
    }

    private String getAuthorString(ArrayList<String> authors) {
        StringBuffer authorString = new StringBuffer();
        int i = 0;
        i = 0;
        while (i < authors.size() - 1) {
            authorString.append(authors.get(i));
            authorString.append(", ");
            ++i;
        }
        authorString.append(authors.get(i));
        return authorString.toString();
    }

    private String getYear(String body) {
        String year = "";
        Pattern pattern = Pattern.compile("\u900b\uff7a\u9666\u68a7\u5f8b:&nbsp;</span><span class=\\W+TEXT-BODY\\W+>(\\d+)");
        Matcher matcher = pattern.matcher(body);
        if (matcher.find(0)) {
            year = matcher.group(1);
        }
        return year;
    }

    private String journalCategory(String id) {
        Pattern pattern = Pattern.compile("j\\d+-([abcd])\\d*_\\d+_\\d+");
        Matcher matcher = pattern.matcher(id);
        if (matcher.find(0)) {
            return matcher.group(1).toUpperCase();
        }
        return null;
    }

    private String getHTMLBody(String id) throws HttpException, IOException {
        String category = this.journalCategory(id);
        String target = null;
        target = category != null ? "http://search.ieice.org/bin/summary.php?id=" + id + "&lang=J&category=" + category : "http://search.ieice.org/bin/summary.php?id=" + id + "&lang=J";
        HttpClient client = new HttpClient();
        String proxyHost = FrameworkPlugin.getDefault().GetHttpProxyHost();
        if (proxyHost != null && proxyHost.length() != 0) {
            int proxyPort = Integer.valueOf(FrameworkPlugin.getDefault().GetHttpProxyPort());
            client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        }
        GetMethod method = new GetMethod(target);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        String responseBody = "";
        try {
            try {
                client.executeMethod((HttpMethod)method);
                String body = method.getResponseBodyAsString();
                responseBody = new String(EncodingUtil.getBytes((String)body, (String)"ISO-8859-1"), IEICE_JAPANESE_ENCODING);
            }
            catch (HttpException he) {
                throw he;
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
        finally {
            method.releaseConnection();
        }
        return responseBody;
    }
}

