/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.view;

import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class PaperLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private IMemento memento = null;
    public static int[] WIDTH;
    public static final String[] COLUMN;
    public static final int[] DEFAULT_WIDTH;
    public static final ViewerSorter[] SORTER;

    static {
        COLUMN = new String[]{"", "Author", "Title", "Journal", "Volume", "Year", "Issue", "Pages", "Id", "Id Type"};
        DEFAULT_WIDTH = new int[]{30, 100, 200, 100, 80, 50, 60, 50, 50, 50};
        SORTER = new ViewerSorter[]{new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                try {
                    return paper1.getPaperInfo().getFlag() - paper2.getPaperInfo().getFlag();
                }
                catch (CannotGetPaperInfoException e) {
                    IPapersPlugin.log.error((Object)e.getMessage());
                    return 0;
                }
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                try {
                    String author1 = paper1.getPaperInfo().getAuthor();
                    String author2 = paper2.getPaperInfo().getAuthor();
                    return author1.compareTo(author2);
                }
                catch (CannotGetPaperInfoException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                try {
                    String title1 = paper1.getPaperInfo().getTitle();
                    String title2 = paper2.getPaperInfo().getTitle();
                    return title1.compareTo(title2);
                }
                catch (CannotGetPaperInfoException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                try {
                    String journal1 = paper1.getPaperInfo().getJournal();
                    String journal2 = paper2.getPaperInfo().getJournal();
                    return journal1.compareTo(journal2);
                }
                catch (CannotGetPaperInfoException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                try {
                    String volume1 = paper1.getPaperInfo().getVolume();
                    String volume2 = paper2.getPaperInfo().getVolume();
                    return volume1.compareTo(volume2);
                }
                catch (CannotGetPaperInfoException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                try {
                    String year1 = paper1.getPaperInfo().getYear();
                    String year2 = paper2.getPaperInfo().getYear();
                    return year1.compareTo(year2);
                }
                catch (CannotGetPaperInfoException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                try {
                    String issue1 = paper1.getPaperInfo().getIssue();
                    String issue2 = paper2.getPaperInfo().getIssue();
                    return issue1.compareTo(issue2);
                }
                catch (CannotGetPaperInfoException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                try {
                    String pages1 = paper1.getPaperInfo().getPages();
                    String pages2 = paper2.getPaperInfo().getPages();
                    return pages1.compareTo(pages2);
                }
                catch (CannotGetPaperInfoException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return 0;
            }
        }, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Paper paper1 = (Paper)e1;
                Paper paper2 = (Paper)e2;
                String id1 = paper1.getId();
                String id2 = paper2.getId();
                return id1.compareTo(id2);
            }
        }};
    }

    public PaperLabelProvider(IMemento mem) {
        this.memento = mem;
        WIDTH = this.getColumnLayouts("TAG_COLUMN_WIDTH");
    }

    public String getColumnText(Object element, int columnIndex) {
        String columnText = null;
        try {
            Paper paper = (Paper)element;
            switch (columnIndex) {
                case 0: {
                    columnText = null;
                    break;
                }
                case 1: {
                    columnText = paper.getPaperInfo().getAuthor();
                    break;
                }
                case 2: {
                    columnText = paper.getPaperInfo().getTitle();
                    break;
                }
                case 3: {
                    columnText = paper.getPaperInfo().getJournal();
                    break;
                }
                case 4: {
                    columnText = paper.getPaperInfo().getVolume();
                    break;
                }
                case 5: {
                    columnText = paper.getPaperInfo().getYear();
                    break;
                }
                case 6: {
                    columnText = paper.getPaperInfo().getIssue();
                    break;
                }
                case 7: {
                    columnText = paper.getPaperInfo().getPages();
                    break;
                }
                case 8: {
                    columnText = paper.getId();
                    break;
                }
                case 9: {
                    columnText = paper.getIdType();
                    break;
                }
                default: {
                    columnText = null;
                    break;
                }
            }
        }
        catch (CannotGetPaperInfoException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
        }
        return columnText;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        try {
            PaperInfo info = ((Paper)element).getPaperInfo();
            switch (columnIndex) {
                case 0: {
                    switch (info.getFlag()) {
                        case 2: {
                            return IPapersPlugin.getDefault().getImageRegistry().get("concierge");
                        }
                        case 0: {
                            return IPapersPlugin.getDefault().getImageRegistry().get("unread");
                        }
                        case 4: {
                            return IPapersPlugin.getDefault().getImageRegistry().get("icon_pdf16");
                        }
                    }
                    return null;
                }
            }
            return null;
        }
        catch (CannotGetPaperInfoException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
            return null;
        }
    }

    public int[] getColumnLayouts(String name) {
        int[] results = new int[DEFAULT_WIDTH.length];
        int i = 0;
        while (i < DEFAULT_WIDTH.length) {
            Integer widthInt;
            int width = DEFAULT_WIDTH[i];
            if (this.memento != null && (widthInt = this.memento.getInteger(String.valueOf(name) + i)) != null && widthInt > 0) {
                width = widthInt;
            }
            results[i] = width;
            ++i;
        }
        return results;
    }
}

