/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.backupmanager.actions;

import java.io.File;
import java.util.List;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.backupmanager.actions.BaseAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public class BackupAction
extends BaseAction {
    public BackupAction(TableViewer tv) {
        super(tv);
    }

    public void run() {
        IStructuredSelection sel = (IStructuredSelection)this.tableviewer.getSelection();
        List docs = sel.toList();
        if (docs.size() == 0) {
            return;
        }
        boolean success = true;
        int i = 0;
        while (i < docs.size()) {
            Document doc = (Document)docs.get(i);
            String of = DataDomImpl.getFilePath((Document)doc);
            if (of != null && of.length() != 0) {
                File off = new File(of);
                if (off.exists()) {
                    FrameworkPlugin.importUserFile((String)of, (long)DomImpl.getID((Document)doc));
                    String path = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)doc));
                    File newf = new File(path);
                    newf.setLastModified(System.currentTimeMillis());
                } else {
                    success = false;
                }
            }
            ++i;
        }
        if (!success) {
            MessageDialog.openWarning((Shell)this.tableviewer.getControl().getShell(), (String)"Backup warning", (String)"Some items did not linked.");
        }
        this.tableviewer.update(docs.toArray(), null);
    }
}

