/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class GraphicUtil {
    public static void setForeground(Control ctrl, int id) {
        ctrl.setForeground(ctrl.getDisplay().getSystemColor(id));
    }

    public static void setBackground(Control ctrl, int id) {
        ctrl.setBackground(ctrl.getDisplay().getSystemColor(id));
    }

    public static Image loadImage(Display disp, String file) {
        ImageLoader iloader = new ImageLoader();
        ImageData[] ids = iloader.load(file);
        ImageData id = ids[0];
        return new Image((Device)disp, id);
    }

    public static Image loadImage(Control control, String file) {
        return GraphicUtil.loadImage(control.getDisplay(), file);
    }

    public static void saveImage(Image image, String file, int type) {
        ImageLoader iloader = new ImageLoader();
        ImageData oldid = image.getImageData();
        if (type == 0 && SystemUtil.GetOSType() != 0) {
            ImageData newid = new ImageData(oldid.width, oldid.height, 32, new PaletteData(0xFF0000, 65280, 255));
            newid.data = new byte[oldid.width * oldid.height * 4];
            int i = 0;
            while (i < oldid.height) {
                int j = 0;
                while (j < oldid.width) {
                    byte b;
                    byte r = oldid.data[4 * j + 1 + i * oldid.width * 4];
                    byte g = oldid.data[4 * j + 2 + i * oldid.width * 4];
                    newid.data[4 * j + i * oldid.width * 4 + 0] = b = oldid.data[4 * j + 3 + i * oldid.width * 4];
                    newid.data[4 * j + i * oldid.width * 4 + 1] = g;
                    newid.data[4 * j + i * oldid.width * 4 + 2] = r;
                    newid.data[4 * j + i * oldid.width * 4 + 3] = 0;
                    ++j;
                }
                ++i;
            }
            iloader.data = new ImageData[]{newid};
        } else {
            iloader.data = new ImageData[]{oldid};
        }
        iloader.save(file, type);
    }

    public static Image getResizedImage(Image img, int maxx, int maxy) {
        double ratio;
        ImageData id = img.getImageData();
        double ratiox = (double)maxx / (double)id.width;
        double ratioy = (double)maxy / (double)id.height;
        double d = ratio = ratiox > ratioy ? ratioy : ratiox;
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        ImageData nid = id.scaledTo((int)((double)id.width * ratio), (int)((double)id.height * ratio));
        Image nimg = new Image(img.getDevice(), nid);
        return nimg;
    }
}

