/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.BundleContext;

public class XoonipsLink2Plugin
extends AbstractDocumentUIPlugin {
    public static final String PLUGIN_ID = "jp.sourceforge.concierge.plugin.xoonipslink";
    private static XoonipsLink2Plugin plugin;
    public static ColorRegistry colorReg;
    public static FontRegistry fontReg;
    public static ImageRegistry imageReg;

    static {
        colorReg = null;
        fontReg = null;
        imageReg = null;
    }

    public XoonipsLink2Plugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static XoonipsLink2Plugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return XoonipsLink2Plugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Color newColor(Device device, int red, int green, int blue) {
        Color newColor;
        Color color;
        if (colorReg == null) {
            colorReg = new ColorRegistry();
        }
        if ((color = colorReg.get((newColor = new Color(device, red, green, blue)).toString())) == null) {
            colorReg.put(newColor.toString(), newColor.getRGB());
        } else {
            newColor.dispose();
            newColor = null;
            newColor = color;
        }
        return newColor;
    }

    public static Font newFont(Device device, String name, int height, int style) {
        Font newFont;
        Font font;
        if (fontReg == null) {
            fontReg = new FontRegistry();
        }
        if ((font = fontReg.get((newFont = new Font(device, name, height, style)).getFontData()[0].toString())) == null || !font.getFontData()[0].toString().equals(newFont.getFontData()[0].toString())) {
            fontReg.put(newFont.getFontData()[0].toString(), newFont.getFontData());
        } else {
            newFont.dispose();
            newFont = null;
            newFont = font;
        }
        return newFont;
    }

    public static Image loadImageFile(String path) {
        ImageDescriptor imgDes;
        Image newImage;
        if (imageReg == null) {
            imageReg = new ImageRegistry();
        }
        if ((newImage = imageReg.get(path)) == null && (newImage = (imgDes = XoonipsLink2Plugin.getImageDescriptor(path)).createImage()) != null) {
            imageReg.put(path, newImage);
        }
        return newImage;
    }

    public static void copyFile(File inFile, File outFile) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inFile));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
        XoonipsLink2Plugin.copyFile(is, os, true);
    }

    public static void copyFile(String inName, String outName) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inName));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outName));
        XoonipsLink2Plugin.copyFile(is, os, true);
    }

    public static void copyFile(InputStream is, OutputStream os, boolean close) throws IOException {
        int count;
        byte[] buf = new byte[0x100000];
        while ((count = is.read(buf, 0, 0x100000)) != -1) {
            os.write(buf, 0, count);
        }
        buf = null;
        is.close();
        if (close) {
            os.close();
        }
    }

    public Image createImageWithURL(String imageURL) {
        if (imageURL != null && imageURL.length() > 0) {
            URL url = null;
            try {
                url = new URL(imageURL);
                InputStream is = url.openStream();
                Image image = new Image((Device)this.getWorkbench().getDisplay(), is);
                is.close();
                return image;
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

