/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class ViewerUpdater {
    private final StructuredViewer viewer;

    protected ViewerUpdater(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public abstract void insert(Object var1, int var2);

    public abstract void remove(Object var1, int var2);

    public void replace(Object oldElement, Object newElement, int position) {
        this.remove(oldElement, position);
        this.insert(newElement, position);
    }

    public void move(Object element, int oldPosition, int newPosition) {
        if (this.viewer.getComparator() == null && this.viewer.getFilters().length == 0) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            this.remove(element, oldPosition);
            this.insert(element, newPosition);
            if (!selection.isEmpty()) {
                IElementComparer comparer = this.viewer.getComparer();
                Object[] selectedElements = selection.toArray();
                int i = 0;
                while (i < selectedElements.length) {
                    if (comparer == null ? Util.equals((Object)element, (Object)selectedElements[i]) : comparer.equals(element, selectedElements[i])) {
                        this.viewer.setSelection((ISelection)selection);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public abstract void add(Object[] var1);

    public abstract void remove(Object[] var1);
}

