/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public final class HippieCompletionEngine {
    private static final String COMPLETION_WORD_REGEX = "[\\p{L}[\\p{Mn}[\\p{Pc}[\\p{Nd}[\\p{Nl}[\\p{Sc}]]]]]]+";
    private static final Pattern COMPLETION_WORD_PATTERN = Pattern.compile("[\\p{L}[\\p{Mn}[\\p{Pc}[\\p{Nd}[\\p{Nl}[\\p{Sc}]]]]]]+");
    private static final String NON_EMPTY_COMPLETION_BOUNDARY = "[\\s\\p{Z}[\\p{P}&&[\\P{Pc}]][\\p{S}&&[\\P{Sc}]]]+";
    private static final String COMPLETION_BOUNDARY = "(^|[\\s\\p{Z}[\\p{P}&&[\\P{Pc}]][\\p{S}&&[\\P{Sc}]]]+)";
    private static final boolean CASE_SENSITIVE = true;

    private String asRegPattern(CharSequence string) {
        StringBuffer out = new StringBuffer(string.length());
        boolean quoting = false;
        int i = 0;
        int length = string.length();
        while (i < length) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
            } else {
                if (!quoting) {
                    out.append("\\Q");
                    quoting = true;
                }
                out.append(ch);
            }
            ++i;
        }
        if (quoting) {
            out.append("\\E");
        }
        return out.toString();
    }

    public List getCompletionsForward(IDocument document, CharSequence prefix, int firstPosition, boolean currentWordLast) throws BadLocationException {
        String searchPattern;
        ArrayList<String> res = new ArrayList<String>();
        String currentWordCompletion = null;
        if (firstPosition == document.getLength()) {
            return res;
        }
        FindReplaceDocumentAdapter searcher = new FindReplaceDocumentAdapter(document);
        if (firstPosition > 0) {
            --firstPosition;
            searchPattern = NON_EMPTY_COMPLETION_BOUNDARY + this.asRegPattern(prefix);
        } else {
            searchPattern = COMPLETION_BOUNDARY + this.asRegPattern(prefix);
        }
        IRegion reg = searcher.find(firstPosition, searchPattern, true, true, false, true);
        while (reg != null) {
            int nextPos;
            int wordSearchPos = reg.getOffset() + reg.getLength() - prefix.length();
            IRegion word = searcher.find(wordSearchPos, COMPLETION_WORD_REGEX, true, true, false, true);
            if (word.getLength() > prefix.length()) {
                String wholeWord = document.get(word.getOffset(), word.getLength());
                String completion = wholeWord.substring(prefix.length());
                if (currentWordLast && reg.getOffset() == firstPosition) {
                    currentWordCompletion = completion;
                } else {
                    res.add(completion);
                }
            }
            if ((nextPos = word.getOffset() + word.getLength()) >= document.getLength()) break;
            reg = searcher.find(nextPos, searchPattern, true, true, false, true);
        }
        if (currentWordCompletion != null) {
            res.add(currentWordCompletion);
        }
        return res;
    }

    public List getCompletionsBackwards(IDocument document, CharSequence prefix, int firstPosition) throws BadLocationException {
        ArrayList<String> res = new ArrayList<String>();
        if (firstPosition == 0) {
            return res;
        }
        FindReplaceDocumentAdapter searcher = new FindReplaceDocumentAdapter(document);
        String searchPattern = COMPLETION_BOUNDARY + this.asRegPattern(prefix);
        IRegion reg = searcher.find(0, searchPattern, true, true, false, true);
        while (reg != null) {
            int nextPos;
            int wordSearchPos = reg.getOffset() + reg.getLength() - prefix.length();
            IRegion word = searcher.find(wordSearchPos, COMPLETION_WORD_REGEX, true, true, false, true);
            if (word.getOffset() + word.getLength() > firstPosition) break;
            if (word.getLength() > prefix.length()) {
                String found = document.get(word.getOffset(), word.getLength());
                res.add(found.substring(prefix.length()));
            }
            if ((nextPos = word.getOffset() + word.getLength()) >= firstPosition) break;
            reg = searcher.find(nextPos, searchPattern, true, true, false, true);
        }
        Collections.reverse(res);
        return res;
    }

    public String getPrefixString(IDocument doc, int pos) throws BadLocationException {
        Matcher m = COMPLETION_WORD_PATTERN.matcher("");
        int prevNonAlpha = pos;
        while (prevNonAlpha > 0) {
            m.reset(doc.get(prevNonAlpha - 1, pos - prevNonAlpha + 1));
            if (!m.matches()) break;
            --prevNonAlpha;
        }
        if (prevNonAlpha != pos) {
            return doc.get(prevNonAlpha, pos - prevNonAlpha);
        }
        return null;
    }

    public List makeUnique(List suggestions) {
        HashSet<String> seenAlready = new HashSet<String>();
        ArrayList<String> uniqueSuggestions = new ArrayList<String>();
        Iterator i = suggestions.iterator();
        while (i.hasNext()) {
            String suggestion = (String)i.next();
            if (seenAlready.contains(suggestion)) continue;
            seenAlready.add(suggestion);
            uniqueSuggestions.add(suggestion);
        }
        return uniqueSuggestions;
    }
}

