/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import jp.sourceforge.concierge.plugin.IFileFilter;
import org.eclipse.swt.graphics.Image;
import org.pdfbox.pdmodel.PDDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfFilter2
implements IFileFilter {
    private PDDocument document;

    public PdfFilter2(String filename) throws IOException {
        this.document = PDDocument.load((String)filename);
    }

    @Override
    public String[] getDataNames() {
        return new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer", "Creation Date", "Modification Date"};
    }

    @Override
    public String getData(String name) {
        if (name.equals("Title")) {
            return this.document.getDocumentInformation().getTitle();
        }
        if (name.equals("Author")) {
            return this.document.getDocumentInformation().getAuthor();
        }
        if (name.equals("Subject")) {
            return this.document.getDocumentInformation().getSubject();
        }
        if (name.equals("Keywords")) {
            return this.document.getDocumentInformation().getKeywords();
        }
        if (name.equals("Creator")) {
            return this.document.getDocumentInformation().getCreator();
        }
        if (name.equals("Producer")) {
            return this.document.getDocumentInformation().getProducer();
        }
        if (name.equals("Creation Date")) {
            Calendar c;
            block14: {
                try {
                    c = this.document.getDocumentInformation().getCreationDate();
                    if (c != null) break block14;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return c.getTime().toString();
        }
        if (name.equals("Modification Date")) {
            Calendar c;
            block15: {
                try {
                    c = this.document.getDocumentInformation().getModificationDate();
                    if (c != null) break block15;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return c.getTime().toString();
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public ArrayList<Image> getImages() {
        return null;
    }

    @Override
    public void setThumbnail(Image img) {
    }

    @Override
    public String getText() {
        return null;
    }
}

