/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.VersionSupplier;

public class VersionHashMap
extends MappedList
implements Comparator {
    private ResolverImpl resolver;

    public VersionHashMap(ResolverImpl resolver) {
        this.resolver = resolver;
    }

    @Override
    protected void sort(Object[] values) {
        Arrays.sort(values, this);
    }

    @Override
    public void put(Object key, Object value) {
        Object[] existing = (Object[])this.internal.get(key);
        if (existing == null) {
            existing = new Object[]{value};
            this.internal.put(key, existing);
        } else {
            Object[] newValues = new Object[existing.length + 1];
            int index = existing.length;
            if (this.compare(existing[existing.length - 1], value) > 0 && (index = Arrays.binarySearch(existing, value, this)) < 0) {
                index = -index - 1;
            }
            System.arraycopy(existing, 0, newValues, 0, index);
            newValues[index] = value;
            System.arraycopy(existing, index, newValues, index + 1, existing.length - index);
            this.internal.put(key, newValues);
        }
    }

    public void put(VersionSupplier[] versionSuppliers) {
        int i = 0;
        while (i < versionSuppliers.length) {
            this.put(versionSuppliers[i].getName(), versionSuppliers[i]);
            ++i;
        }
    }

    public boolean contains(VersionSupplier vs) {
        return this.contains(vs, false) != null;
    }

    private VersionSupplier contains(VersionSupplier vs, boolean remove) {
        Object[] existing = (Object[])this.internal.get(vs.getName());
        if (existing == null) {
            return null;
        }
        int i = 0;
        while (i < existing.length) {
            if (existing[i] == vs) {
                if (remove) {
                    if (existing.length == 1) {
                        this.internal.remove(vs.getName());
                        return vs;
                    }
                    Object[] newExisting = new Object[existing.length - 1];
                    System.arraycopy(existing, 0, newExisting, 0, i);
                    if (i + 1 < existing.length) {
                        System.arraycopy(existing, i + 1, newExisting, i, existing.length - i - 1);
                    }
                    this.internal.put(vs.getName(), newExisting);
                }
                return vs;
            }
            ++i;
        }
        return null;
    }

    public Object remove(VersionSupplier toBeRemoved) {
        return this.contains(toBeRemoved, true);
    }

    public void remove(VersionSupplier[] versionSuppliers) {
        int i = 0;
        while (i < versionSuppliers.length) {
            this.remove(versionSuppliers[i]);
            ++i;
        }
    }

    void reorder() {
        for (Object[] existing : this.internal.values()) {
            if (existing.length <= 1) continue;
            this.sort(existing);
        }
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof VersionSupplier) || !(o2 instanceof VersionSupplier)) {
            throw new IllegalArgumentException();
        }
        VersionSupplier vs1 = (VersionSupplier)o1;
        VersionSupplier vs2 = (VersionSupplier)o2;
        if (this.resolver.getSelectionPolicy() != null) {
            return this.resolver.getSelectionPolicy().compare(vs1.getBaseDescription(), vs2.getBaseDescription());
        }
        String systemBundle = this.resolver.getSystemBundle();
        if (systemBundle.equals(vs1.getBundle().getSymbolicName()) && !systemBundle.equals(vs2.getBundle().getSymbolicName())) {
            return -1;
        }
        if (!systemBundle.equals(vs1.getBundle().getSymbolicName()) && systemBundle.equals(vs2.getBundle().getSymbolicName())) {
            return 1;
        }
        if (vs1.getBundle().isResolved() != vs2.getBundle().isResolved()) {
            return vs1.getBundle().isResolved() ? -1 : 1;
        }
        int versionCompare = -vs1.getVersion().compareTo(vs2.getVersion());
        if (versionCompare != 0) {
            return versionCompare;
        }
        return vs1.getBundle().getBundleId() <= vs2.getBundle().getBundleId() ? -1 : 1;
    }
}

