/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;

public class MultiSourcePackage
extends PackageSource {
    SingleSourcePackage[] suppliers;

    MultiSourcePackage(String id, SingleSourcePackage[] suppliers) {
        super(id);
        this.suppliers = suppliers;
    }

    @Override
    public SingleSourcePackage[] getSuppliers() {
        return this.suppliers;
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        Class result = null;
        int i = 0;
        while (i < this.suppliers.length) {
            result = this.suppliers[i].loadClass(name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        int i = 0;
        while (i < this.suppliers.length) {
            result = this.suppliers[i].getResource(name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    @Override
    public Enumeration getResources(String name) {
        Enumeration results = null;
        int i = 0;
        while (i < this.suppliers.length) {
            results = BundleLoader.compoundEnumerations(results, this.suppliers[i].getResources(name));
            ++i;
        }
        return results;
    }
}

