/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net.proxy.win32.winhttp;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.proxy.win32.winhttp.AutoProxyHolder;
import org.eclipse.core.internal.net.proxy.win32.winhttp.ProxyBypass;
import org.eclipse.core.internal.net.proxy.win32.winhttp.ProxyProviderUtil;
import org.eclipse.core.internal.net.proxy.win32.winhttp.StaticProxyConfig;
import org.eclipse.core.internal.net.proxy.win32.winhttp.WinHttp;
import org.eclipse.core.internal.net.proxy.win32.winhttp.WinHttpAutoProxyOptions;
import org.eclipse.core.internal.net.proxy.win32.winhttp.WinHttpCurrentUserIEProxyConfig;
import org.eclipse.core.internal.net.proxy.win32.winhttp.WinHttpProxyInfo;
import org.eclipse.core.net.proxy.IProxyData;

public class WinHttpProxyProvider {
    private WinHttpCurrentUserIEProxyConfig proxyConfig;
    private StaticProxyConfig staticProxyConfig;
    private String wpadAutoConfigUrl;
    private boolean tryWpadGetUrl;
    private boolean tryPac;
    private String logMessage;
    private Throwable logThrowable;
    private static final ProxyData[] EMPTY_PROXIES = new ProxyData[0];
    private static final String MY_NAME = WinHttpProxyProvider.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProxyData[] getProxyData(URI uri) {
        IProxyData[] proxies;
        this.logMessage = null;
        WinHttpProxyProvider winHttpProxyProvider = this;
        synchronized (winHttpProxyProvider) {
            proxies = this.getProxyDataUnsynchronized(uri);
        }
        if (this.logMessage != null) {
            Activator.logError(this.logMessage, this.logThrowable);
        }
        return proxies;
    }

    private IProxyData[] getProxyDataUnsynchronized(URI uri) {
        WinHttpCurrentUserIEProxyConfig newProxyConfig = new WinHttpCurrentUserIEProxyConfig();
        if (!WinHttp.getIEProxyConfigForCurrentUser(newProxyConfig)) {
            this.logError("WinHttp.GetIEProxyConfigForCurrentUser failed with error '" + WinHttp.getLastErrorMessage() + "' #" + WinHttp.getLastError() + ".", null);
            return EMPTY_PROXIES;
        }
        ArrayList proxies = new ArrayList();
        if (newProxyConfig.autoDetectChanged(this.proxyConfig)) {
            this.tryWpadGetUrl = newProxyConfig.isAutoDetect();
            if (!this.tryWpadGetUrl) {
                this.wpadAutoConfigUrl = null;
            }
        }
        if (newProxyConfig.autoConfigUrlChanged(this.proxyConfig)) {
            this.tryPac = newProxyConfig.isAutoConfigUrl();
        }
        if (newProxyConfig.isStaticProxy()) {
            if (newProxyConfig.staticProxyChanged(this.proxyConfig)) {
                this.staticProxyConfig = new StaticProxyConfig(newProxyConfig.getProxy(), newProxyConfig.getProxyBypass());
            }
            this.staticProxyConfig.select(uri, proxies);
        }
        this.proxyConfig = newProxyConfig;
        if (!this.tryPac && this.wpadAutoConfigUrl == null) {
            return WinHttpProxyProvider.toArray(proxies);
        }
        int hHttpSession = WinHttp.open(MY_NAME, 1, WinHttp.NO_PROXY_NAME, WinHttp.NO_PROXY_BYPASS, 0);
        if (hHttpSession == 0) {
            this.logError("WinHttp.Open failed with error'" + WinHttp.getLastErrorMessage() + "' #" + WinHttp.getLastError() + ".", null);
            return WinHttpProxyProvider.toArray(proxies);
        }
        try {
            this.pacSelect(hHttpSession, uri, proxies);
            this.wpadSelect(hHttpSession, uri, proxies);
        }
        finally {
            WinHttp.closeHandle(hHttpSession);
        }
        return WinHttpProxyProvider.toArray(proxies);
    }

    protected void pacSelect(int hHttpSession, URI uri, List proxies) {
        if (!this.tryPac) {
            return;
        }
        List pacProxies = this.pacSelect(hHttpSession, this.proxyConfig.getAutoConfigUrl(), uri);
        if (pacProxies == null) {
            this.tryPac = false;
        } else {
            proxies.addAll(pacProxies);
        }
    }

    protected void wpadSelect(int hHttpSession, URI uri, List proxies) {
        if (this.tryWpadGetUrl) {
            this.tryWpadGetUrl = false;
            AutoProxyHolder autoProxyHolder = new AutoProxyHolder();
            autoProxyHolder.setAutoDetectFlags(3);
            boolean ok = WinHttp.detectAutoProxyConfigUrl(autoProxyHolder);
            if (!ok) {
                this.logError("WinHttp.DetectAutoProxyConfigUrl for wpad failed with error '" + WinHttp.getLastErrorMessage() + "' #" + WinHttp.getLastError() + ".", null);
                return;
            }
            this.wpadAutoConfigUrl = autoProxyHolder.getAutoConfigUrl();
        }
        if (this.wpadAutoConfigUrl == null) {
            return;
        }
        List wpadProxies = this.pacSelect(hHttpSession, this.wpadAutoConfigUrl, uri);
        if (wpadProxies == null) {
            this.wpadAutoConfigUrl = null;
        } else {
            proxies.addAll(wpadProxies);
        }
    }

    protected List pacSelect(int hHttpSession, String configUrl, URI uri) {
        if (!"HTTP".equalsIgnoreCase(uri.getScheme()) && !"HTTPS".equalsIgnoreCase(uri.getScheme())) {
            return Collections.EMPTY_LIST;
        }
        WinHttpAutoProxyOptions autoProxyOptions = new WinHttpAutoProxyOptions();
        autoProxyOptions.setFlags(2);
        autoProxyOptions.setAutoConfigUrl(configUrl);
        autoProxyOptions.setAutoLogonIfChallenged(true);
        WinHttpProxyInfo proxyInfo = new WinHttpProxyInfo();
        boolean ok = WinHttp.getProxyForUrl(hHttpSession, uri.toString(), autoProxyOptions, proxyInfo);
        if (!ok) {
            this.logError("WinHttp.GetProxyForUrl for pac failed with error '" + WinHttp.getLastErrorMessage() + "' #" + WinHttp.getLastError() + ".", null);
            return null;
        }
        ProxyBypass proxyBypass = new ProxyBypass(proxyInfo.getProxyBypass());
        if (proxyBypass.bypassProxyFor(uri)) {
            return Collections.EMPTY_LIST;
        }
        return ProxyProviderUtil.getProxies(proxyInfo.getProxy());
    }

    private void logError(String message, Throwable throwable) {
        this.logMessage = message;
        this.logThrowable = throwable;
    }

    private static IProxyData[] toArray(List proxies) {
        return proxies.toArray(new IProxyData[proxies.size()]);
    }
}

