/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.widget;

import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.plugin.searcher.widget.KeywordComposite;
import jp.sourceforge.concierge.plugin.searcher.widget.PeriodComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.w3c.dom.Element;

public class SearchComposite
extends Composite {
    private PeriodComposite periodComp;
    private KeywordComposite wordComp;
    private Action updateAction;

    public SearchComposite(Composite parent, int style, boolean expandable) {
        super(parent, style);
        ExpandableComposite comp;
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        Composite base = new Composite((Composite)this, 0);
        base.setLayout((Layout)new GridLayout(1, false));
        base.setLayoutData((Object)new GridData(1808));
        this.wordComp = new KeywordComposite(base, 0);
        this.wordComp.setLayoutData(new GridData(768));
        Label seplatorLabel = new Label(base, 258);
        seplatorLabel.setLayoutData((Object)new GridData(768));
        if (expandable) {
            comp = new ExpandableComposite(base, 2);
            comp.setText("Options");
        } else {
            comp = new Composite(base, 0);
        }
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(1808));
        if (expandable) {
            this.periodComp = new PeriodComposite((Composite)comp);
            ExpandableComposite ec = comp;
            ec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    if (SearchComposite.this.updateAction != null) {
                        SearchComposite.this.updateAction.run();
                    }
                }
            });
            ec.setClient((Control)this.periodComp);
        } else {
            this.periodComp = new PeriodComposite((Composite)comp);
            this.periodComp.setLayoutData(new GridData(768));
        }
    }

    public void setUpdateAction(Action action) {
        this.updateAction = action;
        this.periodComp.setUpdateAction(action);
        this.wordComp.setUpdateAction(action);
    }

    public String getXPath() {
        String kxp = this.wordComp.getXPath();
        String dxp = this.periodComp.getXPath();
        if (kxp.length() == 0 && dxp.length() == 0) {
            return "";
        }
        String xpath = "";
        xpath = kxp.length() == 0 ? dxp : (dxp.length() == 0 ? kxp : "(" + kxp + ") and (" + dxp + ")");
        System.err.println(xpath);
        return "/mdata[" + xpath + "]";
    }

    public void update() {
        this.wordComp.update();
        this.periodComp.update();
    }

    public void load(Element info) {
        this.wordComp.load(info);
        this.periodComp.load(info);
        this.wordComp.update();
        this.periodComp.update();
        this.getParent().layout();
    }

    public void save(Element info) {
        Configure.setXPath(info, this.getXPath());
        this.wordComp.save(info);
        this.periodComp.save(info);
        this.wordComp.update();
        this.periodComp.update();
    }

    public KeywordComposite getKeywordComposite() {
        return this.wordComp;
    }

    public PeriodComposite getPeriodComposite() {
        return this.periodComp;
    }
}

