/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.texteditor.CompoundEditExitStrategy;
import org.eclipse.ui.internal.texteditor.HippieCompletionEngine;
import org.eclipse.ui.internal.texteditor.ICompoundEditListener;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

final class HippieCompleteAction
extends TextEditorAction {
    private IDocument fDocument;
    private CompletionState fLastCompletion = null;
    private final HippieCompletionEngine fEngine = new HippieCompletionEngine();
    private final CompoundEditExitStrategy fExitStrategy = new CompoundEditExitStrategy("org.eclipse.ui.edit.text.hippieCompletion");

    HippieCompleteAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.fExitStrategy.addCompoundListener(new ICompoundEditListener(){

            @Override
            public void endCompoundEdit() {
                HippieCompleteAction.this.clearState();
            }
        });
    }

    private void clearState() {
        IRewriteTarget target;
        this.fLastCompletion = null;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class)) != null) {
            this.fExitStrategy.disarm();
            target.endCompoundChange();
        }
        this.fDocument = null;
    }

    private void completeNext() {
        try {
            this.fDocument.replace(this.fLastCompletion.startOffset, this.fLastCompletion.length, this.fLastCompletion.suggestions[this.fLastCompletion.nextSuggestion]);
        }
        catch (BadLocationException e) {
            this.log(e);
            this.clearState();
            return;
        }
        this.fLastCompletion.advance();
        ISourceViewer sourceViewer = ((AbstractTextEditor)this.getTextEditor()).getSourceViewer();
        sourceViewer.setSelectedRange(this.fLastCompletion.startOffset + this.fLastCompletion.length, 0);
        sourceViewer.revealRange(this.fLastCompletion.startOffset, this.fLastCompletion.length);
        this.fExitStrategy.arm((ITextViewer)((AbstractTextEditor)this.getTextEditor()).getSourceViewer());
    }

    private ArrayList createSuggestionsFromOpenDocument(String prefix) throws BadLocationException {
        int selectionOffset = this.getSelectionOffset();
        ArrayList completions = new ArrayList();
        completions.addAll(this.fEngine.getCompletionsBackwards(this.fDocument, prefix, selectionOffset));
        completions.addAll(this.fEngine.getCompletionsForward(this.fDocument, prefix, selectionOffset - prefix.length(), true));
        return completions;
    }

    private IDocument getCurrentDocument() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return null;
        }
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        IDocument document = provider.getDocument(editor.getEditorInput());
        return document;
    }

    private String getCurrentPrefix() throws BadLocationException {
        ITextSelection selection = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
        if (selection.getLength() > 0) {
            return null;
        }
        return this.fEngine.getPrefixString(this.fDocument, selection.getOffset());
    }

    private int getSelectionOffset() {
        return ((ITextSelection)this.getTextEditor().getSelectionProvider().getSelection()).getOffset();
    }

    private String[] getSuggestions(String prefix) throws BadLocationException {
        ArrayList suggestions = this.createSuggestionsFromOpenDocument(prefix);
        IWorkbenchWindow window = this.getTextEditor().getSite().getWorkbenchWindow();
        IEditorReference[] editorsArray = window.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorsArray.length) {
            IEditorPart realEditor = editorsArray[i].getEditor(false);
            if (realEditor instanceof ITextEditor && !realEditor.equals(this.getTextEditor())) {
                ITextEditor textEditor = (ITextEditor)realEditor;
                IEditorInput input = textEditor.getEditorInput();
                IDocument doc = textEditor.getDocumentProvider().getDocument(input);
                suggestions.addAll(this.fEngine.getCompletionsForward(doc, prefix, 0, false));
            }
            ++i;
        }
        suggestions.add("");
        List uniqueSuggestions = this.fEngine.makeUnique(suggestions);
        return uniqueSuggestions.toArray(new String[0]);
    }

    private boolean isStateValid() {
        return this.fDocument != null && this.fDocument.equals(this.getCurrentDocument()) && this.fLastCompletion != null && this.fLastCompletion.startOffset + this.fLastCompletion.length == this.getSelectionOffset();
    }

    private void notifyUser() {
        this.getTextEditor().getSite().getShell().getDisplay().beep();
    }

    public void run() {
        if (!this.validateEditorInputState()) {
            return;
        }
        if (!this.isStateValid()) {
            this.updateState();
        }
        if (this.isStateValid()) {
            this.completeNext();
        }
    }

    public boolean isEnabled() {
        return this.canModifyEditor();
    }

    @Override
    public void setEditor(ITextEditor editor) {
        this.clearState();
        super.setEditor(editor);
    }

    private void updateState() {
        Assert.isNotNull((Object)this.getTextEditor());
        this.clearState();
        IDocument document = this.getCurrentDocument();
        if (document != null) {
            String[] suggestions;
            this.fDocument = document;
            try {
                String prefix = this.getCurrentPrefix();
                if (prefix == null) {
                    this.notifyUser();
                    return;
                }
                suggestions = this.getSuggestions(prefix);
            }
            catch (BadLocationException e) {
                this.log(e);
                return;
            }
            if (suggestions.length == 1) {
                this.notifyUser();
                return;
            }
            IRewriteTarget target = (IRewriteTarget)this.getTextEditor().getAdapter(IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            this.fLastCompletion = new CompletionState(suggestions, this.getSelectionOffset());
        }
    }

    private void log(BadLocationException e) {
        String msg = e.getLocalizedMessage();
        if (msg == null) {
            msg = "unable to access the document";
        }
        TextEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.workbench.texteditor", 0, msg, (Throwable)e));
    }

    private static class CompletionState {
        int length;
        int nextSuggestion;
        final int startOffset;
        final String[] suggestions;

        CompletionState(String[] suggestions, int startOffset) {
            this.suggestions = suggestions;
            this.startOffset = startOffset;
            this.length = 0;
            this.nextSuggestion = 0;
        }

        public void advance() {
            this.length = this.suggestions[this.nextSuggestion].length();
            this.nextSuggestion = (this.nextSuggestion + 1) % this.suggestions.length;
        }
    }
}

