/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.core.connection.IResponse;
import org.eclipse.update.search.IUpdateSiteAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdatePolicy {
    private static final String TAG_POLICY = "update-policy";
    private static final String TAG_URL_MAP = "url-map";
    private static final String ATT_URL = "url";
    private static final String ATT_PATTERN = "pattern";
    private static final String ATT_TYPE = "url-type";
    private static final String ATT_TYPE_VALUE_UPDATE = "update";
    private static final String ATT_TYPE_VALUE_DISCOVERY = "discovery";
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private ArrayList entries = new ArrayList();
    private ArrayList discoveryEntries = new ArrayList();
    private IUpdateSiteAdapter defaultSite;
    private IUpdateSiteAdapter defaultDiscoverySite;
    private boolean loaded = false;
    private boolean fallbackAllowed = true;

    public void load(URL mapFile, IProgressMonitor monitor) throws CoreException {
        InputStream policyStream;
        block15: {
            block16: {
                policyStream = null;
                IResponse response = ConnectionFactory.get(mapFile);
                UpdateManagerUtils.checkConnectionResult(response, mapFile);
                policyStream = response.getInputStream(monitor);
                if (policyStream != null) break block15;
                if (policyStream == null) break block16;
                try {
                    policyStream.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
        try {
            try {
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                Document doc = parser.parse(new InputSource(policyStream));
                this.processUpdatePolicy(doc);
                this.loaded = true;
            }
            catch (IOException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteURLFactory_UnableToAccessSiteStream, (Object[])new String[]{mapFile == null ? "" : mapFile.toExternalForm()}), 42, e);
            }
            catch (SAXException e) {
                throw Utilities.newCoreException(Messages.UpdatePolicy_parsePolicy, 0, e);
            }
            catch (ParserConfigurationException e) {
                throw Utilities.newCoreException(Messages.UpdatePolicy_parsePolicy, 0, e);
            }
        }
        catch (Throwable throwable) {
            if (policyStream != null) {
                try {
                    policyStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (policyStream != null) {
            try {
                policyStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public IUpdateSiteAdapter getMappedSite(String id) {
        UpdateMapEntry lastEntry = null;
        int i = 0;
        while (i < this.entries.size()) {
            UpdateMapEntry entry = (UpdateMapEntry)this.entries.get(i);
            if (entry.matches(id)) {
                if (lastEntry == null) {
                    lastEntry = entry;
                } else {
                    String pattern = entry.getPattern();
                    String lastPattern = lastEntry.getPattern();
                    if (pattern.length() > lastPattern.length()) {
                        lastEntry = entry;
                    }
                }
            }
            ++i;
        }
        if (lastEntry != null) {
            return lastEntry.getSite();
        }
        return this.defaultSite;
    }

    public IUpdateSiteAdapter getMappedDiscoverySite(String id) {
        UpdateMapEntry lastEntry = null;
        int i = 0;
        while (i < this.discoveryEntries.size()) {
            UpdateMapEntry entry = (UpdateMapEntry)this.discoveryEntries.get(i);
            if (entry.matches(id)) {
                if (lastEntry == null) {
                    lastEntry = entry;
                } else {
                    String pattern = entry.getPattern();
                    String lastPattern = lastEntry.getPattern();
                    if (pattern.length() > lastPattern.length()) {
                        lastEntry = entry;
                    }
                }
            }
            ++i;
        }
        if (lastEntry != null) {
            return lastEntry.getSite();
        }
        return this.defaultDiscoverySite;
    }

    public boolean isFallbackAllowed() {
        return this.fallbackAllowed;
    }

    private void reset() {
        if (!this.entries.isEmpty()) {
            this.entries.clear();
        }
        if (!this.discoveryEntries.isEmpty()) {
            this.discoveryEntries.clear();
        }
    }

    private void processUpdatePolicy(Document document) throws CoreException {
        Element root = document.getDocumentElement();
        this.reset();
        if (!root.getNodeName().equals(TAG_POLICY)) {
            this.throwCoreException("'update-policy" + Messages.UpdatePolicy_policyExpected, null);
        }
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            String tag;
            Node child = nodes.item(i);
            if (child.getNodeType() == 1 && (tag = child.getNodeName()).equals(TAG_URL_MAP)) {
                this.processMapNode(child);
            }
            ++i;
        }
    }

    private void processMapNode(Node node) throws CoreException {
        String pattern = this.getAttribute(node, ATT_PATTERN);
        String urlName = this.getAttribute(node, ATT_URL);
        String type = this.getAttribute(node, ATT_TYPE);
        this.assertNotNull(ATT_PATTERN, pattern);
        this.assertNotNull(ATT_URL, urlName);
        if (urlName.trim().length() == 0) {
            this.addUpdateEntry(pattern, null, type);
            return;
        }
        try {
            URL url = new URL(urlName);
            URL resolvedURL = URLEncoder.encode(url);
            this.addUpdateEntry(pattern, resolvedURL, type);
        }
        catch (MalformedURLException malformedURLException) {
            this.throwCoreException(String.valueOf(Messages.UpdatePolicy_invalidURL) + urlName, null);
        }
    }

    private void assertNotNull(String name, String value) throws CoreException {
        if (value == null) {
            this.throwCoreException(String.valueOf(name) + Messages.UpdatePolicy_nameNoNull, null);
        }
    }

    private String getAttribute(Node node, String name) {
        NamedNodeMap attMap = node.getAttributes();
        Node att = attMap.getNamedItem(name);
        if (att == null) {
            return null;
        }
        return att.getNodeValue();
    }

    private void addUpdateEntry(String pattern, URL url, String type) {
        if (pattern.equalsIgnoreCase("*")) {
            if (type == null) {
                this.defaultSite = new MapSite(url);
            } else if (type.equals(ATT_TYPE_VALUE_UPDATE)) {
                this.defaultSite = new MapSite(url);
            } else if (type.equals(ATT_TYPE_VALUE_DISCOVERY)) {
                this.defaultDiscoverySite = new MapSite(url);
            } else {
                this.defaultSite = new MapSite(url);
                this.defaultDiscoverySite = new MapSite(url);
            }
        } else if (type == null) {
            this.entries.add(new UpdateMapEntry(pattern, url));
        } else if (type.equals(ATT_TYPE_VALUE_UPDATE)) {
            this.entries.add(new UpdateMapEntry(pattern, url));
        } else if (type.equals(ATT_TYPE_VALUE_DISCOVERY)) {
            this.discoveryEntries.add(new UpdateMapEntry(pattern, url));
        } else {
            this.entries.add(new UpdateMapEntry(pattern, url));
            this.discoveryEntries.add(new UpdateMapEntry(pattern, url));
        }
    }

    private void throwCoreException(String message, Throwable e) throws CoreException {
        String fullMessage = String.valueOf(Messages.UpdatePolicy_UpdatePolicy) + message;
        throw Utilities.newCoreException(fullMessage, 0, e);
    }

    private static class MapSite
    implements IUpdateSiteAdapter {
        private URL url;

        public MapSite(URL url) {
            this.url = url;
        }

        @Override
        public String getLabel() {
            if (this.url == null) {
                return "";
            }
            return this.url.toString();
        }

        @Override
        public URL getURL() {
            return this.url;
        }
    }

    private static class UpdateMapEntry {
        private IUpdateSiteAdapter site;
        private String pattern;

        public UpdateMapEntry(String pattern, URL url) {
            this.pattern = pattern;
            this.site = new MapSite(url);
        }

        public IUpdateSiteAdapter getSite() {
            return this.site;
        }

        public boolean matches(String id) {
            return id.startsWith(this.pattern);
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

