/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IToggleSiteOperation;
import org.eclipse.update.operations.OperationsManager;

public class ToggleSiteOperation
extends Operation
implements IToggleSiteOperation {
    private IConfiguredSite site;

    public ToggleSiteOperation(IConfiguredSite site) {
        this.site = site;
    }

    @Override
    public boolean execute(IProgressMonitor monitor, IOperationListener listener) throws CoreException {
        if (this.site == null) {
            return false;
        }
        boolean oldValue = this.site.isEnabled();
        this.site.setEnabled(!oldValue);
        IStatus status = OperationsManager.getValidator().validateCurrentState();
        if (status != null) {
            this.site.setEnabled(oldValue);
            throw new CoreException(status);
        }
        try {
            boolean restartNeeded = SiteManager.getLocalSite().save();
            OperationsManager.fireObjectChanged(this.site, "");
            return restartNeeded;
        }
        catch (CoreException e) {
            this.site.setEnabled(oldValue);
            UpdateUtils.logException(e);
            throw e;
        }
    }
}

