/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public class IncludedFeatureReference
extends IncludedFeatureReferenceModel
implements IIncludedFeatureReference {
    public IncludedFeatureReference() {
    }

    public IncludedFeatureReference(IIncludedFeatureReference includedFeatureRef) {
        super((IncludedFeatureReferenceModel)((Object)includedFeatureRef));
    }

    public IncludedFeatureReference(IFeatureReference featureReference) {
        super(featureReference);
    }

    public IncludedFeatureReference(IncludedFeatureReferenceModel includedFeatureRefModel) {
        super(includedFeatureRefModel);
    }

    private boolean isDisabled() {
        IConfiguredSite cSite = this.getSite().getCurrentConfiguredSite();
        if (cSite == null) {
            return false;
        }
        IFeatureReference[] configured = cSite.getConfiguredFeatures();
        int i = 0;
        while (i < configured.length) {
            if (this.equals(configured[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isUninstalled() {
        if (!this.isDisabled()) {
            return false;
        }
        ISiteFeatureReference[] installed = this.getSite().getFeatureReferences();
        int i = 0;
        while (i < installed.length) {
            if (this.equals(installed[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public IFeature getFeature(boolean perfectMatch, IConfiguredSite configuredSite) throws CoreException {
        return this.getFeature(null);
    }

    @Override
    public IFeature getFeature(boolean perfectMatch, IConfiguredSite configuredSite, IProgressMonitor monitor) throws CoreException {
        return this.getFeature(monitor);
    }

    @Override
    public IFeature getFeature() throws CoreException {
        return this.getFeature(null);
    }

    @Override
    public IFeature getFeature(IProgressMonitor monitor) throws CoreException {
        if (this.isUninstalled()) {
            throw new CoreException((IStatus)new Status(4, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.IncludedFeatureReference_featureUninstalled, (Object[])new String[]{this.getFeatureIdentifier()}), null));
        }
        return super.getFeature(monitor);
    }
}

