/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class FormImages {
    private static FormImages instance;
    private HashMap images;
    private HashMap ids;

    public static FormImages getInstance() {
        if (instance == null) {
            instance = new FormImages();
        }
        return instance;
    }

    private FormImages() {
    }

    public Image getGradient(Display display, Color color1, Color color2, int realtheight, int theight, int marginHeight) {
        this.checkHashMaps();
        SimpleImageIdentifier id = new SimpleImageIdentifier(display, color1, color2, realtheight, theight, marginHeight);
        ImageReference result = (ImageReference)this.images.get(id);
        if (result != null && !result.getImage().isDisposed()) {
            result.incCount();
            return result.getImage();
        }
        Image image = this.createGradient(display, color1, color2, realtheight, theight, marginHeight);
        this.images.put(id, new ImageReference(image));
        this.ids.put(image, id);
        return image;
    }

    public Image getGradient(Display display, Color[] colors, int[] percents, int length, boolean vertical, Color bg) {
        this.checkHashMaps();
        ComplexImageIdentifier id = new ComplexImageIdentifier(display, colors, length, percents, vertical, bg);
        ImageReference result = (ImageReference)this.images.get(id);
        if (result != null && !result.getImage().isDisposed()) {
            result.incCount();
            return result.getImage();
        }
        Image image = this.createGradient(display, colors, percents, length, vertical, bg);
        this.images.put(id, new ImageReference(image));
        this.ids.put(image, id);
        return image;
    }

    public boolean markFinished(Image image) {
        ImageReference ref;
        this.checkHashMaps();
        ImageIdentifier id = (ImageIdentifier)this.ids.get(image);
        if (id != null && (ref = (ImageReference)this.images.get(id)) != null) {
            if (ref.decCount()) {
                this.images.remove(id);
                this.ids.remove(ref.getImage());
                ref.getImage().dispose();
                this.validateHashMaps();
            }
            return true;
        }
        image.dispose();
        return false;
    }

    private void checkHashMaps() {
        if (this.images == null) {
            this.images = new HashMap();
        }
        if (this.ids == null) {
            this.ids = new HashMap();
        }
    }

    private void validateHashMaps() {
        if (this.images.size() == 0) {
            this.images = null;
        }
        if (this.ids.size() == 0) {
            this.ids = null;
        }
    }

    private Image createGradient(Display display, Color color1, Color color2, int realtheight, int theight, int marginHeight) {
        Image image = new Image((Device)display, 1, realtheight);
        image.setBackground(color1);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color1);
        gc.fillRectangle(0, 0, 1, realtheight);
        gc.setForeground(color2);
        gc.setBackground(color1);
        gc.fillGradientRectangle(0, marginHeight + 2, 1, theight - 2, true);
        gc.dispose();
        return image;
    }

    private Image createGradient(Display display, Color[] colors, int[] percents, int length, boolean vertical, Color bg) {
        int width = vertical ? 1 : length;
        int height = vertical ? length : 1;
        Image gradient = new Image((Device)display, Math.max(width, 1), Math.max(height, 1));
        GC gc = new GC((Drawable)gradient);
        this.drawTextGradient(gc, width, height, colors, percents, vertical, bg);
        gc.dispose();
        return gradient;
    }

    private void drawTextGradient(GC gc, int width, int height, Color[] colors, int[] percents, boolean vertical, Color bg) {
        Color oldBackground = gc.getBackground();
        if (colors.length == 1) {
            if (colors[0] != null) {
                gc.setBackground(colors[0]);
            }
            gc.fillRectangle(0, 0, width, height);
        } else {
            Color oldForeground = gc.getForeground();
            Color lastColor = colors[0];
            if (lastColor == null) {
                lastColor = oldBackground;
            }
            int pos = 0;
            int i = 0;
            while (i < percents.length) {
                gc.setForeground(lastColor);
                lastColor = colors[i + 1];
                if (lastColor == null) {
                    lastColor = oldBackground;
                }
                gc.setBackground(lastColor);
                if (vertical) {
                    int gradientHeight = percents[i] * height / 100;
                    gc.fillGradientRectangle(0, pos, width, gradientHeight, true);
                    pos += gradientHeight;
                } else {
                    int gradientWidth = percents[i] * height / 100;
                    gc.fillGradientRectangle(pos, 0, gradientWidth, height, false);
                    pos += gradientWidth;
                }
                ++i;
            }
            if (vertical && pos < height) {
                if (bg != null) {
                    gc.setBackground(bg);
                }
                gc.fillRectangle(0, pos, width, height - pos);
            }
            if (!vertical && pos < width) {
                if (bg != null) {
                    gc.setBackground(bg);
                }
                gc.fillRectangle(pos, 0, width - pos, height);
            }
            gc.setForeground(oldForeground);
        }
    }

    private class ComplexImageIdentifier
    extends ImageIdentifier {
        RGB fBgRGB;
        boolean fVertical;
        int[] fPercents;

        public ComplexImageIdentifier(Display display, Color[] colors, int length, int[] percents, boolean vertical, Color bg) {
            super(display, colors, length);
            this.fBgRGB = bg == null ? null : bg.getRGB();
            this.fVertical = vertical;
            this.fPercents = percents;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ComplexImageIdentifier) {
                ComplexImageIdentifier id = (ComplexImageIdentifier)obj;
                if (super.equals(obj) && id.fVertical == this.fVertical && Arrays.equals(id.fPercents, this.fPercents)) {
                    if (id.fBgRGB == null && this.fBgRGB == null || id.fBgRGB != null && id.fBgRGB.equals((Object)this.fBgRGB)) {
                        return true;
                    }
                    int sum = 0;
                    int i = 0;
                    while (i < this.fPercents.length) {
                        sum += this.fPercents[i];
                        ++i;
                    }
                    if (sum >= 100) {
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = hash * 7 + new Boolean(this.fVertical).hashCode();
            int i = 0;
            while (i < this.fPercents.length) {
                hash = hash * 7 + new Integer(this.fPercents[i]).hashCode();
                ++i;
            }
            return hash;
        }
    }

    private abstract class ImageIdentifier {
        Display fDisplay;
        RGB[] fRGBs;
        int fLength;

        ImageIdentifier(Display display, Color[] colors, int length) {
            this.fDisplay = display;
            this.fRGBs = new RGB[colors.length];
            int i = 0;
            while (i < colors.length) {
                Color color = colors[i];
                this.fRGBs[i] = color == null ? null : color.getRGB();
                ++i;
            }
            this.fLength = length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImageIdentifier) {
                ImageIdentifier id = (ImageIdentifier)obj;
                if (id.fRGBs.length == this.fRGBs.length) {
                    boolean result = id.fDisplay.equals(this.fDisplay) && id.fLength == this.fLength;
                    int i = 0;
                    while (i < this.fRGBs.length && result) {
                        result = result && id.fRGBs[i].equals((Object)this.fRGBs[i]);
                        ++i;
                    }
                    return result;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = this.fDisplay.hashCode();
            int i = 0;
            while (i < this.fRGBs.length) {
                hash = hash * 7 + this.fRGBs[i].hashCode();
                ++i;
            }
            hash = hash * 7 + this.fLength;
            return hash;
        }
    }

    private class ImageReference {
        private Image fImage;
        private int fCount;

        public ImageReference(Image image) {
            this.fImage = image;
            this.fCount = 1;
        }

        public Image getImage() {
            return this.fImage;
        }

        public boolean decCount() {
            return --this.fCount == 0;
        }

        public void incCount() {
            ++this.fCount;
        }
    }

    private class SimpleImageIdentifier
    extends ImageIdentifier {
        private int fTheight;
        private int fMarginHeight;

        SimpleImageIdentifier(Display display, Color color1, Color color2, int realtheight, int theight, int marginHeight) {
            super(display, new Color[]{color1, color2}, realtheight);
            this.fTheight = theight;
            this.fMarginHeight = marginHeight;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SimpleImageIdentifier) {
                SimpleImageIdentifier id = (SimpleImageIdentifier)obj;
                if (super.equals(obj) && id.fTheight == this.fTheight && id.fMarginHeight == this.fMarginHeight) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = hash * 7 + new Integer(this.fTheight).hashCode();
            hash = hash * 7 + new Integer(this.fMarginHeight).hashCode();
            return hash;
        }
    }
}

