/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.internal.databinding.observable.tree.IUnorderedTreeProvider;
import org.eclipse.core.internal.databinding.observable.tree.TreePath;

public class LeafNodesSet
extends AbstractObservableSet {
    private HashSet leafNodes = new HashSet();
    private HashMap mapElementsOntoNodeInfo = new HashMap();
    private IUnorderedTreeProvider tree;
    private Object input;
    private int staleCount = 0;

    public LeafNodesSet(IUnorderedTreeProvider tree) {
        this(null, tree);
    }

    public LeafNodesSet(Object initialInput, IUnorderedTreeProvider tree) {
        super(tree.getRealm());
        this.tree = tree;
        if (initialInput != null) {
            this.setInput(initialInput);
        }
    }

    private void processDiff(TreePath treePath, SetDiff diff) {
        HashSet removals = new HashSet();
        HashSet additions = new HashSet();
        for (Object next : diff.getRemovals()) {
            this.elementRemoved(treePath.createChildPath(next), removals);
        }
        for (Object next : diff.getAdditions()) {
            this.elementDiscovered(treePath.createChildPath(next), additions);
        }
        HashSet newRemovals = new HashSet();
        newRemovals.addAll(removals);
        newRemovals.removeAll(additions);
        HashSet newAdditions = new HashSet();
        newAdditions.addAll(additions);
        newAdditions.removeAll(removals);
        this.leafNodes.addAll(newAdditions);
        this.leafNodes.removeAll(newRemovals);
        if (!newAdditions.isEmpty() || !newRemovals.isEmpty()) {
            this.setStale(this.staleCount > 0);
            this.fireSetChange(Diffs.createSetDiff(newAdditions, newRemovals));
        }
    }

    public void setInput(Object input) {
        Set<Object> removals = Collections.EMPTY_SET;
        Set<Object> additions = Collections.EMPTY_SET;
        if (this.input != null) {
            removals = Collections.singleton(this.input);
        } else if (input != null) {
            additions = Collections.singleton(input);
        }
        this.input = input;
        this.processDiff(TreePath.EMPTY, Diffs.createSetDiff(additions, removals));
    }

    private void elementRemoved(TreePath treePath, Set removals) {
        NodeInfo newNode = (NodeInfo)this.mapElementsOntoNodeInfo.get(treePath);
        if (newNode != null) {
            NodeInfo nodeInfo = newNode = new NodeInfo(treePath);
            nodeInfo.count = nodeInfo.count - 1;
            if (newNode.count == 0) {
                this.mapElementsOntoNodeInfo.remove(treePath);
                if (newNode.children != null) {
                    for (Object next : newNode.children) {
                        this.elementRemoved(treePath.createChildPath(next), removals);
                    }
                    newNode.children.dispose();
                } else {
                    removals.add(treePath);
                }
            }
        }
    }

    private void elementDiscovered(TreePath treePath, HashSet additions) {
        NodeInfo newNode = (NodeInfo)this.mapElementsOntoNodeInfo.get(treePath);
        if (newNode == null) {
            newNode = new NodeInfo(treePath);
            this.mapElementsOntoNodeInfo.put(treePath, newNode);
            if (newNode.children != null) {
                for (Object next : newNode.children) {
                    this.elementDiscovered(treePath.createChildPath(next), additions);
                }
            } else {
                additions.add(treePath);
            }
        } else {
            NodeInfo nodeInfo = newNode;
            nodeInfo.count = nodeInfo.count + 1;
        }
    }

    protected Set getWrappedSet() {
        return this.leafNodes;
    }

    public Object getElementType() {
        return Object.class;
    }

    public void dispose() {
        for (NodeInfo next : this.mapElementsOntoNodeInfo.values()) {
            if (next.children == null) continue;
            next.dispose();
        }
        this.mapElementsOntoNodeInfo.clear();
        this.leafNodes.clear();
        super.dispose();
    }

    private class NodeInfo
    implements IStaleListener,
    ISetChangeListener {
        private int count;
        private TreePath treePath;
        IObservableSet children;
        private boolean wasStale = false;

        public NodeInfo(TreePath treePath) {
            this.treePath = treePath;
            this.children = LeafNodesSet.this.tree.createChildSet((Object)this.treePath);
            if (this.children != null) {
                this.children.addStaleListener((IStaleListener)this);
                this.children.addSetChangeListener((ISetChangeListener)this);
            }
            this.count = 1;
        }

        public void handleSetChange(SetChangeEvent event) {
            LeafNodesSet.this.processDiff(this.treePath, event.diff);
        }

        public void handleStale(StaleEvent event) {
            if (this.wasStale != this.children.isStale()) {
                if (this.wasStale) {
                    LeafNodesSet leafNodesSet = LeafNodesSet.this;
                    leafNodesSet.staleCount = leafNodesSet.staleCount - 1;
                } else {
                    LeafNodesSet leafNodesSet = LeafNodesSet.this;
                    leafNodesSet.staleCount = leafNodesSet.staleCount + 1;
                }
                this.wasStale = !this.wasStale;
            }
            LeafNodesSet.this.setStale(LeafNodesSet.this.staleCount > 0);
        }

        public void dispose() {
            if (this.children != null) {
                this.children.dispose();
                this.children = null;
                if (this.wasStale) {
                    LeafNodesSet leafNodesSet = LeafNodesSet.this;
                    leafNodesSet.staleCount = leafNodesSet.staleCount - 1;
                }
            }
        }
    }
}

