/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionTreeContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObservableListTreeContentProvider
implements ITreeContentProvider {
    private final ObservableCollectionTreeContentProvider impl;

    public ObservableListTreeContentProvider(IObservableFactory listFactory, TreeStructureAdvisor structureAdvisor) {
        this.impl = new Impl(listFactory, structureAdvisor);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public boolean hasChildren(Object element) {
        return this.impl.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        return this.impl.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.impl.getParent(element);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet getKnownElements() {
        return this.impl.getKnownElements();
    }

    private static class Impl
    extends ObservableCollectionTreeContentProvider {
        public Impl(IObservableFactory listFactory, TreeStructureAdvisor structureAdvisor) {
            super(listFactory, structureAdvisor);
        }

        @Override
        protected IObservablesListener createCollectionChangeListener(Object parentElement) {
            return new ListChangeListener(parentElement);
        }

        @Override
        protected void addCollectionChangeListener(IObservableCollection collection, IObservablesListener listener) {
            IObservableList list = (IObservableList)collection;
            IListChangeListener listListener = (IListChangeListener)listener;
            list.addListChangeListener(listListener);
        }

        @Override
        protected void removeCollectionChangeListener(IObservableCollection collection, IObservablesListener listener) {
            IObservableList list = (IObservableList)collection;
            IListChangeListener listListener = (IListChangeListener)listener;
            list.removeListChangeListener(listListener);
        }

        private class ListChangeListener
        implements IListChangeListener {
            final Object parentElement;

            public ListChangeListener(Object parentElement) {
                this.parentElement = parentElement;
            }

            public void handleListChange(ListChangeEvent event) {
                if (Impl.this.isViewerDisposed()) {
                    return;
                }
                final Set removals = ViewerElementSet.withComparer(Impl.this.comparer);
                event.diff.accept(new ListDiffVisitor(){

                    public void handleAdd(int index, Object child) {
                        Impl.this.getOrCreateNode(child).addParent(ListChangeListener.this.parentElement);
                        Impl.this.viewerUpdater.insert(ListChangeListener.this.parentElement, child, index);
                    }

                    public void handleRemove(int index, Object child) {
                        Impl.this.viewerUpdater.remove(ListChangeListener.this.parentElement, child, index);
                        removals.add(child);
                    }

                    public void handleReplace(int index, Object oldChild, Object newChild) {
                        Impl.this.getOrCreateNode(newChild).addParent(ListChangeListener.this.parentElement);
                        Impl.this.viewerUpdater.replace(ListChangeListener.this.parentElement, oldChild, newChild, index);
                        removals.add(oldChild);
                    }

                    public void handleMove(int oldIndex, int newIndex, Object child) {
                        Impl.this.viewerUpdater.move(ListChangeListener.this.parentElement, child, oldIndex, newIndex);
                    }
                });
                removals.removeAll((Collection<?>)event.getObservableList());
                Iterator iterator = removals.iterator();
                while (iterator.hasNext()) {
                    ObservableCollectionTreeContentProvider.TreeNode node = Impl.this.getExistingNode(iterator.next());
                    if (node == null) continue;
                    node.removeParent(this.parentElement);
                }
            }
        }
    }
}

