/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ObservableList;

public class ProxyObservableList
extends ObservableList {
    private IListChangeListener listChangelistener = new IListChangeListener(){

        @Override
        public void handleListChange(ListChangeEvent event) {
            ProxyObservableList.this.fireListChange(event.diff);
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        @Override
        public void handleStale(StaleEvent event) {
            ProxyObservableList.this.fireStale();
        }
    };
    private IObservableList wrappedList;

    public ProxyObservableList(IObservableList wrappedList) {
        super(wrappedList.getRealm(), wrappedList, wrappedList.getElementType());
        this.wrappedList = wrappedList;
        wrappedList.addListChangeListener(this.listChangelistener);
        wrappedList.addStaleListener(this.staleListener);
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.wrappedList == null ? false : this.wrappedList.isStale();
    }

    @Override
    public void dispose() {
        if (this.wrappedList != null) {
            this.wrappedList.removeListChangeListener(this.listChangelistener);
            this.listChangelistener = null;
            this.wrappedList.removeStaleListener(this.staleListener);
            this.staleListener = null;
            this.wrappedList = null;
        }
        super.dispose();
    }
}

