/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.registerer;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.registerer.preferences.DirEntry;
import jp.sourceforge.concierge.plugin.registerer.preferences.RegistererPreferencePage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Document;

public class Initializer
extends Job {
    public Initializer() {
        super("Registering files");
    }

    private ArrayList<String> getUndocumentedFiles(String dir, boolean subdir) {
        ArrayList<String> flist = new ArrayList<String>();
        File dirf = new File(dir);
        if (!dirf.isDirectory()) {
            return flist;
        }
        String dbdir = FrameworkPlugin.getLocalDatabaseDirectory();
        if (dir.startsWith(dbdir)) {
            return flist;
        }
        File[] files = dirf.listFiles();
        int i = 0;
        while (i < files.length) {
            String path;
            File pf;
            String name = files[i].getName();
            if (!(name.startsWith(".") || (pf = new File(path = String.valueOf(dir) + File.separator + name)).isHidden() || FrameworkPlugin.isDocumentedByOriginalPath((String)path))) {
                if (pf.isDirectory()) {
                    if (subdir) {
                        flist.addAll(this.getUndocumentedFiles(path, subdir));
                    }
                } else {
                    flist.add(path);
                }
            }
            ++i;
        }
        return flist;
    }

    private Request createRequest(ArrayList<Document> docs) {
        Request req = new Request();
        req.collection = "data";
        req.command = 1;
        req.data = docs;
        req.options = 0;
        return req;
    }

    private void initDirectory(IProgressMonitor monitor) {
        ArrayList<DirEntry> entry = RegistererPreferencePage.getMonitoringList();
        ArrayList<Request> reqs = new ArrayList<Request>();
        ArrayList<Document> ndocs = new ArrayList<Document>();
        monitor.beginTask("Registering files in the monitoring directories...", entry.size());
        monitor.subTask("Registering files");
        int i = 0;
        while (i < entry.size()) {
            ArrayList<String> flist;
            ArrayList<String> types;
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(i);
            DirEntry de = entry.get(i);
            if (!de.dirname.equals("[MANUAL]") && (types = RegistererPreferencePage.getTypes(entry, de.dirname, flist = this.getUndocumentedFiles(de.dirname, de.subdir))) != null) {
                int j = 0;
                while (j < types.size()) {
                    String type = types.get(j);
                    if (type != null) {
                        Document tdoc = TypeManager.getTypeDocument((String)type);
                        Document ndoc = DataDomImpl.createDocument((Document)tdoc);
                        DataDomImpl.setFilePath((Document)ndoc, (String)flist.get(j));
                        ndocs.add(ndoc);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(entry.size());
        if (ndocs.size() == 0) {
            return;
        }
        Request req = this.createRequest(ndocs);
        reqs.add(req);
        FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.registerer");
        monitor.subTask("Registering done.");
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.initDirectory(monitor);
        monitor.done();
        return Status.OK_STATUS;
    }
}

