/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.XooNIpsConnection;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingField;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingTableDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference.EditImportDatasetListDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference.EditSrcMappingFieldDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference.ImportMappingData;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference.ImportMappingDataList;
import jp.sourceforge.xoonips.XooNIpsException;
import jp.sourceforge.xoonips.XooNIpsItemType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportPreferenceDialog
extends MappingTableDialog {
    public ImportPreferenceDialog(Shell parentShell, XooNIpsConnection xoonipsConnection) {
        super(parentShell, xoonipsConnection);
    }

    @Override
    protected Control createSettingControl(Composite parent) {
        SashForm sf = new SashForm(parent, 256);
        sf.setLayoutData((Object)new GridData(1808));
        sf.setLayout((Layout)new FillLayout());
        this.createTypeTableViewer((Composite)sf);
        Composite composite = new Composite((Composite)sf, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createDatasetControls(composite);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        Composite upperComposite = new Composite((Composite)group, 0);
        upperComposite.setLayoutData((Object)new GridData(768));
        upperComposite.setLayout((Layout)new GridLayout(2, false));
        this.createDataNameControls(upperComposite);
        this.createDstTypeNameControls(upperComposite, "Concierge Type:");
        Label separator = new Label(upperComposite, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        this.createMappingTableViewer((Composite)group, "Concierge", "XooNIps");
        sf.setWeights(new int[]{25, 75});
        return sf;
    }

    private ImportMappingDataList getSelectionTypeTableView() {
        Object obj;
        ISelection selection = this.typeTableView.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ImportMappingDataList) {
            return (ImportMappingDataList)obj;
        }
        return null;
    }

    @Override
    protected void initialize() {
        this.typeTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof ImportMappingDataList) {
                    ImportMappingDataList mappingDataList = (ImportMappingDataList)obj;
                    ArrayList<ImportMappingData> mappingDataAL = mappingDataList.getList();
                    ImportPreferenceDialog.this.datasetListCombo.setInput(mappingDataAL);
                    ImportPreferenceDialog.this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                    ImportMappingData mappingData = null;
                    if (mappingDataList.getCurrentIndex() >= 0) {
                        mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
                    }
                    ImportPreferenceDialog.this.setMappingDataToControls(mappingData);
                    return;
                }
                ImportPreferenceDialog.this.setMappingDataToControls(null);
                ImportPreferenceDialog.this.datasetListCombo.setInput(null);
            }
        });
        this.datasetListCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof ImportMappingData) {
                    ImportMappingData mappingData = (ImportMappingData)obj;
                    ImportMappingDataList mappingDataList = ImportPreferenceDialog.this.getSelectionTypeTableView();
                    mappingDataList.setCurrentIndex(mappingData);
                    ImportPreferenceDialog.this.setMappingDataToControls(mappingData);
                    return;
                }
                ImportPreferenceDialog.this.mappingTableViewer.setInput(null);
            }
        });
        this.datasetEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                ImportMappingDataList mappingDataList = ImportPreferenceDialog.this.getSelectionTypeTableView();
                ArrayList<ImportMappingData> mappingDataAL = mappingDataList.getList();
                EditImportDatasetListDialog dlg = new EditImportDatasetListDialog(button.getShell(), mappingDataAL, mappingDataList.getSrc());
                if (dlg.open() == 0) {
                    ArrayList<ImportMappingData> al = dlg.getMappingDataList();
                    int i = mappingDataAL.size() - 1;
                    while (i >= 0) {
                        ImportMappingData srcObj = mappingDataAL.get(i);
                        if (!al.remove(srcObj)) {
                            mappingDataAL.remove(i);
                        }
                        --i;
                    }
                    if (al.size() > 0) {
                        mappingDataAL.addAll(al);
                        mappingDataList.setCurrentIndex(mappingDataAL.size() - 1);
                        ImportPreferenceDialog.this.datasetListCombo.refresh();
                        ImportPreferenceDialog.this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                        ImportPreferenceDialog.this.setMappingDataToControls(mappingDataAL.get(mappingDataList.getCurrentIndex()));
                    }
                }
            }
        });
        this.mappingTableViewer.setLabelProvider((IBaseLabelProvider)new MappingViewLabelProvider());
        this.mappingTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    MappingField mappingField = (MappingField)obj;
                    ImportMappingDataList mappingDataList = ImportPreferenceDialog.this.getSelectionTypeTableView();
                    XooNIpsItemType xnpItemType = mappingDataList.getSrc();
                    EditSrcMappingFieldDialog dlg = new EditSrcMappingFieldDialog(ImportPreferenceDialog.this.mappingTableViewer.getControl().getShell(), xnpItemType, mappingField);
                    if (dlg.open() == 0) {
                        ImportPreferenceDialog.this.mappingTableViewer.update(obj, null);
                    }
                }
            }
        });
        try {
            XooNIpsItemType[] xnpItemTypes = this.xoonipsConnection.getXooNIpsSession().getItemTypeList();
            int i = 0;
            while (i < xnpItemTypes.length) {
                ImportMappingDataList mappingDataList = new ImportMappingDataList(xnpItemTypes[i]);
                this.typeTableView.add((Object)mappingDataList);
                this.readDoc(mappingDataList);
                ArrayList<ImportMappingData> mappingDataAL = mappingDataList.getList();
                if (mappingDataAL.size() == 0) {
                    ImportMappingData mappingData = new ImportMappingData(xnpItemTypes[i]);
                    mappingDataAL.add(mappingData);
                    mappingDataList.setCurrentIndex(0);
                }
                ++i;
            }
            if (this.typeTableView.getTable().getItemCount() > 0) {
                this.typeTableView.getTable().select(0);
                ImportMappingDataList mappingDataList = (ImportMappingDataList)this.typeTableView.getElementAt(0);
                ArrayList<ImportMappingData> mappingDataAL = mappingDataList.getList();
                this.datasetListCombo.setInput(mappingDataAL);
                this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                ImportMappingData mappingData = null;
                if (mappingDataList.getCurrentIndex() >= 0) {
                    mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
                }
                this.setMappingDataToControls(mappingData);
            }
        }
        catch (XooNIpsException excp) {
            System.err.println(excp.getMessage());
        }
        catch (Exception excp) {
            System.err.println(excp.getMessage());
        }
    }

    @Override
    protected void DoSave() {
        this.typeTableView.getTable().setFocus();
        try {
            this.deleteMappingDataFromDB();
            this.saveMappingDataToDB();
            this.xoonipsConnection.getCurrentImportMappingDataList().readCurrentMappingDataList();
        }
        catch (Exception excp) {
            excp.getStackTrace();
        }
    }

    private void deleteMappingDataFromDB() {
        String xpath = "/importmappingdata[@xoonipsversion='3.4']";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "xoonipslink");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(2, (Object)docs, "xoonipslink"));
            FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference");
            reqs = null;
        }
        docs = null;
    }

    private void saveMappingDataToDB() {
        ArrayList<Document> docs = new ArrayList<Document>();
        int i = 0;
        while (i < this.typeTableView.getTable().getItemCount()) {
            ImportMappingDataList mappingDataList = (ImportMappingDataList)this.typeTableView.getElementAt(i);
            Document doc = this.newDoc(mappingDataList);
            if (doc != null) {
                docs.add(doc);
            }
            ++i;
        }
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(1, docs, "xoonipslink"));
            FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference");
            Object var2_3 = null;
        }
        docs = null;
    }

    private Document newDoc(ImportMappingDataList mappingDataList) {
        Document doc = null;
        try {
            doc = DomImpl.createDocument((String)"importmappingdata");
            Element rootElem = doc.getDocumentElement();
            rootElem.setAttribute("xoonipsitemtype", mappingDataList.getSrcID());
            rootElem.setAttribute("xoonipsversion", "3.4");
            rootElem.setAttribute("select", String.valueOf(mappingDataList.getCurrentIndex()));
            ArrayList<ImportMappingData> mappingDataAL = mappingDataList.getList();
            int j = 0;
            while (j < mappingDataAL.size()) {
                ImportMappingData mappingData = mappingDataAL.get(j);
                Element dataElem = doc.createElement("data");
                rootElem.appendChild(dataElem);
                dataElem.setAttribute("dataname", mappingData.getDataName());
                Document typedoc = mappingData.getDstTypeDoc();
                dataElem.setAttribute("pluginid", TypeDomImpl.getPluginID((Document)typedoc));
                dataElem.setAttribute("typename", TypeDomImpl.getTypeName((Document)typedoc));
                ArrayList<MappingField> fields = mappingData.getFields();
                int k = 0;
                while (k < fields.size()) {
                    MappingField field = fields.get(k);
                    Element fieldElem = doc.createElement("field");
                    dataElem.appendChild(fieldElem);
                    Element dstElem = doc.createElement("dst");
                    fieldElem.appendChild(dstElem);
                    dstElem.setAttribute("type", "concierge");
                    dstElem.appendChild(doc.createTextNode(field.getDst()));
                    ArrayList<String> srcs = field.getSrc();
                    int l = 0;
                    while (l < srcs.size()) {
                        Element srcElem = doc.createElement("src");
                        fieldElem.appendChild(srcElem);
                        srcElem.setAttribute("type", "xoonips");
                        srcElem.appendChild(doc.createTextNode(srcs.get(l)));
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            doc = null;
        }
        return doc;
    }

    private void readDoc(ImportMappingDataList mappingDataList) {
        String xpath = "/importmappingdata[@xoonipsitemtype='" + mappingDataList.getSrcID() + "' and " + "@xoonipsversion='3.4']";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "xoonipslink");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            Document doc = (Document)docs.get(0);
            Element rootElem = doc.getDocumentElement();
            String selectString = rootElem.getAttribute("select");
            if (selectString != null && selectString.length() > 0) {
                mappingDataList.setCurrentIndex(Integer.valueOf(selectString));
            } else {
                mappingDataList.setCurrentIndex(-1);
            }
            Node dataNode = rootElem.getFirstChild();
            while (dataNode != null) {
                if (dataNode.getNodeType() == 1) {
                    ArrayList<MappingField> fieldsAL = new ArrayList<MappingField>();
                    Node fieldNode = dataNode.getFirstChild();
                    while (fieldNode != null) {
                        if (fieldNode.getNodeType() == 1) {
                            String dstValue = "";
                            Element fieldElement = (Element)fieldNode;
                            NodeList dstNodeList = fieldElement.getElementsByTagName("dst");
                            if (dstNodeList.getLength() > 0) {
                                Element dstElem = (Element)dstNodeList.item(0);
                                NodeList nl = dstElem.getChildNodes();
                                int k = 0;
                                while (k < nl.getLength()) {
                                    Node n = nl.item(k);
                                    if (n.getNodeType() == 3) {
                                        dstValue = String.valueOf(dstValue) + n.getNodeValue();
                                    }
                                    ++k;
                                }
                            }
                            MappingField mappingField = new MappingField(dstValue);
                            NodeList srcNodeList = fieldElement.getElementsByTagName("src");
                            int i = 0;
                            while (i < srcNodeList.getLength()) {
                                Element srcElem = (Element)srcNodeList.item(i);
                                String srcValue = "";
                                NodeList nl = srcElem.getChildNodes();
                                int k = 0;
                                while (k < nl.getLength()) {
                                    Node n = nl.item(k);
                                    if (n.getNodeType() == 3) {
                                        srcValue = String.valueOf(srcValue) + n.getNodeValue();
                                    }
                                    ++k;
                                }
                                mappingField.addSrc(srcValue);
                                ++i;
                            }
                            fieldsAL.add(mappingField);
                        }
                        fieldNode = fieldNode.getNextSibling();
                    }
                    String dataName = ((Element)dataNode).getAttribute("dataname");
                    String pluginid = ((Element)dataNode).getAttribute("pluginid");
                    String typename = ((Element)dataNode).getAttribute("typename");
                    ImportMappingData mappingData = new ImportMappingData(dataName, TypeManager.getTypeDocument((String)pluginid, (String)typename), fieldsAL);
                    mappingDataList.addMappingData(mappingData);
                }
                dataNode = dataNode.getNextSibling();
            }
        }
    }

    public static boolean canUseXooNIpsTypeField(String fieldName, String fieldType) {
        if (!"STRING".equals(fieldType) && !"DATE".equals(fieldType)) {
            return false;
        }
        if (fieldName.equals("item_id") || fieldName.equals("itemtype") || fieldName.equals("indexes") || fieldName.equals("related_to")) {
            return false;
        }
        if (fieldName.equals("detail_field.book_id") || fieldName.equals("detail_field.conference_id") || fieldName.equals("detail_field.data_id") || fieldName.equals("detail_field.files_id") || fieldName.equals("detail_field.memo_id") || fieldName.equals("detail_field.model_id") || fieldName.equals("detail_field.paper_id") || fieldName.equals("detail_field.presentation_id") || fieldName.equals("detail_field.simulator_id") || fieldName.equals("detail_field.stimulus_id") || fieldName.equals("detail_field.tool_id") || fieldName.equals("detail_field.url_id")) {
            return false;
        }
        if (fieldName.equals("detail_field.use_cc") || fieldName.equals("detail_field.cc_commercial_use") || fieldName.equals("detail_field.cc_modification")) {
            return false;
        }
        return !fieldName.equals("detail_field.attachment_dl_limit") && !fieldName.equals("detail_field.attachment_dl_notify");
    }

    class MappingViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (obj instanceof MappingField) {
                MappingField field = (MappingField)obj;
                if (index == 0) {
                    return field.getDst();
                }
                if (index == 1) {
                    ArrayList<String> al;
                    ImportMappingDataList mappingDataList = ImportPreferenceDialog.this.getSelectionTypeTableView();
                    StringBuffer strBuf = new StringBuffer();
                    if (mappingDataList != null && (al = field.getSrc()) != null) {
                        int i = 0;
                        while (i < al.size()) {
                            if (i > 0) {
                                strBuf.append(", ");
                            }
                            String src = al.get(i);
                            strBuf.append(mappingDataList.getSrcDisplayName(src));
                            ++i;
                        }
                    }
                    return strBuf.toString();
                }
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

