/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import jp.sourceforge.xoonips.XooNIpsItem;
import jp.sourceforge.xoonips.XooNIpsItemType;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ItemTableViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int XNP_ITEM_ID_INDEX = 0;
    public static final int XNP_ITEM_TITLE_INDEX = 1;
    public static final int XNP_ITEM_CONTRIBUTOR_INDEX = 2;
    public static final int XNP_ITEM_TYPE_INDEX = 3;
    public static final int XNP_ITEM_COMMENT_INDEX = 4;
    public static final int XNP_ITEM_LASTUPDATE_DATE_INDEX = 5;
    public static final int XNP_ITEM_REGISTRATION_DATE_INDEX = 6;
    public static final int XNP_ITEM_LANG_INDEX = 7;
    public static final int XNP_ITEM_CREATION_DATE_INDEX = 8;
    public static final int XNP_ITEM_EXT_ID_INDEX = 9;
    public static final int XNP_ITEM_KEYWORD_INDEX = 10;
    public static final int XNP_ITEM_URL_INDEX = 11;

    public String getColumnText(Object obj, int index) {
        if (obj instanceof XooNIpsItem) {
            XooNIpsItem xnpItem = (XooNIpsItem)obj;
            switch (index) {
                case 0: {
                    return String.valueOf(xnpItem.getItemID());
                }
                case 1: {
                    String[] titles = xnpItem.getTitles();
                    String value = "";
                    if (titles != null) {
                        int i = 0;
                        while (i < titles.length) {
                            if (value.length() > 0) {
                                value = String.valueOf(value) + " ";
                            }
                            value = String.valueOf(value) + titles[i];
                            ++i;
                        }
                    }
                    return value;
                }
                case 2: {
                    return xnpItem.getContributor();
                }
                case 3: {
                    XooNIpsItemType xnpItemType = xnpItem.getItemType();
                    if (xnpItemType == null) break;
                    return xnpItemType.getTitle();
                }
                case 4: {
                    return xnpItem.getComment();
                }
                case 5: {
                    SimpleDateFormat myformat = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss");
                    Calendar calendar = xnpItem.getLastUpdateDate();
                    if (calendar == null) break;
                    return myformat.format(calendar.getTime());
                }
                case 6: {
                    SimpleDateFormat myformat = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss");
                    Calendar calendar = xnpItem.getRegistrationDate();
                    if (calendar == null) break;
                    return myformat.format(calendar.getTime());
                }
                case 7: {
                    return xnpItem.getLang();
                }
                case 8: {
                    return xnpItem.getCreationDate();
                }
                case 9: {
                    return xnpItem.getExt_id();
                }
                case 10: {
                    String[] keywords = xnpItem.getKeywords();
                    if (keywords != null) {
                        String value = "";
                        int i = 0;
                        while (i < keywords.length) {
                            if (value.length() > 0) {
                                value = String.valueOf(value) + ", ";
                            }
                            value = String.valueOf(value) + "\"" + keywords[i] + "\"";
                            ++i;
                        }
                        return value;
                    }
                }
                case 11: {
                    return xnpItem.getUrl();
                }
            }
        }
        return this.getText(obj);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

