/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignerInfo;

public class DefaultClassLoader
extends ClassLoader
implements BaseClassLoader {
    protected static final PermissionCollection ALLPERMISSIONS;
    private static final String CLASS_CERTIFICATE_SUPPORT = "osgi.support.class.certificate";
    private static final boolean CLASS_CERTIFICATE;
    protected ClassLoaderDelegate delegate;
    protected ProtectionDomain domain;
    protected ClasspathManager manager;

    static {
        CLASS_CERTIFICATE = Boolean.valueOf(FrameworkProperties.getProperty(CLASS_CERTIFICATE_SUPPORT, "true"));
        AllPermission allPerm = new AllPermission();
        ALLPERMISSIONS = allPerm.newPermissionCollection();
        if (ALLPERMISSIONS != null) {
            ALLPERMISSIONS.add(allPerm);
        }
    }

    public DefaultClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, ProtectionDomain domain, BaseData bundledata, String[] classpath) {
        super(parent);
        this.delegate = delegate;
        this.domain = domain;
        this.manager = new ClasspathManager(bundledata, classpath, this);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ")");
        }
        try {
            Class clazz = this.delegate.findClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (Error e) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ") failed.");
                Debug.printStackTrace(e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ") failed.");
                Debug.printStackTrace(e);
            }
            throw e;
        }
    }

    public URL getResource(String name) {
        URL url;
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].getResource(" + name + ")");
        }
        if ((url = this.delegate.findResource(name)) != null) {
            return url;
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].getResource(" + name + ") failed.");
        }
        return null;
    }

    protected Enumeration findResources(String name) throws IOException {
        return this.delegate.findResources(name);
    }

    protected String findLibrary(String libname) {
        return this.manager.findLibrary(libname);
    }

    public ProtectionDomain getDomain() {
        return this.domain;
    }

    public ClasspathEntry createClassPathEntry(BundleFile bundlefile, ProtectionDomain cpDomain) {
        return new ClasspathEntry(bundlefile, DefaultClassLoader.createProtectionDomain(bundlefile, cpDomain));
    }

    public Class defineClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry) {
        return this.defineClass(name, classbytes, 0, classbytes.length, classpathEntry.getDomain());
    }

    public Class publicFindLoaded(String classname) {
        return this.findLoadedClass(classname);
    }

    public Object publicGetPackage(String pkgname) {
        return this.getPackage(pkgname);
    }

    public Object publicDefinePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    public void initialize() {
        this.manager.initialize();
    }

    public URL findLocalResource(String resource) {
        return this.manager.findLocalResource(resource);
    }

    public Enumeration findLocalResources(String resource) {
        return this.manager.findLocalResources(resource);
    }

    public Class findLocalClass(String classname) throws ClassNotFoundException {
        return this.manager.findLocalClass(classname);
    }

    public void close() {
        this.manager.close();
    }

    public void attachFragment(BundleData sourcedata, ProtectionDomain sourcedomain, String[] sourceclasspath) {
        this.manager.attachFragment(sourcedata, sourcedomain, sourceclasspath);
    }

    public ClassLoaderDelegate getDelegate() {
        return this.delegate;
    }

    public static ProtectionDomain createProtectionDomain(BundleFile bundlefile, ProtectionDomain baseDomain) {
        try {
            SignerInfo[] signers;
            SignedContent signedContent;
            PermissionCollection permissions = baseDomain != null ? baseDomain.getPermissions() : ALLPERMISSIONS;
            Certificate[] certs = null;
            SignedContent signedContent2 = signedContent = bundlefile instanceof SignedContent ? (SignedContent)((Object)bundlefile) : null;
            if (CLASS_CERTIFICATE && signedContent != null && signedContent.isSigned() && (signers = signedContent.getSignerInfos()).length > 0) {
                certs = signers[0].getCertificateChain();
            }
            return new ProtectionDomain(new CodeSource(bundlefile.getBaseFile().toURL(), certs), permissions);
        }
        catch (MalformedURLException malformedURLException) {
            return baseDomain;
        }
    }

    public ClasspathManager getClasspathManager() {
        return this.manager;
    }
}

