/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.smartindexer;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.SearcherPlugin;
import jp.sourceforge.concierge.plugin.SmartIndexer;
import jp.sourceforge.concierge.plugin.SmartIndexerPlugin;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.plugin.smartindexer.widget.FolderInputDialog;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InternalBinder
extends Composite {
    private final String MENU_DELETE_FOLDER = "Delete";
    private final String MENU_COPY_FOLDER = "Copy";
    private final String MENU_EDIT_FOLDER = "Edit";
    private final String DISPOSE_MESSAGE = "Delete?";
    private final int SELECTED_COLOR = 10;
    private final int BACK_COLOR = 1;
    private final int REVERSE_TEXT_COLOR = 1;
    private final int DEFAULT_TEXT_COLOR = 2;
    protected SmartIndexer parentClass;
    protected CLabel nameLabel;
    protected ImageHyperlink folImage;
    protected Boolean fgSelect;
    protected Menu menu = null;
    protected Image img = null;
    protected ToolTip tooltip;
    protected Action openAction = null;
    protected Action deleteAction = null;
    protected Action selectAction = null;
    protected Action copyAction = null;
    protected Action editAction = null;
    protected Action updateDataAction = null;
    protected Element config = null;

    public void setNameLabelText(String name) {
        this.nameLabel.setText(name);
    }

    public void setNameLabelText() {
        this.nameLabel.setText(Configure.getName((Element)this.config));
    }

    public void select() {
        this.fgSelect = true;
        GraphicUtil.setBackground((Control)this.nameLabel, (int)10);
        GraphicUtil.setForeground((Control)this.nameLabel, (int)1);
    }

    public void deselect() {
        this.fgSelect = false;
        GraphicUtil.setBackground((Control)this.nameLabel, (int)1);
        GraphicUtil.setForeground((Control)this.nameLabel, (int)2);
    }

    public void setDropedBackground(boolean b) {
        if (b) {
            GraphicUtil.setBackground((Control)this.nameLabel, (int)10);
            GraphicUtil.setForeground((Control)this.nameLabel, (int)1);
        } else {
            GraphicUtil.setBackground((Control)this.nameLabel, (int)1);
            GraphicUtil.setForeground((Control)this.nameLabel, (int)2);
        }
    }

    public boolean isSelected() {
        return this.fgSelect;
    }

    public Element getConfigure() {
        return this.config;
    }

    public void setDeleteAction(Action act) {
        this.deleteAction = act;
    }

    public void setCopyAction(Action act) {
        this.copyAction = act;
    }

    public void setSelectAction(Action act) {
        this.selectAction = act;
    }

    public void setOpenAction(Action act) {
        this.openAction = act;
    }

    public void setEditAction(Action act) {
        this.editAction = act;
    }

    public void setUpdateDataAction(Action act) {
        this.updateDataAction = act;
    }

    public Control getImageControl() {
        return this.folImage;
    }

    public InternalBinder(Composite comp, SmartIndexer cls, Element elem) {
        super(comp, 0);
        this.parentClass = cls;
        this.config = elem;
        this.fgSelect = false;
        this.setLayout((Layout)new GridLayout(1, true));
        GraphicUtil.setBackground((Control)this, (int)1);
        this.folImage = new ImageHyperlink((Composite)this, 0x800000);
        GridData gdt = new GridData(0x1000000, 0x1000000, true, true);
        this.folImage.setLayoutData((Object)gdt);
        ImageDescriptor imgDes = SmartIndexerPlugin.getImageDescriptor("icons/binder.png");
        Image img = imgDes.createImage();
        this.folImage.setImage(img);
        GraphicUtil.setBackground((Control)this.folImage, (int)1);
        this.folImage.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.folImage.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    InternalBinder.this.deleteFolder(true);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.setMouseListener();
        this.nameLabel = new CLabel((Composite)this, 32);
        this.nameLabel.setText(Configure.getName((Element)this.config));
        this.nameLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        GraphicUtil.setBackground((Control)this.nameLabel, (int)1);
        this.nameLabel.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                Point p = InternalBinder.this.nameLabel.getSize();
                InternalBinder.this.tooltip.setLocation(InternalBinder.this.nameLabel.toDisplay(p.x / 2, p.y / 2));
                InternalBinder.this.tooltip.setText(InternalBinder.this.nameLabel.getText());
                InternalBinder.this.tooltip.setVisible(true);
            }

            public void mouseExit(MouseEvent e) {
                InternalBinder.this.tooltip.setVisible(false);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.tooltip = new ToolTip(this.nameLabel.getShell(), 4096);
        this.makeMenu();
    }

    protected void makeMenu() {
        this.menu = new Menu((Decorations)this.getShell(), 8);
        MenuItem item1 = new MenuItem(this.menu, 8);
        item1.setText("Edit");
        item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalBinder.this.editInfo();
            }
        });
        MenuItem item2 = new MenuItem(this.menu, 8);
        item2.setText("Copy");
        item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalBinder.this.copyFolder();
            }
        });
        MenuItem item3 = new MenuItem(this.menu, 8);
        item3.setText("Delete");
        item3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalBinder.this.deleteFolder(true);
            }
        });
        this.folImage.setMenu(this.menu);
    }

    protected void setMouseListener() {
        this.folImage.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                InternalBinder.this.selectAction.run();
                InternalBinder.this.openFolder();
            }

            public void mouseDoubleClick(MouseEvent e) {
                InternalBinder.this.selectAction.run();
                InternalBinder.this.editInfo();
            }
        });
    }

    public InternalBinder clone() {
        Element info = Configure.copyInfo((Element)this.config);
        SearcherPlugin.addInfo((Element)info, null);
        InternalBinder icon = new InternalBinder(this.getParent(), this.parentClass, info);
        return icon;
    }

    public boolean editInfo() {
        this.tooltip.setVisible(false);
        FolderInputDialog dialog = new FolderInputDialog(this.getShell(), 1264);
        dialog.setElement(this.config);
        int ret = dialog.open();
        if (ret == 0) {
            this.update();
            return true;
        }
        return false;
    }

    protected void handleShellCloseEvent() {
        if (this.img != null) {
            this.img.dispose();
        }
        this.tooltip.setVisible(false);
    }

    public void openFolder() {
        this.tooltip.setVisible(false);
        if (this.openAction != null) {
            this.openAction.run();
        }
    }

    public void copyFolder() {
        if (this.copyAction != null) {
            this.copyAction.run();
        }
    }

    public void deleteFolder(boolean message) {
        this.tooltip.setVisible(false);
        if (message && !SmartIndexerPlugin.showConfirm(this.getShell(), "Delete?")) {
            return;
        }
        this.dispose();
        if (this.deleteAction != null) {
            this.deleteAction.run();
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void addDocument(Document doc) {
        ArrayList list = Configure.getBindedDocuments((Element)this.config);
        int i = 0;
        while (i < list.size()) {
            Document d = (Document)list.get(i);
            if (d != null && DomImpl.getID((Document)d) == DomImpl.getID((Document)doc)) {
                return;
            }
            ++i;
        }
        list.add(doc);
        Configure.setBindedDocuments((Element)this.config, (ArrayList)list);
        this.update();
    }

    public void update() {
        this.tooltip.setVisible(false);
        String name = Configure.getName((Element)this.config);
        if (this.nameLabel != null) {
            this.nameLabel.setText(name);
            this.layout();
        }
        String sender = SmartIndexerPlugin.getDefault().getBundle().getSymbolicName();
        SearcherPlugin.updateDocument((Object)sender);
    }
}

