/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.BackupManagerPlugin;
import jp.sourceforge.concierge.plugin.backupmanager.BackupComparator;
import jp.sourceforge.concierge.plugin.backupmanager.BaseComparator;
import jp.sourceforge.concierge.plugin.backupmanager.IDComparator;
import jp.sourceforge.concierge.plugin.backupmanager.PathComparator;
import jp.sourceforge.concierge.plugin.backupmanager.actions.BackupAction;
import jp.sourceforge.concierge.plugin.backupmanager.actions.ExportAction;
import jp.sourceforge.concierge.plugin.backupmanager.actions.RefreshAction;
import jp.sourceforge.concierge.plugin.backupmanager.actions.RelinkAction;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class BackupManager
extends ConciergeViewPart {
    private TableViewer statusviewer;
    private Combo lstatcombo;
    private Action relinkAction;
    private Action backupAction;
    private Action exportAction;
    private Action refreshAction;
    private static final Color BLACK = new Color(null, 0, 0, 0);
    private static final Color RED = new Color(null, 255, 0, 0);
    private static final ImageDescriptor expimg = BackupManagerPlugin.getImageDescriptor("icons/restore.png");
    private TableColumn cursorttc = null;

    private void addColumn(String title, int width, int alignment, BaseComparator bc) {
        Table tbl = this.statusviewer.getTable();
        TableColumn tc = new TableColumn(tbl, 16384);
        tc.setText(title);
        tc.setWidth(width);
        tc.setAlignment(alignment);
        tc.setResizable(true);
        tc.setMoveable(false);
        if (bc != null) {
            tc.setData("Comparator", (Object)bc);
            tc.setData("Direction", (Object)String.valueOf(128));
            tc.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ArrayList list = (ArrayList)BackupManager.this.statusviewer.getInput();
                    if (list == null) {
                        return;
                    }
                    TableColumn tc = (TableColumn)e.widget;
                    BaseComparator comp = (BaseComparator)tc.getData("Comparator");
                    if (comp == null) {
                        return;
                    }
                    BackupManager.this.statusviewer.setInput(null);
                    comp.setColumn(tc);
                    comp.changeSortOrder();
                    Collections.sort(list, comp);
                    BackupManager.this.statusviewer.setInput((Object)list);
                    BackupManager.this.cursorttc = tc;
                    int newdir = Integer.parseInt((String)tc.getData("Direction")) == 128 ? 1024 : 128;
                    BackupManager.this.statusviewer.getTable().setSortColumn(tc);
                    BackupManager.this.statusviewer.getTable().setSortDirection(newdir);
                    tc.setData("Direction", (Object)String.valueOf(newdir));
                }
            });
        }
    }

    public void createPartControl(Composite parent) {
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 3;
        gl.marginHeight = 3;
        gl.verticalSpacing = 0;
        parent.setLayout((Layout)gl);
        Composite topcomp = new Composite(parent, 0);
        GridLayout tgl = new GridLayout(2, false);
        tgl.marginWidth = 0;
        tgl.marginHeight = 0;
        tgl.verticalSpacing = 0;
        topcomp.setLayout((Layout)tgl);
        topcomp.setLayoutData((Object)new GridData(768));
        this.lstatcombo = new Combo(topcomp, 8);
        this.lstatcombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.lstatcombo.add("All");
        this.lstatcombo.add("Backuped");
        this.lstatcombo.add("NOT backuped");
        this.lstatcombo.select(0);
        this.lstatcombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String txt = ((Combo)e.widget).getText();
                ArrayList<Document> ndocs = txt.equals("All") ? BackupManagerPlugin.getAllFileDocuments() : (txt.equals("Backuped") ? BackupManagerPlugin.getBackupedDocuments() : BackupManagerPlugin.getNotBackupedDocuments());
                BackupManager.this.statusviewer.setInput(null);
                BackupManager.this.statusviewer.setInput(ndocs);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        CoolBar cb = new CoolBar(topcomp, 0);
        cb.setLayoutData((Object)new GridData(768));
        this.statusviewer = new TableViewer(parent, 66306);
        this.statusviewer.getControl().setLayoutData((Object)new GridData(1808));
        this.statusviewer.getTable().setLinesVisible(true);
        this.statusviewer.getTable().setHeaderVisible(true);
        this.addColumn("ID", 100, 16384, new IDComparator());
        this.addColumn("Path", 400, 16384, new PathComparator());
        this.addColumn("Backup date", 100, 16384, new BackupComparator());
        this.statusviewer.getTable().setFont(new Font((Device)parent.getDisplay(), "Vernada", 10, 0));
        this.statusviewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.statusviewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.statusviewer.setInput(BackupManagerPlugin.getAllFileDocuments());
        this.statusviewer.addDropSupport(19, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new TableDropListener());
        this.statusviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BackupManager.this.statusviewer.getTable().deselectAll();
            }
        });
        this.statusviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel == null || sel.isEmpty()) {
                    BackupManager.this.relinkAction.setEnabled(false);
                    BackupManager.this.backupAction.setEnabled(false);
                    BackupManager.this.exportAction.setEnabled(false);
                    BackupManager.this.refreshAction.setEnabled(true);
                    return;
                }
                ArrayList<Document> docs = new ArrayList<Document>();
                Iterator it = sel.iterator();
                while (it.hasNext()) {
                    docs.add((Document)it.next());
                }
                if (BackupManager.this.containsBackupedDocument(docs)) {
                    BackupManager.this.exportAction.setEnabled(true);
                } else {
                    BackupManager.this.exportAction.setEnabled(false);
                }
                BackupManager.this.relinkAction.setEnabled(true);
                BackupManager.this.backupAction.setEnabled(true);
                BackupManager.this.refreshAction.setEnabled(true);
            }
        });
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread(this.statusviewer.getControl(), new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                if (ev.sender == BackupManagerPlugin.getDefault().getBundle().getSymbolicName() || !ev.success.booleanValue()) {
                    return;
                }
                if (BackupManager.this.lstatcombo == null || BackupManager.this.statusviewer == null || BackupManager.this.lstatcombo.isDisposed() || BackupManager.this.statusviewer.getControl().isDisposed()) {
                    return;
                }
                String txt = BackupManager.this.lstatcombo.getText();
                ArrayList<Document> ndocs = txt.equals("All") ? BackupManagerPlugin.getAllFileDocuments() : (txt.equals("Backuped") ? BackupManagerPlugin.getBackupedDocuments() : BackupManagerPlugin.getNotBackupedDocuments());
                BackupManager.this.statusviewer.setInput(null);
                if (BackupManager.this.cursorttc != null) {
                    BaseComparator comp = (BaseComparator)BackupManager.this.cursorttc.getData("Comparator");
                    comp.setColumn(BackupManager.this.cursorttc);
                    Collections.sort(ndocs, comp);
                }
                BackupManager.this.statusviewer.setInput(ndocs);
                if (BackupManager.this.cursorttc != null) {
                    int newdir = Integer.parseInt(String.valueOf(BackupManager.this.cursorttc.getData("Direction"))) == 128 ? 1024 : 128;
                    BackupManager.this.statusviewer.getTable().setSortColumn(BackupManager.this.cursorttc);
                    BackupManager.this.statusviewer.getTable().setSortDirection(newdir);
                }
            }
        }));
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BackupManager.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.statusviewer.getControl());
        this.statusviewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.statusviewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.relinkAction);
        manager.add((IAction)this.backupAction);
        manager.add((IAction)this.exportAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.relinkAction);
        manager.add((IAction)this.backupAction);
        manager.add((IAction)this.exportAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.relinkAction);
        manager.add((IAction)this.backupAction);
        manager.add((IAction)this.exportAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.relinkAction = new RelinkAction(this.statusviewer);
        this.relinkAction.setText("Relink");
        this.relinkAction.setToolTipText("Relink original file.");
        this.relinkAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.backupAction = new BackupAction(this.statusviewer);
        this.backupAction.setText("Backup");
        this.backupAction.setToolTipText("Backup original file.");
        this.backupAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.exportAction = new ExportAction(this.statusviewer);
        this.exportAction.setText("Export");
        this.exportAction.setToolTipText("Export files to specified place.");
        this.exportAction.setImageDescriptor(expimg);
        this.refreshAction = new RefreshAction(this.statusviewer);
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Update all information newer.");
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
    }

    private boolean containsBackupedDocument(ArrayList<Document> docs) {
        int i = 0;
        while (i < docs.size()) {
            Document doc = docs.get(i);
            String path = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)doc));
            if (path != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setFocus() {
        this.statusviewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    private class TableDropListener
    extends DropTargetAdapter {
        private TableDropListener() {
        }

        public void drop(DropTargetEvent e) {
            if (FileTransfer.getInstance().isSupportedType(e.currentDataType)) {
                String[] filepath = (String[])e.data;
                if (filepath == null || filepath.length > 1) {
                    return;
                }
                Document doc = (Document)e.item.getData();
                if (MessageDialog.openConfirm((Shell)BackupManager.this.getSite().getShell(), (String)"Relink", (String)("Link " + FilenameUtils.getName((String)filepath[0]) + " to ID:" + DomImpl.getID((Document)doc) + ". OK?"))) {
                    DataDomImpl.setFilePath((Document)doc, (String)filepath[0]);
                    Request r = new Request(3, (Object)doc, "data");
                    FrameworkPlugin.updateDocuments((Request)r, (Object)"jp.sourceforge.concierge.plugin.backupmanager");
                }
            }
        }
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object dataset) {
            return ((ArrayList)dataset).toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Document doc = (Document)obj;
            TableColumn tc = BackupManager.this.statusviewer.getTable().getColumn(index);
            String title = tc.getText();
            if (title.equals("ID")) {
                return String.valueOf(DomImpl.getID((Document)doc));
            }
            if (title.equals("Path")) {
                return DataDomImpl.getFilePath((Document)doc);
            }
            if (title.equals("Backup date")) {
                String p = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)doc));
                if (p == null) {
                    return null;
                }
                File f = new File(p);
                return new Date(f.lastModified()).toString();
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public Color getBackground(Object obj) {
            return null;
        }

        public Color getForeground(Object obj) {
            Document doc = (Document)obj;
            String fullpath = DataDomImpl.getFilePath((Document)doc);
            File f = new File(fullpath);
            if (f.exists()) {
                return BLACK;
            }
            return RED;
        }
    }
}

