/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.util.ZipFileUtil;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public class XMLReader {
    public static String openFileDialog(Shell shell) {
        FileDialog fd = new FileDialog(shell, 4096);
        String[] ext = new String[]{"*.xml", "*.*"};
        fd.setFilterExtensions(ext);
        String path = fd.open();
        return path;
    }

    public static String[] openFilesDialog(Shell shell) {
        FileDialog fd = new FileDialog(shell, 4098);
        String[] ext = new String[]{"*.xml"};
        fd.setFilterExtensions(ext);
        String path = fd.open();
        if (path != null) {
            String[] filenames = fd.getFileNames();
            if (filenames != null) {
                int i = 0;
                while (i < filenames.length) {
                    filenames[i] = String.valueOf(fd.getFilterPath()) + File.separator + filenames[i];
                    ++i;
                }
            }
            return filenames;
        }
        return null;
    }

    public static String openDirectoryDialog(Shell shell) {
        DirectoryDialog dd = new DirectoryDialog(shell, 4096);
        String path = dd.open();
        return path;
    }

    public static Document ImportXMLFileToPluginDialog(File file, Shell shell, Object requestSender) {
        if (file != null && file.exists()) {
            file.isFile();
        }
        return null;
    }

    protected static Document getTypeDocumentWithPluginid(String pluginid, String version) {
        ArrayList<Document> docs;
        if (pluginid == null) {
            return null;
        }
        if (version == null) {
            version = "";
        }
        if ((docs = TypeManager.getTypeDocumentsByPluginID(pluginid)).size() > 0) {
            int i = 0;
            while (i < docs.size()) {
                Document doc = docs.get(i);
                if (TypeDomImpl.getVersion(doc).equals(version)) {
                    return doc;
                }
                ++i;
            }
        }
        return null;
    }

    public static ArrayList<Document> ImportZipFileToDataDocument(String zipPath, Object requestSender) {
        ArrayList<Document> al = new ArrayList<Document>();
        try {
            Date dNow;
            SimpleDateFormat dateFormat;
            String foldername;
            ZipFile zipFile = new ZipFile(zipPath);
            File tmpFolder = null;
            String tmpdirPath = System.getProperty("java.io.tmpdir");
            if (tmpdirPath != null && tmpdirPath.length() > 0 && !(tmpFolder = new File(tmpdirPath, foldername = (dateFormat = new SimpleDateFormat("yyyyMMddHHmmss")).format(dNow = new Date()))).exists()) {
                tmpFolder.mkdir();
            }
            Enumeration<? extends ZipEntry> all = zipFile.entries();
            while (all.hasMoreElements()) {
                ZipEntry targetZipEntry = all.nextElement();
                try {
                    String filename;
                    String targetEntryName = targetZipEntry.getName();
                    if (targetEntryName == null || !targetEntryName.startsWith("xml" + ZipFileUtil.separator) || targetZipEntry.isDirectory()) continue;
                    Document srcDoc = null;
                    File attachedFile = null;
                    if (targetEntryName.endsWith(".xml")) {
                        try {
                            InputStream is = zipFile.getInputStream(targetZipEntry);
                            srcDoc = XMLReader.XMLToDoc(is);
                            is.close();
                            is = null;
                        }
                        catch (IOException iOException) {
                            srcDoc = null;
                        }
                    }
                    if (srcDoc != null && (filename = DataDomImpl.getFileName(srcDoc)) != null && filename.length() > 0) {
                        ZipEntry attachedZipEntry;
                        String attachedExtension = FilenameUtils.getExtension((String)filename);
                        String attachedFilename = FilenameUtils.getBaseName((String)targetEntryName);
                        if (attachedExtension != null && attachedExtension.length() > 0) {
                            attachedFilename = String.valueOf(attachedFilename) + "." + attachedExtension;
                        }
                        if ((attachedZipEntry = zipFile.getEntry("files" + ZipFileUtil.separator + attachedFilename)) != null) {
                            attachedFile = new File(tmpFolder, attachedFilename);
                            if (!attachedZipEntry.isDirectory()) {
                                try {
                                    FileOutputStream os = new FileOutputStream(attachedFile);
                                    InputStream is = zipFile.getInputStream(attachedZipEntry);
                                    int n = 0;
                                    byte[] b = new byte[8092];
                                    while ((n = is.read(b)) > 0) {
                                        os.write(b, 0, n);
                                    }
                                    is.close();
                                    is = null;
                                    os.close();
                                    os = null;
                                    attachedFile.setLastModified(attachedZipEntry.getTime());
                                }
                                catch (IOException iOException) {
                                    attachedFile = null;
                                }
                            } else {
                                attachedFile.mkdir();
                                attachedFile.setLastModified(attachedZipEntry.getTime());
                                Enumeration<? extends ZipEntry> searchAll = zipFile.entries();
                                while (searchAll.hasMoreElements()) {
                                    String startStr;
                                    ZipEntry searchZipEntry = all.nextElement();
                                    String searchEntryName = searchZipEntry.getName();
                                    if (searchEntryName == null || !searchEntryName.startsWith(startStr = "files" + ZipFileUtil.separator + attachedFilename + ZipFileUtil.separator)) continue;
                                    String child = searchEntryName.substring(startStr.length());
                                    File childFile = new File(attachedFile, child);
                                    if (!searchZipEntry.isDirectory()) {
                                        try {
                                            InputStream is = zipFile.getInputStream(searchZipEntry);
                                            FileOutputStream os = new FileOutputStream(childFile);
                                            int n = 0;
                                            byte[] b = new byte[8092];
                                            while ((n = is.read(b)) > 0) {
                                                os.write(b, 0, n);
                                            }
                                            is.close();
                                            is = null;
                                            os.close();
                                            os = null;
                                            childFile.setLastModified(searchZipEntry.getTime());
                                        }
                                        catch (IOException iOException) {}
                                        continue;
                                    }
                                    childFile.mkdir();
                                    childFile.setLastModified(searchZipEntry.getTime());
                                }
                            }
                        }
                    }
                    if (srcDoc == null) continue;
                    Document newDoc = XMLReader.ImportXMLDocumentToDataDocument(srcDoc, attachedFile.getParentFile(), requestSender);
                    al.add(newDoc);
                }
                catch (Exception exception) {}
            }
            zipFile.close();
        }
        catch (Exception exception) {}
        return al;
    }

    public static Document ImportXMLFileToDataDocument(File xmlFile, File folder, Object requestSender) {
        if (xmlFile != null && xmlFile.exists() && xmlFile.isFile()) {
            try {
                Document srcDoc = XMLReader.XMLToDoc(xmlFile);
                return XMLReader.ImportXMLDocumentToDataDocument(srcDoc, folder, requestSender);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static Document ImportXMLDocumentToDataDocument(Document srcDoc, File folder, Object requestSender) {
        if (srcDoc != null) {
            // empty if block
        }
        return null;
    }

    public static Document XMLToDoc(InputStream is) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Document XMLToDoc(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void createCatalogFromZipFile(String zipPath) {
        Hashtable ht = new Hashtable();
        try {
            ZipFile zipFile = new ZipFile(zipPath);
            Enumeration<? extends ZipEntry> all = zipFile.entries();
            while (all.hasMoreElements()) {
                String[] names;
                ZipEntry ze = all.nextElement();
                String entryName = ze.getName();
                if (entryName.startsWith("xml" + ZipFileUtil.separator)) {
                    names = entryName.split(ZipFileUtil.separator);
                    if (names.length != 3 || !names[2].endsWith(".xml")) continue;
                    ht.put(entryName, new ArrayList());
                    continue;
                }
                if (!entryName.startsWith("files" + ZipFileUtil.separator) || (names = entryName.split(ZipFileUtil.separator)).length <= 2) continue;
                String basename = FilenameUtils.getBaseName((String)names[2]);
                ArrayList al = (ArrayList)ht.get("xml" + ZipFileUtil.separator + basename + ".xml");
                if (al == null) continue;
                al.add(entryName);
            }
            zipFile.close();
        }
        catch (IOException iOException) {}
    }
}

