/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionTreeContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObservableSetTreeContentProvider
implements ITreeContentProvider {
    private final ObservableCollectionTreeContentProvider impl;

    public ObservableSetTreeContentProvider(IObservableFactory setFactory, TreeStructureAdvisor structureAdvisor) {
        this.impl = new Impl(setFactory, structureAdvisor);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public boolean hasChildren(Object element) {
        return this.impl.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        return this.impl.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.impl.getParent(element);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet getKnownElements() {
        return this.impl.getKnownElements();
    }

    private static class Impl
    extends ObservableCollectionTreeContentProvider {
        Impl(IObservableFactory setFactory, TreeStructureAdvisor structureAdvisor) {
            super(setFactory, structureAdvisor);
        }

        protected IObservablesListener createCollectionChangeListener(Object parentElement) {
            return new SetChangeListener(parentElement);
        }

        protected void addCollectionChangeListener(IObservableCollection collection, IObservablesListener listener) {
            IObservableSet set = (IObservableSet)collection;
            ISetChangeListener setListener = (ISetChangeListener)listener;
            set.addSetChangeListener(setListener);
        }

        protected void removeCollectionChangeListener(IObservableCollection collection, IObservablesListener listener) {
            IObservableSet set = (IObservableSet)collection;
            ISetChangeListener setListener = (ISetChangeListener)listener;
            set.removeSetChangeListener(setListener);
        }

        private class SetChangeListener
        implements ISetChangeListener {
            final Object parentElement;

            public SetChangeListener(Object parentElement) {
                this.parentElement = parentElement;
            }

            public void handleSetChange(SetChangeEvent event) {
                Set additions;
                if (Impl.this.isViewerDisposed()) {
                    return;
                }
                Set removals = event.diff.getRemovals();
                if (!removals.isEmpty()) {
                    Impl.this.viewerUpdater.remove(this.parentElement, removals.toArray());
                    Iterator iterator = removals.iterator();
                    while (iterator.hasNext()) {
                        Object child = iterator.next();
                        ObservableCollectionTreeContentProvider.TreeNode childNode = Impl.this.getExistingNode(child);
                        if (childNode == null) continue;
                        childNode.removeParent(this.parentElement);
                    }
                }
                if (!(additions = event.diff.getAdditions()).isEmpty()) {
                    Iterator iterator = additions.iterator();
                    while (iterator.hasNext()) {
                        Object child = iterator.next();
                        Impl.this.getOrCreateNode(child).addParent(this.parentElement);
                    }
                    Impl.this.viewerUpdater.add(this.parentElement, additions.toArray());
                }
            }
        }
    }
}

