/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.customize;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormat;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatAuthorsElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatIdentifiersElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceDataFormatList {
    private Document typedoc = null;
    private ArrayList<ReferenceDataFormat> formatList = null;
    private int formatListIndex = 0;

    public ReferenceDataFormatList(Document typedoc) {
        this.typedoc = typedoc;
        this.formatList = new ArrayList();
    }

    public ArrayList<Element> getTypeElements() {
        ArrayList typeElems = TypeDomImpl.getAllElements((Document)this.typedoc);
        return typeElems;
    }

    public Document getTypeDoc() {
        return this.typedoc;
    }

    public String getTypeName() {
        return TypeDomImpl.getTypeName((Document)this.typedoc);
    }

    public ArrayList<ReferenceDataFormat> getFormatList() {
        return this.formatList;
    }

    public static ReferenceDataFormat newReferenceDataFormat(String formatname, Document typeDoc) {
        ReferenceDataFormat format = new ReferenceDataFormat(formatname);
        ArrayList typeElems = TypeDomImpl.getAllElements((Document)typeDoc);
        int i = 0;
        while (i < typeElems.size()) {
            if (i > 0) {
                format.addElement(new String(", "));
            }
            Element typeElem = (Element)typeElems.get(i);
            String name = TypeDomImpl.getElementName((Element)typeElem);
            String parser = TypeDomImpl.getParser((Element)typeElem);
            if (parser.equalsIgnoreCase("identifiers")) {
                format.addElement(new ReferenceDataFormatIdentifiersElement(name));
            } else if (parser.equalsIgnoreCase("authors")) {
                format.addElement(new ReferenceDataFormatAuthorsElement(name));
            } else {
                format.addElement(new ReferenceDataFormatElement(name));
            }
            ++i;
        }
        return format;
    }

    public void addFormatData(ReferenceDataFormat format) {
        if (format == null) {
            return;
        }
        this.formatList.add(format);
    }

    public void removeFormatData(ReferenceDataFormat format) {
        if (format == null) {
            return;
        }
        this.formatList.remove(format);
    }

    public int getFormatListIndex() {
        return this.formatListIndex;
    }

    public void setFormatListIndex(int index) {
        this.formatListIndex = index;
    }

    public void setFormatListIndex(ReferenceDataFormat format) {
        this.formatListIndex = this.formatList.indexOf(format);
    }
}

