/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.XMLContentDescriber;
import org.eclipse.core.internal.content.XMLRootHandler;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLRootElementContentDescriber2
extends XMLContentDescriber
implements IExecutableExtension {
    private static final String ELEMENT_TO_FIND = "element";
    private QualifiedElement[] elementsToFind = null;
    static /* synthetic */ Class class$0;

    private int checkCriteria(InputSource contents) throws IOException {
        XMLRootHandler xmlHandler = new XMLRootHandler(this.elementsToFind != null);
        try {
            if (!xmlHandler.parseContents(contents)) {
                return 1;
            }
        }
        catch (SAXException sAXException) {
            return 1;
        }
        catch (ParserConfigurationException e) {
            String message = ContentMessages.content_parserConfiguration;
            RuntimeLog.log((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, message, (Throwable)e));
            throw new RuntimeException(message);
        }
        if (this.elementsToFind != null) {
            boolean foundOne = false;
            int i = 0;
            while (i < this.elementsToFind.length && !foundOne) {
                foundOne |= this.elementsToFind[i].matches(xmlHandler.getRootNamespace(), xmlHandler.getRootName(), xmlHandler.getDTD());
                ++i;
            }
            if (!foundOne) {
                return 1;
            }
        }
        return 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.elementsToFind = new QualifiedElement[]{new QualifiedElement((String)data)};
        } else if (data instanceof Hashtable) {
            LinkedList<QualifiedElement> elements = null;
            IConfigurationElement describerElement = config.getChildren("describer")[0];
            IConfigurationElement[] params = describerElement.getChildren("parameter");
            String pname = null;
            int i = 0;
            while (i < params.length) {
                pname = params[i].getAttribute("name");
                if (ELEMENT_TO_FIND.equals(pname)) {
                    if (elements == null) {
                        elements = new LinkedList<QualifiedElement>();
                    }
                    elements.add(new QualifiedElement(params[i].getAttribute("value")));
                }
                ++i;
            }
            ArrayList qualifiedElements = new ArrayList();
            if (elements != null) {
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    qualifiedElements.add(it.next());
                }
            }
            this.elementsToFind = qualifiedElements.toArray(new QualifiedElement[qualifiedElements.size()]);
        }
        if (this.elementsToFind.length == 0) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.content.XMLRootElementContentDescriber2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String message = NLS.bind((String)ContentMessages.content_badInitializationData, (Object)clazz.getName());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, message, null));
        }
    }

    private class QualifiedElement {
        private String namespace;
        private String element;
        private String dtd;

        public QualifiedElement(String namespace, String element, String dtd) {
            this.namespace = namespace;
            this.element = element;
            this.dtd = dtd;
        }

        public QualifiedElement(String qualifiedElement) {
            int dtdSlash;
            int openBrace = qualifiedElement.indexOf(123);
            int closeBrace = qualifiedElement.indexOf(125);
            if (openBrace == 0 && closeBrace >= 1) {
                this.namespace = qualifiedElement.substring(1, closeBrace);
                qualifiedElement = qualifiedElement.substring(closeBrace + 1);
            }
            if ((dtdSlash = qualifiedElement.indexOf(47)) > 0) {
                this.dtd = qualifiedElement.substring(dtdSlash + 1);
                qualifiedElement = qualifiedElement.substring(0, dtdSlash);
            }
            this.element = "*".equals(qualifiedElement) ? null : qualifiedElement;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getElement() {
            return this.element;
        }

        public String getDTD() {
            return this.dtd;
        }

        public boolean matches(String someNamespace, String someElement, String someDtd) {
            boolean dtdEquals;
            boolean nsMatch = this.namespace != null ? this.namespace.equals(someNamespace) : true;
            boolean elementEquals = this.element != null ? this.element.equals(someElement) : true;
            boolean bl = dtdEquals = this.dtd != null ? this.dtd.equals(someDtd) : true;
            return nsMatch && elementEquals && dtdEquals;
        }
    }
}

