/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.searcher.data;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.searcher.SearchCalendar;
import jp.sourceforge.concierge.plugin.searcher.data.ConjunctionType;
import jp.sourceforge.concierge.plugin.searcher.data.PeriodType;
import jp.sourceforge.concierge.plugin.searcher.data.SearchType;
import jp.sourceforge.concierge.plugin.searcher.data.WordCondition;
import jp.sourceforge.concierge.util.XPathString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Configure {
    public static InfoType getInfoType(Element info) {
        return InfoType.valueOf(DomImpl.getAttribute((Element)info, (String)"kind"));
    }

    public static void setInfoType(Element info, InfoType type) {
        DomImpl.setAttribute((Element)info, (String)"kind", (String)type.toString());
    }

    private static Element getNameElement(Element info) {
        ArrayList elems = DomImpl.getElements((Element)info, (String)"Name");
        assert (elems.size() > 0);
        return (Element)elems.get(0);
    }

    public static String getName(Element info) {
        Element ne = Configure.getNameElement(info);
        return DomImpl.getElementText((Element)ne);
    }

    public static void setName(Element info, String name) {
        Element ne = Configure.getNameElement(info);
        DomImpl.setElementText((Element)ne, (String)name);
    }

    public static String getXPath(Element info) {
        return DomImpl.getAttribute((Element)info, (String)"xpath");
    }

    public static void setXPath(Element info, String xpath) {
        DomImpl.setAttribute((Element)info, (String)"xpath", (String)xpath);
    }

    public static ArrayList<Document> getBindedDocuments(Element info) {
        ArrayList<Document> list = new ArrayList<Document>();
        ArrayList dinfos = DomImpl.getElements((Element)info, (String)"DataInfo");
        assert (dinfos != null && dinfos.size() > 0);
        ArrayList idelems = DomImpl.getElements((Element)((Element)dinfos.get(0)), (String)"Data");
        if (idelems.size() == 0) {
            return list;
        }
        ArrayList<String> ids = new ArrayList<String>();
        int i = 0;
        while (i < idelems.size()) {
            ids.add(DomImpl.getAttribute((Element)((Element)idelems.get(i)), (String)"id"));
            ++i;
        }
        String xpath = "/mdata[" + XPathString.getAttributeEqualsPredicate((String)"id", ids, (boolean)false) + "]";
        Request req = new Request(4, (Object)xpath, "data");
        return FrameworkPlugin.getDocumentsOfQuery((Request)req);
    }

    public static void setBindedDocuments(Element info, ArrayList<Document> list) {
        ArrayList idelems = DomImpl.getElements((Element)info, (String)"DataInfo");
        assert (idelems != null && idelems.size() > 0);
        Element ids = (Element)idelems.get(0);
        DomImpl.removeAllChildren((Element)ids);
        int i = 0;
        while (i < list.size()) {
            Document doc = list.get(i);
            long id = DomImpl.getID((Document)doc);
            Element data = DomImpl.appendElement((Element)ids, (String)"Data");
            DomImpl.setAttribute((Element)data, (String)"id", (String)Long.toString(id));
            ++i;
        }
    }

    private static Element getSearchElement(Element info) {
        ArrayList list = DomImpl.getElements((Element)info, (String)"Search");
        assert (list.size() > 0);
        return (Element)list.get(0);
    }

    public static ArrayList<WordCondition> getKeywords(Element info) {
        Element search = Configure.getSearchElement(info);
        ArrayList<WordCondition> list = new ArrayList<WordCondition>();
        ArrayList elems = DomImpl.getElements((Element)search, (String)"KeywordInfo");
        assert (elems != null && elems.size() > 0);
        ArrayList kwds = DomImpl.getElements((Element)((Element)elems.get(0)), (String)"Keyword");
        if (kwds == null || kwds.size() == 0) {
            return list;
        }
        int i = 0;
        while (i < kwds.size()) {
            Element kwd = (Element)kwds.get(i);
            WordCondition wc = new WordCondition();
            wc.text = DomImpl.getElementText((Element)kwd);
            wc.type = DomImpl.getAttribute((Element)kwd, (String)"type");
            wc.item = DomImpl.getAttribute((Element)kwd, (String)"item");
            wc.condition = WordCondition.ConditionType.valueOf(DomImpl.getAttribute((Element)kwd, (String)"condition"));
            list.add(wc);
            ++i;
        }
        return list;
    }

    public static void setKeywords(Element info, ArrayList<WordCondition> wcs) {
        Element search = Configure.getSearchElement(info);
        ArrayList elems = DomImpl.getElements((Element)search, (String)"KeywordInfo");
        assert (elems != null && elems.size() > 0);
        DomImpl.removeAllChildren((Element)((Element)elems.get(0)));
        int i = 0;
        while (i < wcs.size()) {
            WordCondition wc = wcs.get(i);
            Element elemKey = DomImpl.appendElement((Element)((Element)elems.get(0)), (String)"Keyword");
            DomImpl.setElementText((Element)elemKey, (String)wc.text);
            DomImpl.setAttribute((Element)elemKey, (String)"type", (String)wc.type);
            DomImpl.setAttribute((Element)elemKey, (String)"item", (String)wc.item);
            DomImpl.setAttribute((Element)elemKey, (String)"condition", (String)wc.condition.toString());
            ++i;
        }
    }

    public static void setConjunction(Element info, ConjunctionType ct) {
        Element search = Configure.getSearchElement(info);
        DomImpl.setAttribute((Element)search, (String)"conjunction", (String)ct.toString());
    }

    public static ConjunctionType getConjunction(Element info) {
        Element search = Configure.getSearchElement(info);
        return ConjunctionType.valueOf(DomImpl.getAttribute((Element)search, (String)"conjunction"));
    }

    private static Element getModRangeElement(Element info) {
        Element search = Configure.getSearchElement(info);
        ArrayList elems = DomImpl.getElements((Element)search, (String)"ModRange");
        assert (elems != null && elems.size() > 0);
        return (Element)elems.get(0);
    }

    public static PeriodType getModRangePattern(Element info) {
        Element elem = Configure.getModRangeElement(info);
        return PeriodType.valueOf(DomImpl.getAttribute((Element)elem, (String)"pattern"));
    }

    public static SearchType getModRangeStamp(Element info) {
        Element elem = Configure.getModRangeElement(info);
        return SearchType.valueOf(DomImpl.getAttribute((Element)elem, (String)"stamp"));
    }

    public static Element getModRangeIntervalElement(Element info) {
        Element range = Configure.getModRangeElement(info);
        ArrayList elems = DomImpl.getElements((Element)range, (String)"Interval");
        assert (elems != null && elems.size() > 0);
        return (Element)elems.get(0);
    }

    public static int getModRangeSinceDate(Element info) {
        Element range = Configure.getModRangeElement(info);
        ArrayList elems = DomImpl.getElements((Element)range, (String)"SinceDate");
        assert (elems != null && elems.size() > 0);
        return Integer.parseInt(DomImpl.getAttribute((Element)((Element)elems.get(0)), (String)"num"));
    }

    public static int getModRangeSinceWeek(Element info) {
        Element range = Configure.getModRangeElement(info);
        ArrayList elems = DomImpl.getElements((Element)range, (String)"SinceWeek");
        assert (elems != null && elems.size() > 0);
        return Integer.parseInt(DomImpl.getAttribute((Element)((Element)elems.get(0)), (String)"num"));
    }

    public static int getModRangeSinceMonth(Element info) {
        Element range = Configure.getModRangeElement(info);
        ArrayList elems = DomImpl.getElements((Element)range, (String)"SinceMonth");
        assert (elems != null && elems.size() > 0);
        return Integer.parseInt(DomImpl.getAttribute((Element)((Element)elems.get(0)), (String)"num"));
    }

    public static SearchCalendar getOneDateCalendar(Element info) {
        Element elem = Configure.getModRangeElement(info);
        ArrayList cales = DomImpl.getElements((Element)elem, (String)"OneDate");
        assert (cales != null && cales.size() > 0);
        return Configure.getCalendar((Element)cales.get(0));
    }

    public static PeriodType getOneDatePeriodType(Element info) {
        Element elem = Configure.getModRangeElement(info);
        ArrayList cales = DomImpl.getElements((Element)elem, (String)"OneDate");
        assert (cales != null && cales.size() > 0);
        return PeriodType.valueOf(DomImpl.getAttribute((Element)((Element)cales.get(0)), (String)"unit"));
    }

    public static SearchCalendar getCalendar(Element calelem) {
        SearchCalendar cal = new SearchCalendar();
        String s = DomImpl.getAttribute((Element)calelem, (String)"year");
        if (s == "") {
            s = String.valueOf(cal.get(1));
        }
        int year = Integer.parseInt(s);
        s = DomImpl.getAttribute((Element)calelem, (String)"month");
        if (s == "") {
            s = String.valueOf(cal.get(2) + 1);
        }
        int month = Integer.parseInt(s);
        s = DomImpl.getAttribute((Element)calelem, (String)"day");
        if (s == "") {
            s = String.valueOf(cal.get(5));
        }
        int day = Integer.parseInt(s);
        cal.set(year, month, day);
        return cal;
    }

    public static SearchCalendar getModIntervalRangeStartDate(Element info) {
        Element elem = Configure.getModRangeIntervalElement(info);
        ArrayList ss = DomImpl.getElements((Element)elem, (String)"StartDate");
        assert (ss != null && ss.size() > 0);
        return Configure.getCalendar((Element)ss.get(0));
    }

    public static SearchCalendar getModIntervalRangeEndDate(Element info) {
        Element elem = Configure.getModRangeIntervalElement(info);
        ArrayList ss = DomImpl.getElements((Element)elem, (String)"EndDate");
        assert (ss != null && ss.size() > 0);
        return Configure.getCalendar((Element)ss.get(0));
    }

    public static void setModRangePattern(Element info, PeriodType pattern) {
        Element elem = Configure.getModRangeElement(info);
        DomImpl.setAttribute((Element)elem, (String)"pattern", (String)pattern.toString());
    }

    public static void setModRangeStamp(Element info, SearchType stamp) {
        Element elem = Configure.getModRangeElement(info);
        DomImpl.setAttribute((Element)elem, (String)"stamp", (String)stamp.toString());
    }

    public static void setModRangeSinceDate(Element info, int num) {
        Element range = Configure.getModRangeElement(info);
        ArrayList elems = DomImpl.getElements((Element)range, (String)"SinceDate");
        assert (elems != null && elems.size() > 0);
        DomImpl.setAttribute((Element)((Element)elems.get(0)), (String)"num", (String)Integer.toString(num));
    }

    public static void setModRangeSinceWeek(Element info, int num) {
        Element range = Configure.getModRangeElement(info);
        ArrayList elems = DomImpl.getElements((Element)range, (String)"SinceWeek");
        assert (elems != null && elems.size() > 0);
        DomImpl.setAttribute((Element)((Element)elems.get(0)), (String)"num", (String)Integer.toString(num));
    }

    public static void setModRangeSinceMonth(Element info, int num) {
        Element range = Configure.getModRangeElement(info);
        ArrayList elems = DomImpl.getElements((Element)range, (String)"SinceMonth");
        assert (elems != null && elems.size() > 0);
        DomImpl.setAttribute((Element)((Element)elems.get(0)), (String)"num", (String)Integer.toString(num));
    }

    public static void setOneDatePeriodType(Element info, PeriodType type) {
        Element elem = Configure.getModRangeElement(info);
        ArrayList cales = DomImpl.getElements((Element)elem, (String)"OneDate");
        assert (cales != null && cales.size() > 0);
        DomImpl.setAttribute((Element)((Element)cales.get(0)), (String)"unit", (String)type.toString());
    }

    public static void setOneDateCalendar(Element info, SearchCalendar cal) {
        Element elem = Configure.getModRangeElement(info);
        ArrayList ss = DomImpl.getElements((Element)elem, (String)"OneDate");
        assert (ss != null && ss.size() > 0);
        Configure.setCalendar((Element)ss.get(0), cal);
    }

    public static void setCalendar(Element calelem, SearchCalendar cal) {
        ArrayList ss = DomImpl.getElements((Element)calelem, (String)"Calendar");
        if (ss.size() == 0) {
            return;
        }
        Element e = (Element)ss.get(0);
        int num = cal.get(1);
        e.setAttribute("year", Integer.toString(num));
        num = cal.get(2);
        e.setAttribute("month", Integer.toString(num));
        num = cal.get(5);
        e.setAttribute("day", Integer.toString(num));
    }

    public static void setModIntervalRangeStartDate(Element info, SearchCalendar cal) {
        Element elem = Configure.getModRangeIntervalElement(info);
        ArrayList ss = DomImpl.getElements((Element)elem, (String)"StartDate");
        assert (ss != null && ss.size() > 0);
        Configure.setCalendar((Element)ss.get(0), cal);
    }

    public static void setModIntervalRangeEndDate(Element info, SearchCalendar cal) {
        Element elem = Configure.getModRangeIntervalElement(info);
        ArrayList ss = DomImpl.getElements((Element)elem, (String)"EndDate");
        assert (ss != null && ss.size() > 0);
        Configure.setCalendar((Element)ss.get(0), cal);
    }

    public static Document createConfigDocument(InfoType type) {
        Document doc = DomImpl.createDocument((String)"ccgconfig");
        Element docnode = DomImpl.getRootElement((Document)doc);
        DomImpl.setAttribute((Element)docnode, (String)"name", (String)"SFolder2");
        Element info = DomImpl.appendElement((Element)docnode, (String)"Info");
        Configure.setDefaultElement(info, type);
        return doc;
    }

    public static Element setDefaultElement(Element info, InfoType type) {
        DomImpl.setAttribute((Element)info, (String)"kind", (String)type.toString());
        Element nameElem = DomImpl.appendElement((Element)info, (String)"Name");
        DomImpl.setElementText((Element)nameElem, (String)"Untitled");
        Element searchElem = DomImpl.appendElement((Element)info, (String)"Search");
        DomImpl.setAttribute((Element)searchElem, (String)"conjunction", (String)ConjunctionType.AND.toString());
        Element modRange = DomImpl.appendElement((Element)searchElem, (String)"ModRange");
        DomImpl.setAttribute((Element)modRange, (String)"pattern", (String)PeriodType.THIS_DAY.toString());
        DomImpl.setAttribute((Element)modRange, (String)"stamp", (String)SearchType.CREATEDATE.toString());
        Element sDate = DomImpl.appendElement((Element)modRange, (String)"SinceDate");
        DomImpl.setAttribute((Element)sDate, (String)"num", (String)"1");
        Element sWeek = DomImpl.appendElement((Element)modRange, (String)"SinceWeek");
        DomImpl.setAttribute((Element)sWeek, (String)"num", (String)"1");
        Element sMonth = DomImpl.appendElement((Element)modRange, (String)"SinceMonth");
        DomImpl.setAttribute((Element)sMonth, (String)"num", (String)"1");
        Element interval = DomImpl.appendElement((Element)modRange, (String)"Interval");
        Element start = DomImpl.appendElement((Element)interval, (String)"StartDate");
        Element sCal = DomImpl.appendElement((Element)start, (String)"Calendar");
        SearchCalendar calToday = new SearchCalendar();
        int year = calToday.get(1);
        int month = calToday.get(2);
        int day = calToday.get(5);
        DomImpl.setAttribute((Element)sCal, (String)"year", (String)Integer.toString(year));
        DomImpl.setAttribute((Element)sCal, (String)"month", (String)Integer.toString(month));
        DomImpl.setAttribute((Element)sCal, (String)"day", (String)Integer.toString(day));
        Element end = DomImpl.appendElement((Element)interval, (String)"EndDate");
        Element eCal = DomImpl.appendElement((Element)end, (String)"Calendar");
        DomImpl.setAttribute((Element)eCal, (String)"year", (String)Integer.toString(year));
        DomImpl.setAttribute((Element)eCal, (String)"month", (String)Integer.toString(month));
        DomImpl.setAttribute((Element)eCal, (String)"day", (String)Integer.toString(day));
        Element oneDay = DomImpl.appendElement((Element)modRange, (String)"OneDate");
        DomImpl.setAttribute((Element)oneDay, (String)"unit", (String)PeriodType.EXACT_A_DAY.toString());
        Element oCal = DomImpl.appendElement((Element)oneDay, (String)"Calendar");
        DomImpl.setAttribute((Element)oCal, (String)"year", (String)Integer.toString(year));
        DomImpl.setAttribute((Element)oCal, (String)"month", (String)Integer.toString(month));
        DomImpl.setAttribute((Element)oCal, (String)"day", (String)Integer.toString(day));
        DomImpl.appendElement((Element)searchElem, (String)"KeywordInfo");
        DomImpl.appendElement((Element)info, (String)"DataInfo");
        return info;
    }

    public static Element copyInfo(Element in) {
        return (Element)in.cloneNode(true);
    }

    public static enum InfoType {
        BINDER,
        SEARCH;

    }
}

