/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.SearcherPlugin;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.widget.SearchComposite;
import jp.sourceforge.concierge.widget.SimpleSearchComposite;
import jp.sourceforge.concierge.widget.TextInputDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Searcher
extends ConciergeViewPart {
    IMemento memento = null;
    private Composite parent = null;
    private SearchComposite searchcomp = null;
    private SimpleSearchComposite ssearchcomp = null;
    private ScrolledComposite sccomp1 = null;
    private ScrolledComposite sccomp2 = null;
    Action runAction;
    Action exportAction;
    Action viewAction;
    ImageDescriptor runimg = SearcherPlugin.getImageDescriptor("icons/run.png");
    ImageDescriptor changeimg = SearcherPlugin.getImageDescriptor("icons/change.png");

    private boolean contains(ArrayList<Document> docs, Document doc) {
        int i = 0;
        while (i < docs.size()) {
            if (DomImpl.equalsByID((Document)docs.get(i), (Document)doc)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setActions() {
        this.runAction = new Action(){

            public void run() {
                String xpath = null;
                ArrayList<Document> docs = null;
                StackLayout sl = (StackLayout)Searcher.this.parent.getLayout();
                if (sl.topControl.equals(Searcher.this.sccomp1)) {
                    xpath = Searcher.this.searchcomp.getXPath();
                    docs = SearcherPlugin.search(xpath);
                    if (docs != null) {
                        Searcher.this.setDocumentsToTabulator(xpath);
                    }
                } else {
                    xpath = Searcher.this.ssearchcomp.getXPath();
                    docs = SearcherPlugin.search(xpath);
                    if (Searcher.this.ssearchcomp.isFileContentSearch()) {
                        String words = Searcher.this.ssearchcomp.getWords();
                        ArrayList<Document> fdocs = SearcherPlugin.searchFileContents(words);
                        int i = 0;
                        while (i < fdocs.size()) {
                            if (!Searcher.this.contains(docs, fdocs.get(i))) {
                                docs.add(fdocs.get(i));
                            }
                            ++i;
                        }
                        if (docs != null) {
                            Searcher.this.setDocumentsToTabulator(docs);
                        }
                    } else if (docs != null) {
                        Searcher.this.setDocumentsToTabulator(xpath);
                    }
                }
            }
        };
        this.runAction.setText("Search");
        this.runAction.setToolTipText("Search on the condition.");
        this.runAction.setImageDescriptor(this.runimg);
        this.exportAction = new Action(){

            public void run() {
                StackLayout sl = (StackLayout)Searcher.this.parent.getLayout();
                if (!sl.topControl.equals(Searcher.this.sccomp1)) {
                    return;
                }
                TextInputDialog nid = new TextInputDialog(Searcher.this.searchcomp.getShell(), "Input export name", "Input export name");
                if (nid.open() == 1) {
                    return;
                }
                String name = nid.getValue();
                if (name == null || name.length() == 0) {
                    return;
                }
                Element info = SearcherPlugin.createInfo(name, Configure.InfoType.SEARCH);
                Searcher.this.searchcomp.save(info);
                SearcherPlugin.addInfo(info, null);
            }
        };
        this.exportAction.setText("Export to SmartIndexer");
        this.exportAction.setToolTipText("Export to SmartIndexer.");
        this.exportAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_EXPORT_WIZ"));
        this.exportAction.setEnabled(false);
        this.viewAction = new Action(){

            public void run() {
                StackLayout sl = (StackLayout)Searcher.this.parent.getLayout();
                if (sl.topControl.equals(Searcher.this.sccomp1)) {
                    Searcher.this.exportAction.setEnabled(false);
                    sl.topControl = Searcher.this.sccomp2;
                } else {
                    Searcher.this.exportAction.setEnabled(true);
                    sl.topControl = Searcher.this.sccomp1;
                }
                Searcher.this.parent.layout();
                Searcher.this.update();
            }
        };
        this.viewAction.setText("Change mode");
        this.viewAction.setToolTipText("Change Simple/Expert search");
        this.viewAction.setImageDescriptor(this.changeimg);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Searcher.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.parent);
        this.parent.setMenu(menu);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.runAction);
        manager.add((IAction)this.exportAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.viewAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.runAction);
        manager.add((IAction)this.exportAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.viewAction);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void update() {
        StackLayout sl = (StackLayout)this.parent.getLayout();
        ScrolledComposite sc = (ScrolledComposite)sl.topControl;
        Point p = sc.getContent().computeSize(-1, -1);
        sc.setMinSize(p);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new StackLayout());
        this.parent = parent;
        this.sccomp1 = new ScrolledComposite(parent, 772);
        this.sccomp1.setAlwaysShowScrollBars(false);
        this.searchcomp = new SearchComposite((Composite)this.sccomp1, 0, true);
        this.sccomp1.setContent((Control)this.searchcomp);
        this.sccomp1.setMinSize(320, 180);
        this.sccomp1.setExpandHorizontal(true);
        this.sccomp1.setExpandVertical(true);
        this.searchcomp.setUpdateAction(new Action(){

            public void run() {
                Searcher.this.update();
            }
        });
        this.searchcomp.getKeywordComposite().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    Searcher.this.runAction.run();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sccomp2 = new ScrolledComposite(parent, 772);
        this.sccomp2.setAlwaysShowScrollBars(false);
        this.ssearchcomp = new SimpleSearchComposite((Composite)this.sccomp2, 0);
        this.ssearchcomp.setLayoutData(new GridData(768));
        this.sccomp2.setContent((Control)this.ssearchcomp);
        this.sccomp2.setMinSize(320, 180);
        this.sccomp2.setExpandHorizontal(true);
        this.sccomp2.setExpandVertical(true);
        this.ssearchcomp.setKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    Searcher.this.runAction.run();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.ssearchcomp.setButtonListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Searcher.this.runAction.run();
            }
        });
        StackLayout sl = (StackLayout)parent.getLayout();
        sl.topControl = this.sccomp1;
        this.searchcomp.update();
        this.update();
        this.setActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    public void setDocumentsToTabulator(String xpath) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            ConciergeViewPart tabulator = (ConciergeViewPart)page.findView("jp.sourceforge.concierge.plugin.tabulator");
            if ((tabulator == null || !tabulator.getPartName().equals("Tabulator") && !tabulator.getPartName().equals("Searcher's result")) && (tabulator = (ConciergeViewPart)page.showView("jp.sourceforge.concierge.plugin.tabulator", "jp.sourceforge.concierge.searcher", 3)) == null) {
                return;
            }
            tabulator.setPartProperty("TITLE", "Searcher's result");
            tabulator.setDocuments(xpath);
            page.activate((IWorkbenchPart)tabulator);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void setDocumentsToTabulator(ArrayList<Document> docs) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            ConciergeViewPart tabulator = (ConciergeViewPart)page.findView("jp.sourceforge.concierge.plugin.tabulator");
            if ((tabulator == null || !tabulator.getPartName().equals("Tabulator") && !tabulator.getPartName().equals("Searcher's result")) && (tabulator = (ConciergeViewPart)page.showView("jp.sourceforge.concierge.plugin.tabulator", "jp.sourceforge.concierge.searcher", 3)) == null) {
                return;
            }
            tabulator.setPartProperty("TITLE", "Searcher's result");
            ArrayList<Document> d = new ArrayList<Document>();
            int i = 0;
            while (i < docs.size()) {
                Document doc = docs.get(i);
                if (!d.contains(doc)) {
                    d.add(doc);
                }
                ++i;
            }
            tabulator.setDocuments(d);
            page.activate((IWorkbenchPart)tabulator);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
        this.parent.setFocus();
    }
}

