/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.imageviewer;

import jp.sourceforge.concierge.plugin.ImageUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class DrawArea {
    private Image drawimage = null;
    private Image oldimage = null;
    private Color delcolor = null;
    private int linewidth = 3;
    private Control control;

    protected void finalize() throws Throwable {
        if (this.oldimage != null) {
            this.oldimage.dispose();
        }
        this.drawimage.dispose();
        this.delcolor.dispose();
        super.finalize();
    }

    public DrawArea(Control control, int width, int height) {
        this.drawimage = new Image((Device)control.getDisplay(), ImageUtils.createImageData(width, height));
        this.delcolor = ImageUtils.getTransparentColor(control);
        this.control = control;
    }

    public DrawArea(Control control, String file) {
        this.drawimage = ImageUtils.loadMemoImage(control, file);
        this.delcolor = ImageUtils.getTransparentColor(control);
        this.control = control;
    }

    public void setLineWidth(int w) {
        this.linewidth = w;
    }

    public void setImage(Image img) {
        if (this.drawimage != null && !this.drawimage.isDisposed()) {
            this.drawimage.dispose();
        }
        this.drawimage = new Image((Device)this.control.getDisplay(), img.getImageData());
    }

    public Image getImage() {
        return this.drawimage;
    }

    public void drawImage(GC gc, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        ImageData id = this.drawimage.getImageData();
        if (sx + sw > id.width) {
            sw = id.width - sx;
        }
        if (sy + sh > id.height) {
            sh = id.height - sy;
        }
        gc.drawImage(this.drawimage, sx, sy, sw, sh, dx, dy, dw, dh);
    }

    public void drawLine(int x1, int y1, int x2, int y2, Color c) {
        GC gc = new GC((Drawable)this.drawimage);
        gc.setForeground(c);
        gc.setLineWidth(this.linewidth);
        gc.drawLine(x1, y1, x2, y2);
        gc.dispose();
    }

    public void drawText(int x, int y, String text, Color c, Font f) {
        GC gc = new GC((Drawable)this.drawimage);
        gc.setForeground(c);
        gc.setFont(f);
        gc.drawText(text, x, y, true);
        gc.dispose();
    }

    public void deleteArea(Rectangle r) {
        GC gc = new GC((Drawable)this.drawimage);
        gc.setForeground(this.delcolor);
        gc.setBackground(this.delcolor);
        gc.fillRectangle(r);
        gc.dispose();
    }

    public void reset() {
        int w = this.drawimage.getImageData().width;
        int h = this.drawimage.getImageData().height;
        this.drawimage.dispose();
        this.drawimage = new Image((Device)this.control.getDisplay(), ImageUtils.createImageData(w, h));
    }

    public void commit() {
        if (this.oldimage != null) {
            this.oldimage.dispose();
        }
        this.oldimage = new Image((Device)this.control.getDisplay(), (ImageData)this.drawimage.getImageData().clone());
    }

    public void undo() {
        if (this.oldimage == null) {
            return;
        }
        this.drawimage.dispose();
        this.drawimage = this.oldimage;
        this.oldimage = null;
    }
}

