/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ImageUtils {
    private static RGB[] palette = new RGB[]{new RGB(254, 254, 254), new RGB(200, 200, 200), new RGB(0, 0, 0), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(0, 0, 255), new RGB(255, 255, 0), new RGB(0, 255, 255), new RGB(255, 0, 255), new RGB(255, 255, 255)};

    public static ImageData createImageData(int width, int height) {
        ImageData id = new ImageData(width, height, 8, new PaletteData(palette));
        id.transparentPixel = 0;
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                id.setPixel(i, j, id.transparentPixel);
                ++j;
            }
            ++i;
        }
        return id;
    }

    public static Color getTransparentColor(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, 254, 254, 254);
    }

    public static Color getSelectionColor(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, 200, 200, 200);
    }

    public static Color getBlack(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, palette[2]);
    }

    public static Color getRed(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, palette[3]);
    }

    public static Color getGreen(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, palette[4]);
    }

    public static Color getBlue(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, palette[5]);
    }

    public static Color getMagenta(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, palette[6]);
    }

    public static Color getCyan(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, palette[7]);
    }

    public static Color getYellow(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, palette[8]);
    }

    public static Color getWhite(Control ctrl) {
        Display d = ctrl == null ? null : ctrl.getDisplay();
        return new Color((Device)d, palette[9]);
    }

    public static Color getColorByColor(Control ctrl, Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = 0;
        while (i < palette.length) {
            if (Math.abs(r - ImageUtils.palette[i].red) < 10 && Math.abs(g - ImageUtils.palette[i].green) < 10 && Math.abs(b - ImageUtils.palette[i].blue) < 10) {
                Display d = ctrl == null ? null : ctrl.getDisplay();
                return new Color((Device)d, palette[i]);
            }
            ++i;
        }
        return null;
    }

    public static Image loadMemoImage(Display disp, String file) {
        int tpxl;
        ImageLoader iloader = new ImageLoader();
        ImageData[] ids = iloader.load(file);
        ImageData id = ids[0];
        id.transparentPixel = tpxl = id.palette.getPixel(new RGB(254, 254, 254));
        return new Image((Device)disp, id);
    }

    public static Image loadMemoImage(Control control, String file) {
        return ImageUtils.loadMemoImage(control.getDisplay(), file);
    }
}

