/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ibooks;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConciergeDialogArea
implements IConciergeDialogArea {
    private Document schema = TypeManager.getTypeDocument((String)"Book");
    private Document doc = null;
    private IEditorEventListener elistener;
    private Hashtable<String, Control> texthash = new Hashtable();
    private Composite topcomposite = null;
    private static final int thumbnailImageSize = 120;
    private static final String catchFolderName = "ibooks";

    public Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.topcomposite = new Composite(parent, 0);
        this.topcomposite.setLayoutData((Object)new GridData(1808));
        this.topcomposite.setLayout((Layout)new GridLayout(1, false));
        Group referenceInfoGp = new Group(this.topcomposite, 0);
        referenceInfoGp.setText("Reference Info");
        referenceInfoGp.setLayoutData((Object)new GridData(1808));
        referenceInfoGp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)referenceInfoGp, 0);
        label.setText("Author");
        Text authorText = new Text((Composite)referenceInfoGp, 2048);
        authorText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Author", (Control)authorText);
        ITypeParser p = FrameworkPlugin.getParser((String)"authors");
        if (p != null) {
            authorText.setToolTipText(p.getMessage());
        }
        authorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                }
            }
        });
        label = new Label((Composite)referenceInfoGp, 0);
        label.setText("Title");
        Text titleText = new Text((Composite)referenceInfoGp, 2048);
        titleText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Title", (Control)titleText);
        p = FrameworkPlugin.getParser((String)"text");
        if (p != null) {
            titleText.setToolTipText(p.getMessage());
        }
        titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                }
            }
        });
        Composite composite0 = new Composite((Composite)referenceInfoGp, 0);
        GridData gd0 = new GridData(768);
        gd0.horizontalSpan = 2;
        composite0.setLayoutData((Object)gd0);
        GridLayout gl0 = new GridLayout(2, false);
        gl0.marginWidth = 0;
        gl0.marginHeight = 0;
        composite0.setLayout((Layout)gl0);
        Composite composite1 = new Composite(composite0, 0);
        GridData gd1 = new GridData(768);
        composite1.setLayoutData((Object)gd1);
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite1.setLayout((Layout)gl);
        Label label2 = new Label(composite1, 0);
        label2.setText("Publisher");
        Text publisherText = new Text(composite1, 2048);
        publisherText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Publisher", (Control)publisherText);
        ITypeParser p2 = FrameworkPlugin.getParser((String)"text");
        if (p2 != null) {
            publisherText.setToolTipText(p2.getMessage());
        }
        publisherText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                }
            }
        });
        label2 = new Label(composite1, 0);
        label2.setText("Category");
        Text categoryText = new Text(composite1, 2048);
        categoryText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Category", (Control)categoryText);
        p2 = FrameworkPlugin.getParser((String)"text");
        if (p2 != null) {
            categoryText.setToolTipText(p2.getMessage());
        }
        categoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                }
            }
        });
        label2 = new Label(composite1, 0);
        label2.setText("Year");
        Text yearText = new Text(composite1, 2048);
        yearText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Year", (Control)yearText);
        p2 = FrameworkPlugin.getParser((String)"text");
        if (p2 != null) {
            yearText.setToolTipText(p2.getMessage());
        }
        yearText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                }
            }
        });
        label2 = new Label(composite1, 0);
        label2.setText("Price");
        Text priceText = new Text(composite1, 2048);
        priceText.setLayoutData((Object)new GridData(768));
        this.texthash.put("Price", (Control)priceText);
        p2 = FrameworkPlugin.getParser((String)"text");
        if (p2 != null) {
            priceText.setToolTipText(p2.getMessage());
        }
        priceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                }
            }
        });
        Label thumbnail = new Label(composite0, 0x1000000);
        GridData gd = new GridData(1808);
        gd.widthHint = 120;
        gd.heightHint = 120;
        thumbnail.setLayoutData((Object)gd);
        this.texthash.put("thumbnail", (Control)thumbnail);
        label = new Label((Composite)referenceInfoGp, 0);
        label.setText("ISBN");
        Text isbnText = new Text((Composite)referenceInfoGp, 2048);
        isbnText.setLayoutData((Object)new GridData(768));
        this.texthash.put("ISBN", (Control)isbnText);
        p = FrameworkPlugin.getParser((String)"text");
        if (p != null) {
            isbnText.setToolTipText(p.getMessage());
        }
        isbnText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                }
            }
        });
        Group linkageGp = new Group(this.topcomposite, 0);
        linkageGp.setText("Linkage Info");
        linkageGp.setLayoutData((Object)new GridData(768));
        linkageGp.setLayout((Layout)new GridLayout(2, false));
        Label label3 = new Label((Composite)linkageGp, 0);
        label3.setText("URL");
        Text urlText = new Text((Composite)linkageGp, 2048);
        urlText.setLayoutData((Object)new GridData(768));
        this.texthash.put("URL", (Control)urlText);
        ITypeParser p3 = FrameworkPlugin.getParser((String)"text");
        if (p3 != null) {
            urlText.setToolTipText(p3.getMessage());
        }
        urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConciergeDialogArea.this.elistener != null) {
                    ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                }
            }
        });
        this.refresh();
        return parent;
    }

    public Document saveDocument() {
        Element data = DataDomImpl.getDataOfType((Document)this.doc, (String)"Book");
        if (data == null) {
            data = DataDomImpl.addDataOfType((Document)this.doc, (Document)this.schema);
        }
        ArrayList metas = DataDomImpl.getAllParsersElements((Element)data);
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tagname = DataDomImpl.getTagName((Element)meta);
            Control obj = this.texthash.get(tagname);
            if (obj != null && obj instanceof Text) {
                Text txt = (Text)obj;
                Element schemaelem = TypeDomImpl.getElement((Document)this.schema, (String)tagname);
                String pluginname = TypeDomImpl.getParser((Element)schemaelem);
                try {
                    ITypeParser parser = FrameworkPlugin.getParser((String)pluginname);
                    if (parser != null) {
                        parser.putToElement(meta, txt.getText());
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
        return this.doc;
    }

    private Image loadThumbnailFile(long id) {
        Image newImage;
        block10: {
            newImage = null;
            try {
                Image curImage = FrameworkPlugin.getThumbnailImage((long)id);
                if (curImage != null) {
                    ImageData imagedata = curImage.getImageData();
                    int width = 120;
                    int height = 120;
                    if (imagedata.width > 120 || imagedata.height > 120) {
                        float a;
                        if (imagedata.width > imagedata.height) {
                            a = imagedata.width;
                            float b = 120.0f;
                            float c = imagedata.height;
                            float ans = a / b;
                            height = (int)(c / ans);
                        } else {
                            a = imagedata.height;
                            float b = 120.0f;
                            float c = imagedata.width;
                            float ans = a / b;
                            width = (int)(c / ans);
                        }
                        ImageData newimagedata = imagedata.scaledTo(width, height);
                        imagedata = null;
                        newImage = new Image((Device)this.topcomposite.getDisplay(), newimagedata);
                    } else {
                        newImage = curImage;
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                if (newImage == null) break block10;
                newImage.dispose();
                newImage = null;
            }
        }
        if (newImage == null) {
            ImageDescriptor imgDes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ibooks", (String)"icons/NoImage.jpg");
            Image image = imgDes.createImage();
            Rectangle r = image.getBounds();
            if (r.width > 120 || r.height > 120) {
                ImageData imgdata = image.getImageData().scaledTo(120, 120);
                newImage = new Image((Device)this.topcomposite.getDisplay(), imgdata);
                image.dispose();
                image = null;
            } else {
                newImage = image;
            }
        }
        return newImage;
    }

    public void fillout() {
    }

    public String getType() {
        return "Book";
    }

    public boolean isEnabled() {
        return this.topcomposite.isEnabled();
    }

    public void refresh() {
        ArrayList metas = DataDomImpl.getAllParsersElements((Document)this.doc, (String)"Book");
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tagname = DataDomImpl.getTagName((Element)meta);
            Element schemaelem = TypeDomImpl.getElement((Document)this.schema, (String)tagname);
            String pluginname = TypeDomImpl.getParser((Element)schemaelem);
            ITypeParser parser = FrameworkPlugin.getParser((String)pluginname);
            if (parser != null) {
                String cntnt = parser.getSingleText(meta);
                Control obj = this.texthash.get(tagname);
                if (obj != null && obj instanceof Text) {
                    Text txt = (Text)obj;
                    txt.setText(cntnt);
                    txt.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            if (ConciergeDialogArea.this.elistener != null) {
                                ConciergeDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ConciergeDialogArea.this.doc));
                            }
                        }
                    });
                }
            }
            ++i;
        }
        Control obj = this.texthash.get("thumbnail");
        if (obj != null && obj instanceof Label) {
            Label label = (Label)obj;
            Image oldimage = label.getImage();
            if (oldimage != null) {
                label.setImage(null);
                oldimage.dispose();
                oldimage = null;
            }
            long id = DomImpl.getID((Document)this.doc);
            Image image = this.loadThumbnailFile(id);
            label.setImage(image);
        }
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public void setDocumentChangeListener(IEditorEventListener listener) {
        this.elistener = listener;
    }

    public void setEnabled(boolean enabled) {
        this.topcomposite.setEnabled(enabled);
        Color color = null;
        color = enabled ? this.topcomposite.getDisplay().getSystemColor(2) : this.topcomposite.getDisplay().getSystemColor(15);
        this.allEnabled(this.topcomposite, enabled, color);
    }

    public void dispose() {
    }

    public boolean isDisposed() {
        return this.topcomposite.isDisposed();
    }

    private void allEnabled(Composite parent, boolean enabled, Color color) {
        Control[] controls = parent.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                this.allEnabled((Composite)controls[i], enabled, color);
            } else if (controls[i] instanceof Text) {
                Text txt;
                if (!enabled && (txt = (Text)controls[i]).getText().length() > 0) {
                    txt.setText("");
                }
            } else if (controls[i] instanceof Label) {
                controls[i].setForeground(color);
            }
            controls[i].setEnabled(enabled);
            ++i;
        }
    }
}

