/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.dialog;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.PatternSyntaxException;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.dialog.DataHeaderValue;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedDocument;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedFile;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedObject;
import jp.sourceforge.concierge.plugin.labnote.dialog.LineUtils;
import jp.sourceforge.concierge.util.DomImpl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLConverter {
    StyledText textview;
    private ColorRegistry colorReg = null;
    private boolean isexport = false;

    public HTMLConverter(StyledText textview, boolean isexport) {
        this.textview = textview;
        this.isexport = isexport;
    }

    private String[] getKeyValue(String item) {
        String[] param = item.split(":");
        if (param.length < 2) {
            return null;
        }
        int i = 0;
        while (i < 2) {
            param[i] = param[i].trim();
            ++i;
        }
        return param;
    }

    private Color getColor(String cstr) {
        if (cstr.startsWith("rgb(")) {
            try {
                String value = cstr.replaceAll("[rgb()]", "");
                String[] rgb = value.split(",");
                if (rgb.length == 3) {
                    Color color;
                    Color newColor = new Color((Device)this.textview.getDisplay(), Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                    if (this.colorReg == null) {
                        this.colorReg = new ColorRegistry();
                    }
                    if ((color = this.colorReg.get(newColor.toString())) == null) {
                        this.colorReg.put(newColor.toString(), newColor.getRGB());
                    } else {
                        newColor.dispose();
                        newColor = null;
                        newColor = color;
                    }
                    return newColor;
                }
            }
            catch (PatternSyntaxException e) {
                System.err.println(e.getMessage());
            }
        }
        return null;
    }

    private int getFontStyle(String cstr) {
        String[] st = cstr.split(" ");
        int stval = 0;
        int i = 0;
        while (i < st.length) {
            if (st[i].compareTo("bold") == 0) {
                stval |= 1;
            } else if (st[i].compareTo("italic") == 0) {
                stval |= 2;
            }
            ++i;
        }
        return stval;
    }

    private int getFontSize(String cstr) {
        cstr = cstr.replaceFirst("pt", "");
        return Integer.parseInt(cstr);
    }

    private boolean includeVal(String cstr, String val) {
        String[] st = cstr.split(" ");
        int i = 0;
        while (i < st.length) {
            if (st[i].compareTo(val) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isBold(String cstr) {
        return this.includeVal(cstr, "bold");
    }

    private boolean isUnderline(String cstr) {
        return this.includeVal(cstr, "underline");
    }

    private boolean isStrikeout(String cstr) {
        return this.includeVal(cstr, "line-through");
    }

    private StyleRange getStyleRange(String style) {
        if (style.length() == 0) {
            return null;
        }
        StyleRange sr = new StyleRange();
        String[] item = style.split(";");
        String tfont = null;
        int tstyle = 0;
        int tsize = 10;
        boolean isbold = false;
        int i = 0;
        while (i < item.length) {
            String[] keyval = this.getKeyValue(item[i]);
            if (keyval != null) {
                String key = keyval[0];
                String val = keyval[1];
                if (key.compareTo("color") == 0) {
                    sr.foreground = this.getColor(val);
                } else if (key.compareTo("background") == 0) {
                    sr.background = this.getColor(val);
                } else if (key.compareTo("font-style") == 0) {
                    tstyle = this.getFontStyle(val);
                } else if (key.compareTo("font-weight") == 0) {
                    isbold = this.isBold(val);
                } else if (key.compareTo("font-size") == 0) {
                    tsize = this.getFontSize(val);
                } else if (key.compareTo("font-family") == 0) {
                    tfont = val;
                    if (tfont.length() > 0 && tfont.startsWith("'")) {
                        tfont = tfont.substring(1);
                    }
                    if (tfont.length() > 1 && tfont.endsWith("'")) {
                        tfont = tfont.substring(0, tfont.length() - 1);
                    }
                } else if (key.compareTo("text-decoration") == 0) {
                    sr.underline = this.isUnderline(val);
                    sr.strikeout = this.isStrikeout(val);
                }
            }
            ++i;
        }
        if (isbold) {
            tstyle |= 1;
        }
        if (tfont != null) {
            sr.font = new Font((Device)this.textview.getDisplay(), tfont, tsize, tstyle);
        } else {
            sr.font = null;
            sr.fontStyle = tstyle;
        }
        return sr;
    }

    private String createStyleString(StyleRange sr) {
        Color c;
        FontData fd;
        String attrval = "";
        String stval = "";
        int style = 0;
        if (sr.font != null) {
            fd = sr.font.getFontData()[0];
            style = fd.getStyle();
        } else {
            fd = null;
            style = sr.fontStyle;
        }
        stval = (style & 2) != 0 ? "font-style: italic;" : "font-style: normal;";
        if ((style & 1) != 0) {
            stval = String.valueOf(stval) + "font-weight: bold;";
        }
        String szval = fd != null ? "font-size: " + String.valueOf(fd.getHeight()) + "pt;" : "";
        String ffval = fd != null ? "font-family: '" + fd.getName() + "';" : "";
        String colval = "";
        if (sr.foreground != null) {
            c = sr.foreground;
            colval = "color: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");";
        }
        if (sr.background != null) {
            c = sr.background;
            colval = String.valueOf(colval) + "background: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");";
        }
        String txtval = "text-decoration:";
        if (sr.underline) {
            txtval = String.valueOf(txtval) + " underline";
        }
        if (sr.strikeout) {
            txtval = String.valueOf(txtval) + " line-through";
        }
        txtval = sr.underline || sr.strikeout ? String.valueOf(txtval) + ";" : String.valueOf(txtval) + " none;";
        attrval = String.valueOf(stval) + szval + ffval + colval + txtval;
        return attrval;
    }

    private Element createStyleTag(Document doc, StyleRange sr, String text) {
        Element e = doc.createElement("span");
        e.setAttribute("style", this.createStyleString(sr));
        DomImpl.setElementText((Element)e, (String)text);
        return e;
    }

    private Element createImageTag(Document doc, StyleRange sr) {
        ArrayList images = (ArrayList)this.textview.getData();
        int i = 0;
        while (i < images.size()) {
            EmbeddedObject ei = (EmbeddedObject)images.get(i);
            if (ei.getOffset() == sr.start) {
                ei.save();
                return ei.createElement(doc, this.isexport);
            }
            ++i;
        }
        return null;
    }

    private Element createBRTag(Document doc) {
        return doc.createElement("br");
    }

    private ArrayList<StyleRange> createStyleList() {
        String text = this.textview.getText();
        StyleRange[] srs = this.textview.getStyleRanges(true);
        int start = 0;
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int i = 0;
        while (i < srs.length) {
            if (srs[i].start == start) {
                styles.add((StyleRange)srs[i].clone());
                start = srs[i].start + srs[i].length;
            } else {
                StyleRange sr = new StyleRange();
                sr.start = start;
                sr.length = srs[i].start - start;
                sr.fontStyle = 0;
                styles.add(sr);
                start = srs[i].start;
                --i;
            }
            ++i;
        }
        if (start < text.length()) {
            StyleRange sr = new StyleRange();
            sr.start = start;
            sr.length = text.length() - start;
            sr.fontStyle = 0;
            styles.add(sr);
        }
        return styles;
    }

    /*
     * Unable to fully structure code
     */
    private void exportToFile(Document html, String dirname, String filename) {
        destdir = new File(dirname);
        nl = html.getElementsByTagName("img");
        i = 0;
        while (i < nl.getLength()) {
            block19: {
                block18: {
                    el = (Element)nl.item(i);
                    src = el.getAttribute("src");
                    alt = el.getAttribute("alt");
                    orgf = null;
                    newf = null;
                    if (!src.equals("__document.gif")) break block18;
                    orgf = LabNotePlugin.getDefault().getFilePath("icons/__document.gif");
                    ** GOTO lbl24
                }
                if (!src.equals("__object.gif")) break block19;
                orgf = LabNotePlugin.getDefault().getFilePath("icons/__object.gif");
                ** GOTO lbl24
            }
            orgf = FrameworkPlugin.findUserFile((String)src);
            if (orgf == null) {
                el.setAttribute("src", "");
            } else {
                ext = orgf != null ? FilenameUtils.getExtension((String)orgf) : "";
                el.setAttribute("src", String.valueOf(alt) + (ext.length() > 0 ? "." + ext : ""));
lbl24:
                // 3 sources

                if (!orgf.equals(newf)) {
                    try {
                        of = new File(orgf);
                        if (of.isDirectory()) {
                            FileUtils.copyDirectoryToDirectory((File)of, (File)destdir);
                        } else {
                            FileUtils.copyFileToDirectory((File)of, (File)destdir);
                        }
                    }
                    catch (Exception v0) {}
                }
            }
            ++i;
        }
        nl = html.getElementsByTagName("a");
        i = 0;
        while (i < nl.getLength()) {
            el = (Element)nl.item(i);
            src = el.getAttribute("href");
            alt = el.getAttribute("alt");
            orgf = FrameworkPlugin.findUserFile((String)src);
            if (orgf == null) {
                el.setAttribute("href", "");
            } else {
                ext = FilenameUtils.getExtension((String)orgf);
                el.setAttribute("href", String.valueOf(alt) + (ext.length() > 0 ? "." + ext : ""));
                try {
                    of = new File(orgf);
                    if (of.isDirectory()) {
                        FileUtils.copyDirectoryToDirectory((File)of, (File)destdir);
                    } else {
                        FileUtils.copyFileToDirectory((File)of, (File)destdir);
                    }
                }
                catch (Exception v1) {}
            }
            ++i;
        }
        dimpl = new DOMImplementationImpl();
        lsout = dimpl.createLSOutput();
        lsser = dimpl.createLSSerializer();
        try {
            if (!destdir.exists()) {
                destdir.mkdir();
            }
            out = new FileOutputStream(String.valueOf(dirname) + File.separator + filename);
            lsout.setEncoding("UTF-8");
            lsout.setByteStream(out);
            lsser.write(html, lsout);
            out.flush();
            out.close();
        }
        catch (Exception v2) {}
    }

    public void exportToFile(String dirname, String filename, ArrayList<DataHeaderValue> bheads) {
        Document html = this.exportToDocument(bheads);
        this.exportToFile(html, dirname, filename);
    }

    private ArrayList<StyleRange> getStyleRanges(ArrayList<StyleRange> styles, int start, int end) {
        int sidx = -1;
        int eidx = -1;
        int i = 0;
        while (i < styles.size()) {
            StyleRange sr = styles.get(i);
            if (sr.start <= start && start < sr.start + sr.length) {
                sidx = i;
            }
            if (sr.start <= end && end < sr.start + sr.length) {
                eidx = i;
            }
            if (eidx >= 0) break;
            ++i;
        }
        ArrayList<StyleRange> al = new ArrayList<StyleRange>();
        if (sidx == -1 || eidx == -1) {
            return al;
        }
        int i2 = sidx;
        while (i2 <= eidx) {
            StyleRange sr = (StyleRange)styles.get(i2).clone();
            if (i2 == sidx) {
                sr.length = sr.start + sr.length - start;
                sr.start = start;
            }
            if (i2 == eidx) {
                sr.length = end - sr.start + 1;
            }
            al.add(sr);
            ++i2;
        }
        return al;
    }

    private void setTag(Document html, Element parent, ArrayList<StyleRange> styles, boolean rmhyphn) {
        int i = 0;
        while (i < styles.size()) {
            StyleRange sr = styles.get(i);
            String txt = this.textview.getTextRange(sr.start, sr.length);
            if (rmhyphn && txt.startsWith("\u30fb ")) {
                txt = txt.substring("\u30fb ".length());
            }
            if (txt.length() > 1 && (txt.endsWith("\r") || txt.endsWith("\n"))) {
                txt = txt.substring(0, txt.length() - 1);
            }
            Element e = null;
            if (txt.equals("\ufffc")) {
                e = this.createImageTag(html, sr);
            } else if (!txt.equals("\n") && !txt.equals("\r")) {
                e = this.createStyleTag(html, sr, txt);
            }
            if (e != null) {
                parent.appendChild(e);
            }
            ++i;
        }
    }

    public Document exportToDocument(ArrayList<DataHeaderValue> bheads) {
        int i;
        ArrayList<StyleRange> styles = this.createStyleList();
        Document html = DomImpl.createDocument((String)"html", (boolean)true);
        html.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        Element head = DomImpl.appendElement((Element)html.getDocumentElement(), (String)"head");
        Element meta = DomImpl.appendElement((Element)head, (String)"meta");
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", "text/html;charset=utf-8");
        Element body = DomImpl.appendElement((Element)html.getDocumentElement(), (String)"body");
        StyleRange styleRange = new StyleRange();
        styleRange.foreground = this.textview.getForeground();
        styleRange.background = this.textview.getBackground();
        styleRange.font = this.textview.getFont();
        body.setAttribute("style", this.createStyleString(styleRange));
        if (bheads != null) {
            Element p = DomImpl.appendElement((Element)body, (String)"p");
            Element tbl = DomImpl.appendElement((Element)p, (String)"table");
            DomImpl.setAttribute((Element)tbl, (String)"style", (String)"width: 100%; background-color: #f0ffff; border-collapse: collapse; border: 1px #2070f0 solid;");
            i = 0;
            while (i < bheads.size()) {
                Element tr = DomImpl.appendElement((Element)tbl, (String)"tr");
                DataHeaderValue dhv = bheads.get(i);
                Element ktd = DomImpl.appendElement((Element)tr, (String)"td");
                ktd.setAttribute("width", "80");
                ktd.setAttribute("style", "padding: 5px");
                String key = dhv.name;
                DomImpl.setElementText((Element)ktd, (String)key);
                Element vtd = DomImpl.appendElement((Element)tr, (String)"td");
                ktd.setAttribute("style", "padding: 5px");
                String val = dhv.value;
                DomImpl.setElementText((Element)vtd, (String)val);
                ++i;
            }
        }
        Element parent = body;
        int lc = this.textview.getLineCount();
        i = 0;
        while (i < lc) {
            int ls = this.textview.getOffsetAtLine(i);
            int le = LineUtils.getLastOffsetAtLine(this.textview, i);
            Color lineColor = this.textview.getLineBackground(i);
            if (lineColor != null) {
                StyleRange styleRange2 = new StyleRange();
                styleRange2.background = lineColor;
                Element h1e = html.createElement("h1");
                h1e.setAttribute("style", this.createStyleString(styleRange2));
                parent.appendChild(h1e);
                parent = h1e;
            } else {
                parent = body;
            }
            ArrayList<StyleRange> sts = this.getStyleRanges(styles, ls, le);
            this.setTag(html, parent, sts, false);
            if (i != lc - 1) {
                parent.appendChild(this.createBRTag(html));
            }
            ++i;
        }
        return html;
    }

    private void parseUL(Element elemul, LineInformation li) {
        int indent = LabNotePlugin.getDefault().getPreferenceStore().getInt("indent");
        li.indent += indent;
        this.parseElements(elemul.getChildNodes(), li);
        li.indent -= indent;
    }

    private void parseLI(Element elemli, LineInformation li) {
        int curline = this.textview.getLineCount() - 1;
        StyleRange sr = this.getStyleRange(elemli.getAttribute("style"));
        if (sr != null) {
            li.styles.add(sr);
        }
        this.textview.append("\u30fb ");
        this.parseElements(elemli.getChildNodes(), li);
        this.textview.append(this.textview.getLineDelimiter());
        this.textview.setLineIndent(curline, 1, li.indent);
        if (sr != null) {
            li.styles.remove(sr);
        }
    }

    private void parseBR(Element elembr, LineInformation li) {
        this.textview.append(this.textview.getLineDelimiter());
    }

    private void parseText(Text elemtxt, LineInformation li) {
        String text = elemtxt.getNodeValue();
        if (text.equals("\n") || text.equals("\r")) {
            return;
        }
        if (li.styles.size() > 0) {
            StyleRange sr = li.styles.peek();
            sr.start = this.textview.getCharCount();
            sr.length = text.length();
            this.textview.replaceTextRange(sr.start, 0, text);
            this.textview.setStyleRange(sr);
        } else {
            this.textview.append(text);
        }
    }

    private void setStyleRange(EmbeddedObject e, Point sz) {
        if (this.textview.getCharCount() == e.getOffset()) {
            this.textview.append("\ufffc");
        } else {
            this.textview.replaceTextRange(e.getOffset(), 0, "\ufffc");
        }
        StyleRange style = new StyleRange();
        style.start = e.getOffset();
        style.length = 1;
        style.foreground = this.textview.getBackground();
        if (sz != null) {
            style.metrics = new GlyphMetrics(sz.y, 0, sz.x);
        } else {
            Rectangle rect = e.getObjectImage().getBounds();
            style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        }
        this.textview.setStyleRange(style);
    }

    private void createImage(long docid) {
        int curoffset = this.textview.getCharCount();
        try {
            Document doc = FrameworkPlugin.getDocumentByID((String)"data", (long)docid);
            if (doc == null) {
                return;
            }
            EmbeddedDocument e = new EmbeddedDocument(doc);
            e.setOffset(curoffset);
            this.setStyleRange(e, null);
            ArrayList emimages = (ArrayList)this.textview.getData();
            emimages.add(e);
        }
        catch (Exception exception) {
            return;
        }
    }

    private void createImage(String imgfile, String orgname, Point sz) {
        EmbeddedFile e = null;
        try {
            String imgpath = FrameworkPlugin.findUserFile((String)imgfile);
            long id = Long.parseLong(FilenameUtils.getBaseName((String)imgfile));
            Document doc = FrameworkPlugin.getDocumentByID((String)"data", (long)id);
            if (doc == null) {
                return;
            }
            e = new EmbeddedFile(doc, false);
            e.setOffset(this.textview.getCharCount());
            ((EmbeddedObject)e).setSize(imgpath == null ? null : sz);
            this.setStyleRange(e, sz);
            ArrayList emimages = (ArrayList)this.textview.getData();
            emimages.add(e);
        }
        catch (Exception exception) {
            return;
        }
    }

    private void parseImage(Element elemimg, LineInformation li) {
        String imgfile = elemimg.getAttribute("src");
        String orgname = elemimg.getAttribute("alt");
        String width = elemimg.getAttribute("width");
        String height = elemimg.getAttribute("height");
        if (imgfile.equals("__object.gif")) {
            return;
        }
        if (imgfile.equals("__document.gif")) {
            this.createImage(Long.parseLong(orgname));
        } else {
            Point sz = new Point(Integer.parseInt(width), Integer.parseInt(height));
            this.createImage(imgfile, orgname, sz);
        }
    }

    private void parseA(Element elema, LineInformation li) {
        String imgfile = elema.getAttribute("href");
        String orgname = elema.getAttribute("alt");
        this.createImage(imgfile, orgname, null);
    }

    private void parseSpan(Element elemspan, LineInformation li) {
        StyleRange sr = this.getStyleRange(elemspan.getAttribute("style"));
        if (sr != null) {
            li.styles.add(sr);
        }
        this.parseElements(elemspan.getChildNodes(), li);
        if (sr != null) {
            li.styles.remove(sr);
        }
    }

    private void parseH1(Element elem, LineInformation li) {
        StyleRange sr = this.getStyleRange(elem.getAttribute("style"));
        int pos = this.textview.getLineCount() - 1;
        this.parseElements(elem.getChildNodes(), li);
        if (sr != null && pos >= 0) {
            this.textview.setLineBackground(pos, 1, sr.background);
        }
    }

    private void parseElements(NodeList tags, LineInformation linfo) {
        int i = 0;
        while (i < tags.getLength()) {
            Node tag = tags.item(i);
            short type = tag.getNodeType();
            if (type == 3) {
                this.parseText((Text)tag, linfo);
            } else if (type == 1) {
                if (tag.getNodeName().compareTo("li") == 0) {
                    this.parseLI((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("ul") == 0) {
                    this.parseUL((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("br") == 0) {
                    this.parseBR((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("img") == 0) {
                    this.parseImage((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("a") == 0) {
                    this.parseA((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("span") == 0) {
                    this.parseSpan((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("h1") == 0) {
                    this.parseH1((Element)tag, linfo);
                }
            }
            ++i;
        }
    }

    public void importFromDocument(Document doc) {
        StyleRange bodyStyleRange;
        ArrayList bs = DomImpl.getElements((Document)doc, (String)"body");
        if (bs.size() == 0) {
            return;
        }
        this.textview.setText("");
        ArrayList imgs = (ArrayList)this.textview.getData();
        if (imgs != null) {
            imgs.clear();
        } else {
            imgs = new ArrayList();
            this.textview.setData(imgs);
        }
        Element body = (Element)bs.get(0);
        String bodyStyle = body.getAttribute("style");
        StyleRange styleRange = bodyStyleRange = bodyStyle.length() > 0 ? this.getStyleRange(bodyStyle) : null;
        if (bodyStyleRange != null) {
            if (bodyStyleRange.foreground != null) {
                this.textview.setForeground(bodyStyleRange.foreground);
            }
            if (bodyStyleRange.background != null) {
                this.textview.setBackground(bodyStyleRange.background);
            }
            if (bodyStyleRange.font != null) {
                this.textview.setFont(bodyStyleRange.font);
            }
        }
        this.parseElements(body.getChildNodes(), new LineInformation());
    }

    private class LineInformation {
        int indent = 0;
        Stack<StyleRange> styles = new Stack();

        private LineInformation() {
        }
    }
}

