/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.dialog;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.IConciergeDialog;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.dialog.ConciergeEditorDropListener;
import jp.sourceforge.concierge.plugin.labnote.dialog.DataHeaderValue;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedDocument;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedFile;
import jp.sourceforge.concierge.plugin.labnote.dialog.EmbeddedObject;
import jp.sourceforge.concierge.plugin.labnote.dialog.HTMLConverter;
import jp.sourceforge.concierge.plugin.labnote.dialog.LineUtils;
import jp.sourceforge.concierge.plugin.labnote.dialog.SizeDialog;
import jp.sourceforge.concierge.plugin.labnote.dialog.StyleModifyListener;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DataDomTransfer;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConciergeEditor
extends Composite {
    private static final int DEFAULTIMAGEWIDTH = 240;
    private boolean verifyindent = true;
    private Object docSender = null;
    private Color linkcolor = new Color(null, 0, 0, 255);
    private FontRegistry fregistry = new FontRegistry();
    private ColorRegistry colorReg = new ColorRegistry();
    public static final String IMAGECHAR = "\ufffc";
    public static final String INDENTCHAR = "\u30fb ";
    private ArrayList emclipboard = new ArrayList();
    private StyledText textview;
    private Font defaultFont;
    private Color defaultBackground;
    private Color defaultForeground;
    private IPropertyChangeListener propertyChangeListener = null;
    private StyleModifyListener styleModifyListener = null;

    private Color newColor(Device device, int red, int green, int blue) {
        Color newColor = new Color(device, red, green, blue);
        Color color = this.colorReg.get(newColor.toString());
        if (color == null) {
            this.colorReg.put(newColor.toString(), newColor.getRGB());
        } else {
            newColor.dispose();
            newColor = null;
            newColor = color;
        }
        return newColor;
    }

    private EmbeddedObject getEmbeddedObjectAtLocation(Point l) {
        ArrayList al = (ArrayList)this.textview.getData();
        int i = 0;
        while (i < al.size()) {
            EmbeddedObject o = (EmbeddedObject)al.get(i);
            Point sz = o.getSize();
            if (sz == null) {
                Rectangle r = o.getObjectImage().getBounds();
                sz = new Point(r.width, r.height);
            }
            int bl = this.textview.getBaseline(o.getOffset());
            Point p = this.textview.getLocationAtOffset(o.getOffset());
            if (p.x <= l.x && l.x < p.x + sz.x && p.y + bl - sz.y <= l.y && l.y <= p.y + bl) {
                return o;
            }
            ++i;
        }
        return null;
    }

    private void applyStyle(StyleRange newsr, StyleRange style, int update) {
        if ((update & 2) != 0) {
            newsr.background = style.background;
        }
        if ((update & 1) != 0) {
            newsr.foreground = style.foreground;
        }
        if ((update & 8) != 0) {
            newsr.font = style.font;
        }
        if ((update & 0x10) != 0) {
            newsr.rise = style.rise;
        }
        if ((update & 0x20) != 0) {
            newsr.underline = style.underline;
        }
        if ((update & 0x40) != 0) {
            newsr.strikeout = style.strikeout;
        }
        if ((update & 0x80) != 0) {
            newsr.metrics = style.metrics;
        }
        if ((update & 4) != 0) {
            if (newsr.font == null) {
                switch (style.fontStyle) {
                    case 1: 
                    case 2: {
                        if (newsr.fontStyle == 0) {
                            newsr.fontStyle = style.fontStyle;
                            break;
                        }
                        newsr.fontStyle |= style.fontStyle;
                        break;
                    }
                    case -3: 
                    case -2: {
                        newsr.fontStyle &= style.fontStyle;
                    }
                }
            } else {
                FontData fd = newsr.font.getFontData()[0];
                int fdstyle = fd.getStyle();
                switch (style.fontStyle) {
                    case 1: 
                    case 2: {
                        if (fdstyle == 0) {
                            fdstyle = style.fontStyle;
                            break;
                        }
                        fdstyle |= style.fontStyle;
                        break;
                    }
                    case -3: 
                    case -2: {
                        fdstyle &= style.fontStyle;
                    }
                }
                fd.setStyle(fdstyle);
                if (this.fregistry.hasValueFor(fd.toString())) {
                    newsr.font = this.fregistry.get(fd.toString());
                } else {
                    newsr.font = new Font((Device)this.textview.getDisplay(), fd);
                    this.fregistry.put(fd.toString(), newsr.font.getFontData());
                }
            }
        }
    }

    private StyleRange getStyleRangeAtOffset(StyleRange[] srs, int offset) {
        int i = 0;
        while (i < srs.length) {
            if (srs[i].start <= offset && offset < srs[i].start + srs[i].length) {
                return srs[i];
            }
            ++i;
        }
        return null;
    }

    private void setNewStyleAtRange(Point range, StyleRange style, int update) {
        int start = range.x;
        int length = 0;
        StyleRange[] srs = this.textview.getStyleRanges(range.x, range.y - range.x, true);
        ArrayList<StyleRange> newsrs = new ArrayList<StyleRange>();
        int i = range.x;
        while (i < range.y) {
            StyleRange sr = this.getStyleRangeAtOffset(srs, i);
            if (sr != null) {
                StyleRange nsr;
                if (length > 0) {
                    StyleRange nsr2 = new StyleRange(start, length, null, null, 0);
                    this.applyStyle(nsr2, style, update);
                    newsrs.add(nsr2);
                    start += length;
                }
                String s = this.textview.getText(i, i);
                length = sr.start + sr.length - start;
                if (s.compareTo(IMAGECHAR) == 0) {
                    nsr = (StyleRange)sr.clone();
                    nsr.start = start;
                    nsr.length = length;
                    this.applyStyle(nsr, style, update);
                    nsr.foreground = nsr.background != null ? nsr.background : this.textview.getBackground();
                    newsrs.add(nsr);
                } else {
                    nsr = (StyleRange)sr.clone();
                    nsr.start = start;
                    nsr.length = length;
                    this.applyStyle(nsr, style, update);
                    newsrs.add(nsr);
                }
                start = i + length;
                i = start - 1;
                length = 0;
            } else {
                ++length;
            }
            ++i;
        }
        if (length > 0) {
            StyleRange nsr = new StyleRange(start, length, null, null, 0);
            this.applyStyle(nsr, style, update);
            newsrs.add(nsr);
        }
        StyleRange[] srsarr = new StyleRange[newsrs.size()];
        int i2 = 0;
        while (i2 < srsarr.length) {
            srsarr[i2] = (StyleRange)newsrs.get(i2);
            ++i2;
        }
        if (srsarr.length > 0) {
            this.textview.replaceStyleRanges(range.x, range.y - range.x, new StyleRange[]{new StyleRange()});
            this.textview.replaceStyleRanges(range.x, range.y - range.x, srsarr);
        }
    }

    private void hookContextMenu() {
        this.textview.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                switch (event.button) {
                    case 1: {
                        if ((event.stateMask & 0x40000) != 0) break;
                        return;
                    }
                }
                Menu menu = new Menu((Decorations)ConciergeEditor.this.textview.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText(LabNotePlugin.getString("ConciergeEditor.2"));
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        ConciergeEditor.this.textview.cut();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText(LabNotePlugin.getString("ConciergeEditor.3"));
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        ConciergeEditor.this.textview.copy();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText(LabNotePlugin.getString("ConciergeEditor.4"));
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        ConciergeEditor.this.textview.paste();
                    }
                });
                final EmbeddedObject o = ConciergeEditor.this.getEmbeddedObjectAtLocation(new Point(event.x, event.y));
                if (o != null && o.editable()) {
                    item = new MenuItem(menu, 2);
                    item = new MenuItem(menu, 8);
                    item.setText(LabNotePlugin.getString("ConciergeEditor.5"));
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            String typename = DataDomImpl.getType((Document)o.getDocument());
                            Request req = new Request(4, (Object)("/type[@name='" + typename + "']"), "type");
                            ArrayList list = FrameworkPlugin.getDocumentsOfQuery((Request)req);
                            if (list == null || list.size() == 0) {
                                return;
                            }
                            Document tdoc = (Document)list.get(0);
                            String pluginid = TypeDomImpl.getPluginID((Document)tdoc);
                            if (pluginid != null && pluginid.length() > 0) {
                                IConciergeDialog plugin = FrameworkPlugin.getDialogPlugin((String)pluginid);
                                if (plugin == null) {
                                    return;
                                }
                                ConciergeDialog dlg = plugin.getDialog(ConciergeEditor.this.textview.getShell(), 0);
                                dlg.setDocument(o.getDocument(), ConciergeEditor.this.docSender);
                                dlg.open();
                                o.refresh();
                                Point p = o.getSize();
                                StyleRange sr = ConciergeEditor.this.textview.getStyleRangeAtOffset(o.getOffset());
                                sr.start = o.getOffset();
                                sr.length = 1;
                                sr.metrics = new GlyphMetrics(p.y, 0, p.x);
                                ConciergeEditor.this.textview.setStyleRange(sr);
                                ConciergeEditor.this.textview.redraw();
                                ConciergeEditor.this.textview.update();
                            }
                        }
                    });
                }
                if (o != null && o.resizable()) {
                    item = new MenuItem(menu, 8);
                    item.setText(LabNotePlugin.getString("ConciergeEditor.10"));
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            Point sz = o.getSize();
                            if (sz == null) {
                                Rectangle rect = o.getObjectImage().getBounds();
                                sz = new Point(rect.width, rect.height);
                            }
                            SizeDialog szdlg = new SizeDialog(ConciergeEditor.this.textview.getShell(), 0, ConciergeEditor.this.textview, o);
                            szdlg.open();
                        }
                    });
                }
                Point tp = ConciergeEditor.this.textview.getLocation();
                Point dp = ConciergeEditor.this.textview.toDisplay(tp.x, tp.y);
                menu.setLocation(event.x + dp.x, event.y + dp.y);
                menu.setVisible(true);
                Display display = ConciergeEditor.this.textview.getDisplay();
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                menu.dispose();
            }

            public void mouseDoubleClick(MouseEvent e) {
                StyledText st = (StyledText)e.getSource();
                int x = st.getCaretOffset();
                int sl = st.getLineAtOffset(x);
                Color lineColor = st.getLineBackground(sl);
                String fontname = "";
                int fontsize = 0;
                int fontstyle = 0;
                boolean underline = false;
                Color foreColor = null;
                Color backColor = null;
                if (lineColor == null) {
                    int styleNumber = 0;
                    int red = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred" + styleNumber);
                    int green = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen" + styleNumber);
                    int blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue" + styleNumber);
                    foreColor = ConciergeEditor.this.newColor((Device)st.getDisplay(), red, green, blue);
                    red = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred" + styleNumber);
                    green = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen" + styleNumber);
                    blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue" + styleNumber);
                    lineColor = backColor = ConciergeEditor.this.newColor((Device)st.getDisplay(), red, green, blue);
                    fontname = LabNotePlugin.getDefault().getPreferenceStore().getString("fontname" + styleNumber);
                    fontsize = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize" + styleNumber);
                    fontstyle = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle" + styleNumber);
                    underline = LabNotePlugin.getDefault().getPreferenceStore().getBoolean("underline" + styleNumber);
                } else {
                    lineColor = null;
                }
                ConciergeEditor.this.setHeadStyle(sl, fontname, fontsize, fontstyle, underline, foreColor, backColor);
                st.setLineBackground(sl, 1, lineColor);
                if (ConciergeEditor.this.styleModifyListener != null) {
                    ConciergeEditor.this.styleModifyListener.modifyStyle();
                }
            }
        });
        this.textview.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                EmbeddedObject o = ConciergeEditor.this.getEmbeddedObjectAtLocation(new Point(e.x, e.y));
                if (o != null) {
                    ConciergeEditor.this.textview.setCursor(new Cursor(null, 0));
                    Document doc = o.getDocument();
                    String str = "ID:" + String.valueOf(DomImpl.getID((Document)doc));
                    String txt = DomImpl.getAllText((Document)doc);
                    if (txt.length() != 0) {
                        str = String.valueOf(str) + "\n" + txt;
                    }
                    ConciergeEditor.this.textview.setToolTipText(str);
                } else {
                    ConciergeEditor.this.textview.setCursor(new Cursor(null, 19));
                    ConciergeEditor.this.textview.setToolTipText("");
                }
            }
        });
    }

    private void updateStyle() {
        String fontname = LabNotePlugin.getDefault().getPreferenceStore().getString("fontname");
        int fontsize = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize");
        int fontstyle = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle");
        Font font = fontname.length() == 0 ? null : new Font((Device)this.textview.getDisplay(), fontname, fontsize, fontstyle);
        FontData fd = font.getFontData()[0];
        if (this.fregistry.hasValueFor(fd.toString())) {
            font.dispose();
            font = this.fregistry.get(fd.toString());
        } else {
            this.fregistry.put(fd.toString(), font.getFontData());
        }
        this.textview.setFont(font);
        int red = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred");
        int green = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen");
        int blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue");
        Color color = this.newColor((Device)this.textview.getDisplay(), red, green, blue);
        this.textview.setForeground(color);
        this.defaultForeground = color;
        red = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred");
        green = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen");
        blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue");
        color = this.newColor((Device)this.textview.getDisplay(), red, green, blue);
        this.textview.setBackground(color);
        this.defaultBackground = color;
        int headNumber = 0;
        Color foreColor = null;
        int red2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred" + headNumber);
        int green2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen" + headNumber);
        int blue2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue" + headNumber);
        foreColor = this.newColor((Device)this.textview.getDisplay(), red2, green2, blue2);
        Color backColor = null;
        Color lineColor = null;
        int red3 = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred" + headNumber);
        int green3 = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen" + headNumber);
        int blue3 = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue" + headNumber);
        lineColor = backColor = this.newColor((Device)this.textview.getDisplay(), red3, green3, blue3);
        String fontname2 = LabNotePlugin.getDefault().getPreferenceStore().getString("fontname" + headNumber);
        int fontsize2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize" + headNumber);
        int fontstyle2 = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle" + headNumber);
        boolean underline = LabNotePlugin.getDefault().getPreferenceStore().getBoolean("underline" + headNumber);
        int count = this.textview.getLineCount();
        int i = 0;
        while (i < count) {
            Color color2 = this.textview.getLineBackground(i);
            if (color2 != null) {
                this.setHeadStyle(i, fontname2, fontsize2, fontstyle2, underline, foreColor, backColor);
                this.textview.setLineBackground(i, 1, lineColor);
            }
            ++i;
        }
        this.textview.redraw();
        this.textview.update();
    }

    private void LoadPrefNormalStyle() {
        String fontname = LabNotePlugin.getDefault().getPreferenceStore().getString("fontname");
        int fontsize = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontsize");
        int fontstyle = LabNotePlugin.getDefault().getPreferenceStore().getInt("fontstyle");
        Font font = fontname.length() == 0 ? null : new Font((Device)this.textview.getDisplay(), fontname, fontsize, fontstyle);
        FontData fd = font.getFontData()[0];
        if (this.fregistry.hasValueFor(fd.toString())) {
            font.dispose();
            font = this.fregistry.get(fd.toString());
        } else {
            this.fregistry.put(fd.toString(), font.getFontData());
        }
        this.textview.setFont(font);
        this.defaultFont = this.textview.getFont();
        int red = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorred");
        int green = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorgreen");
        int blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("forecolorblue");
        Color color = this.newColor((Device)this.textview.getDisplay(), red, green, blue);
        this.textview.setForeground(color);
        this.defaultForeground = this.textview.getForeground();
        red = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorred");
        green = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorgreen");
        blue = LabNotePlugin.getDefault().getPreferenceStore().getInt("backcolorblue");
        color = this.newColor((Device)this.textview.getDisplay(), red, green, blue);
        this.textview.setBackground(color);
        this.defaultBackground = this.textview.getBackground();
    }

    private void setPropertyChangeListener() {
        this.removePropertyChangeListener();
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String key = event.getProperty();
                if (key.equals("updatepreferencestore")) {
                    ConciergeEditor.this.updateStyle();
                    if (ConciergeEditor.this.styleModifyListener != null) {
                        ConciergeEditor.this.styleModifyListener.modifyStyle();
                    }
                }
            }
        };
        LabNotePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void removePropertyChangeListener() {
        if (this.propertyChangeListener != null) {
            LabNotePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    public void setStyleModifyListener(StyleModifyListener listener) {
        this.styleModifyListener = listener;
    }

    private void setHeadStyle(int sl, String fontname, int fontsize, int style, boolean ul, Color foreColor, Color backColor) {
        StyleRange newstyle = new StyleRange();
        newstyle.font = fontname.length() == 0 ? null : new Font((Device)this.textview.getDisplay(), fontname, fontsize, style);
        newstyle.underline = ul;
        newstyle.foreground = foreColor;
        newstyle.background = backColor;
        if (newstyle.font != null) {
            FontData fd = newstyle.font.getFontData()[0];
            if (this.fregistry.hasValueFor(fd.toString())) {
                newstyle.font.dispose();
                newstyle.font = this.fregistry.get(fd.toString());
            } else {
                this.fregistry.put(fd.toString(), newstyle.font.getFontData());
            }
        }
        Point pt = new Point(0, 0);
        pt.x = this.textview.getOffsetAtLine(sl);
        pt.y = LineUtils.getLastOffsetAtLine(this.textview, sl) + 1;
        this.setNewStyleAtRange(pt, newstyle, 43);
    }

    public ConciergeEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.horizontalSpacing = 1;
        gl.verticalSpacing = 1;
        this.setLayout((Layout)gl);
        Composite bodyComp = new Composite((Composite)this, 0);
        bodyComp.setLayoutData((Object)new GridData(1808));
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        bodyComp.setLayout((Layout)gl);
        this.textview = new StyledText(bodyComp, 2816);
        this.textview.setLayoutData((Object)new GridData(1808));
        this.textview.setData(new ArrayList());
        this.textview.setWordWrap(true);
        this.setPropertyChangeListener();
        this.LoadPrefNormalStyle();
        this.textview.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i;
                int start = e.start;
                int replaceCharCount = e.end - e.start;
                int newCharCount = e.text.length();
                if (ConciergeEditor.this.verifyindent) {
                    int sl = ConciergeEditor.this.textview.getLineAtOffset(e.start);
                    int el = ConciergeEditor.this.textview.getLineAtOffset(e.end);
                    i = sl;
                    while (i <= el) {
                        int indent = ConciergeEditor.this.textview.getLineIndent(i);
                        int top = ConciergeEditor.this.textview.getOffsetAtLine(i);
                        int icharlast = top + ConciergeEditor.INDENTCHAR.length() - 1;
                        if (LineUtils.isLineInRange(ConciergeEditor.this.textview, e.start, e.end, i) && e.start <= top && top <= e.end && e.start <= icharlast && icharlast <= e.end) {
                            ConciergeEditor.this.textview.setLineIndent(i, 1, 0);
                        } else if (indent > 0 && (e.start <= top && top <= e.end || e.start <= icharlast && icharlast <= e.end)) {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                } else {
                    ConciergeEditor.this.verifyindent = true;
                }
                ArrayList emimages = (ArrayList)ConciergeEditor.this.textview.getData();
                int cnt = emimages.size();
                i = 0;
                while (i < cnt) {
                    EmbeddedObject ei = (EmbeddedObject)emimages.get(i);
                    int offset = ei.getOffset();
                    if (start <= offset && offset < start + replaceCharCount) {
                        emimages.remove(ei);
                        ei.setOffset(offset - start);
                        --cnt;
                        --i;
                    } else if (offset >= start) {
                        ei.setOffset(offset += newCharCount - replaceCharCount);
                    }
                    ++i;
                }
            }
        });
        this.textview.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent e) {
                if (e.length == 0) {
                    return;
                }
            }
        });
        this.textview.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                GC gc = event.gc;
                StyleRange style = event.style;
                int start = style.start;
                ArrayList emimages = (ArrayList)ConciergeEditor.this.textview.getData();
                int i = 0;
                while (i < emimages.size()) {
                    EmbeddedObject ei = (EmbeddedObject)emimages.get(i);
                    int offset = ei.getOffset();
                    if (start == offset) {
                        int x = event.x;
                        int y = event.y + event.ascent - style.metrics.ascent;
                        Image img = ei.getObjectImage();
                        Point sz = ei.getSize();
                        if (sz != null) {
                            img = new Image((Device)ConciergeEditor.this.textview.getDisplay(), img.getImageData().scaledTo(sz.x, sz.y));
                            gc.drawImage(img, x, y);
                            img.dispose();
                            break;
                        }
                        gc.drawImage(img, x, y);
                        break;
                    }
                    ++i;
                }
            }
        });
        DropTarget target = new DropTarget((Control)this.textview, 17);
        DataDomTransfer transfer = DataDomTransfer.getInstance();
        Transfer[] types = new Transfer[]{transfer, FileTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new ConciergeEditorDropListener(this));
        this.hookContextMenu();
    }

    private EmbeddedObject createEmbededObject(String file, int offset) {
        Document doc = LabNotePlugin.createMiscFileDocument(file);
        IConciergeDialog plugin = FrameworkPlugin.getDialogPlugin((String)"jp.sourceforge.concierge.plugin.miscfile");
        if (plugin != null) {
            ConciergeDialog dlg = plugin.getDialog(LabNotePlugin.getDefault().getWorkbench().getDisplay().getActiveShell(), 0);
            dlg.setDocument(doc, this.docSender);
            if (dlg.open() != 0) {
                return null;
            }
        }
        EmbeddedFile e = new EmbeddedFile(doc, false);
        e.setOffset(offset);
        ((EmbeddedObject)e).refresh();
        return e;
    }

    private EmbeddedObject createEmbeddedObject(Document doc, int offset) {
        EmbeddedObject e = DataDomImpl.getType((Document)doc).equals("Misc") ? new EmbeddedFile(doc, false) : new EmbeddedDocument(doc);
        e.setOffset(offset);
        return e;
    }

    private void addEmbeddedObject(EmbeddedObject em, boolean marker) {
        Image img = em.getObjectImage();
        if (marker) {
            this.textview.replaceTextRange(em.getOffset(), 0, IMAGECHAR);
        }
        StyleRange style = new StyleRange();
        style.start = em.getOffset();
        style.length = 1;
        style.foreground = this.textview.getBackground();
        Rectangle rect = img.getBounds();
        if (rect.width > 240) {
            double ratio = 240.0 / (double)rect.width;
            rect.width = (int)((double)rect.width * ratio);
            rect.height = (int)((double)rect.height * ratio);
            em.setSize(new Point(rect.width, rect.height));
        }
        style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        this.textview.setStyleRange(style);
        ArrayList emimages = (ArrayList)this.textview.getData();
        emimages.add(em);
    }

    public void addEmbeddedObject(String file, int offset, boolean marker) {
        this.addEmbeddedObject(this.createEmbededObject(file, offset), marker);
    }

    public void addEmbeddedObject(String file) {
        this.addEmbeddedObject(file, this.textview.getCaretOffset(), true);
    }

    public void addEmbeddedObject(Document doc) {
        this.addEmbeddedObject(this.createEmbeddedObject(doc, this.textview.getCaretOffset()), true);
    }

    public void setDocument(Document doc) {
        this.reset();
        HTMLConverter htconv = new HTMLConverter(this.textview, false);
        htconv.importFromDocument(doc);
        this.updateStyle();
    }

    public Document getDocument() {
        HTMLConverter htconv = new HTMLConverter(this.textview, false);
        return htconv.exportToDocument(null);
    }

    public StyledText getTextWidget() {
        return this.textview;
    }

    public void reset() {
        int cnt = this.textview.getCharCount();
        this.textview.replaceStyleRanges(0, cnt, new StyleRange[]{new StyleRange()});
        this.textview.replaceTextRange(0, cnt, "");
        this.textview.setFont(this.defaultFont);
        this.textview.setForeground(this.defaultForeground);
        this.textview.setBackground(this.defaultBackground);
        this.emclipboard.clear();
    }

    public ArrayList getEmbeddedObject() {
        return (ArrayList)this.textview.getData();
    }

    public void exportToHtml(String path, ArrayList<DataHeaderValue> bheads) {
        if (path == null) {
            return;
        }
        String ext = FilenameUtils.getExtension((String)path);
        String filename = "metadata.html";
        if (ext.equals("htm") || ext.equals("html")) {
            filename = FilenameUtils.getName((String)path);
            path = FilenameUtils.getFullPath((String)path);
        }
        HTMLConverter hexp = new HTMLConverter(this.textview, true);
        hexp.exportToFile(path, filename, bheads);
    }

    public void exportToHtml(ArrayList<DataHeaderValue> bheads, String subdir) {
        DirectoryDialog dd = new DirectoryDialog(this.textview.getShell(), 8192);
        dd.setMessage(LabNotePlugin.getString("ConciergeEditor.22"));
        String path = dd.open();
        if (path == null) {
            return;
        }
        path = String.valueOf(path) + File.separator + subdir;
        this.exportToHtml(path, bheads);
    }

    public void removeEmbeddedObjectByDocument(Document doc) {
        ArrayList ems = (ArrayList)this.textview.getData();
        int i = 0;
        while (i < ems.size()) {
            EmbeddedObject eo = (EmbeddedObject)ems.get(i);
            if (eo.getDocument().equals(doc)) {
                this.textview.replaceTextRange(eo.getOffset(), 1, "");
                ems.remove(i);
                break;
            }
            ++i;
        }
    }

    protected void finalize() throws Throwable {
        this.linkcolor.dispose();
        super.finalize();
    }

    public void DoPrint(String category, String title) {
        PrintDialog printDialog = new PrintDialog(this.textview.getShell());
        PrinterData pd = printDialog.open();
        if (pd != null) {
            Printer printer = new Printer(pd);
            Color lineColor = this.newColor((Device)this.textview.getDisplay(), 255, 255, 255);
            ArrayList<Integer> al = new ArrayList<Integer>();
            int i = 0;
            while (i < this.textview.getLineCount()) {
                if (this.textview.getLineBackground(i) == null) {
                    this.textview.setLineBackground(i, 1, lineColor);
                    al.add(new Integer(i));
                }
                ++i;
            }
            try {
                StyledTextPrintOptions options = new StyledTextPrintOptions();
                if (category == null) {
                    category = "None";
                }
                if (title == null) {
                    title = "untitled";
                }
                options.header = String.valueOf(category) + " " + title;
                options.printTextForeground = true;
                options.printTextBackground = true;
                options.printTextFontStyle = true;
                options.printLineBackground = true;
                Runnable runnable = this.textview.print(printer, options);
                runnable.run();
            }
            catch (Exception excp) {
                System.err.println(excp.getMessage());
            }
            printer.dispose();
            printer = null;
            i = 0;
            while (i < al.size()) {
                Integer integer = (Integer)al.get(i);
                this.textview.setLineBackground(integer.intValue(), 1, null);
                ++i;
            }
        }
        this.textview.setFocus();
    }

    public void setSender(Object sender) {
        this.docSender = sender;
    }
}

