/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.plugin.labnote.CategoryViewer;
import jp.sourceforge.concierge.plugin.labnote.dialog.LabnoteDialog;
import jp.sourceforge.concierge.plugin.labnote.dialog.LabnoteDialogListener;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolTip;
import org.w3c.dom.Document;

public class CalItem {
    private static final boolean showHoliday = false;
    private Composite droot;
    private Label tlabel;
    private Label dlabel;
    private Font labelfont;
    private LabnoteDialog dialog;
    private CategoryViewer catviewer;
    private Item itemselect = null;
    private ToolTip tooltip;
    private int year;
    private int month;
    private int day;
    private boolean holiday = false;
    private boolean enabled = false;
    private String nameofday = null;
    private ArrayList<MouseListener> listeners = new ArrayList();
    private ArrayList<Item> items = new ArrayList();
    private Color SELECTCOLOR = new Color(null, 236, 243, 250);

    private Item findItem(Document doc) {
        int i = 0;
        while (i < this.items.size()) {
            Item it = this.items.get(i);
            if (it.document.equals(doc)) {
                return it;
            }
            ++i;
        }
        return null;
    }

    private void rearrange() {
        ArrayList<Composite> ctrls = new ArrayList<Composite>();
        int i = 0;
        while (i < this.items.size()) {
            Item it = this.items.get(i);
            if (it.root.getVisible()) {
                ctrls.add(it.root);
            }
            ++i;
        }
        Control pc = null;
        int i2 = 0;
        while (i2 < ctrls.size()) {
            Control c = (Control)ctrls.get(i2);
            if (pc == null) {
                c.moveAbove(null);
            } else {
                c.moveBelow(pc);
            }
            pc = c;
            ++i2;
        }
        this.droot.layout();
    }

    public CalItem(Composite parent, int year, int month, int day, CategoryViewer cv, LabnoteDialog dlg) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 1;
        gl.marginWidth = 1;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        parent.setLayout((Layout)gl);
        int sz = SystemUtil.GetOSType() == 1 ? 11 : 9;
        this.labelfont = new Font(null, "Arial", sz, 0);
        this.tlabel = new Label(parent, 16384);
        this.tlabel.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)this.tlabel, (int)1);
        this.tlabel.setFont(this.labelfont);
        this.tlabel.setText(" ");
        this.tlabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalItem.this.itemselect = null;
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalItem.this.itemselect = null;
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        GraphicUtil.setForeground((Control)this.tlabel, (int)(this.holiday ? 3 : 2));
        this.dlabel = new Label(parent, 131072);
        this.dlabel.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)this.dlabel, (int)1);
        this.dlabel.setFont(this.labelfont);
        this.dlabel.setText(String.valueOf(day));
        this.dlabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CalItem.this.labelfont.dispose();
            }
        });
        this.dlabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalItem.this.itemselect = null;
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalItem.this.itemselect = null;
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.droot = new Composite(parent, 0);
        RowLayout rl = new RowLayout();
        this.droot.setLayout((Layout)rl);
        GridData drgd = new GridData(1808);
        drgd.horizontalSpan = 2;
        this.droot.setLayoutData((Object)drgd);
        this.droot.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalItem.this.itemselect = null;
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalItem.this.itemselect = null;
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.droot.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CalItem.this.droot.layout();
            }
        });
        this.dialog = dlg;
        this.catviewer = cv;
        this.year = year;
        this.month = month;
        this.day = day;
        this.enabled = true;
        this.tooltip = new ToolTip(this.droot.getShell(), 4096);
    }

    protected void finalize() throws Throwable {
        this.SELECTCOLOR.dispose();
        super.finalize();
    }

    public void setEnabled(boolean en) {
        this.droot.setEnabled(true);
        int i = 0;
        while (i < this.items.size()) {
            this.items.get(i).setEnabled(true);
            ++i;
        }
        GraphicUtil.setForeground((Control)this.dlabel, (int)(en ? (this.holiday ? 3 : 2) : 15));
        GraphicUtil.setForeground((Control)this.tlabel, (int)(en ? (this.holiday ? 3 : 2) : 15));
        this.enabled = en;
    }

    public void setDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.dlabel.setText(String.valueOf(day));
        this.droot.layout();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public void setBackground(Color color) {
        this.dlabel.setBackground(color);
        this.tlabel.setBackground(color);
        this.droot.setBackground(color);
        this.droot.getParent().setBackground(color);
        int i = 0;
        while (i < this.items.size()) {
            this.items.get(i).setBackground(color);
            ++i;
        }
    }

    public void select() {
        this.setBackground(this.SELECTCOLOR);
    }

    public void deselect() {
        this.setBackground(this.droot.getDisplay().getSystemColor(1));
    }

    public void createItem(Category curcat) {
        Item it = new Item(this.droot, null, curcat);
        if (it.openDialog() == 1) {
            it.dispose();
        } else {
            this.droot.layout();
            this.items.add(it);
        }
    }

    public void setDocuments(ArrayList docs) {
        this.clearAll();
        if (docs == null) {
            return;
        }
        int i = 0;
        while (i < docs.size()) {
            Item it = new Item(this.droot, (Document)docs.get(i), null);
            this.items.add(it);
            ++i;
        }
        this.droot.layout();
    }

    public void showTooltip(boolean show) {
        this.tooltip.setVisible(show);
    }

    public void clearAll() {
        int i = 0;
        while (i < this.items.size()) {
            Item it = this.items.get(i);
            it.dispose();
            ++i;
        }
        this.items.clear();
    }

    public void update() {
        int i = 0;
        while (i < this.items.size()) {
            Item it = this.items.get(i);
            it.update();
            ++i;
        }
    }

    public void updateAll() {
        ArrayList<Document> docs = LabNotePlugin.getDefault().getDocuments(this.year, this.month, this.day);
        this.setDocuments(docs);
    }

    public void addMouseListener(MouseListener listener) {
        this.listeners.add(listener);
    }

    public void categoryVisible(String category, boolean visible) {
        int i = 0;
        while (i < this.items.size()) {
            Item it = this.items.get(i);
            String cat = LabNotePlugin.getCategory(it.document);
            if (cat.compareTo(category) == 0) {
                it.root.setVisible(visible);
            }
            ++i;
        }
        this.rearrange();
    }

    public void openItem(Document doc) {
        Item it = this.findItem(doc);
        if (it == null) {
            return;
        }
        it.openDialog();
    }

    public void deleteItem(Document doc) {
        Item it = this.findItem(doc);
        if (it == null) {
            return;
        }
        this.items.remove(it);
        it.dispose();
        this.droot.layout();
    }

    public Document getSelectedDocument() {
        if (this.itemselect == null) {
            return null;
        }
        return this.itemselect.document;
    }

    public Control getSelectedControl() {
        if (this.itemselect == null) {
            return null;
        }
        return this.itemselect.titlectrl;
    }

    public void setHoliday(boolean hol) {
        this.holiday = hol;
        if (this.enabled) {
            GraphicUtil.setForeground((Control)this.dlabel, (int)(hol ? 3 : 2));
            GraphicUtil.setForeground((Control)this.tlabel, (int)(hol ? 3 : 2));
        }
    }

    public void setNameOfDay(String name) {
        this.nameofday = name;
        this.tlabel.pack();
        this.droot.layout();
    }

    public class Item {
        private Composite root;
        private CLabel titlectrl;
        private Document document;
        static final String defaultTitle = "untitled";
        private LabnoteDialogListener listener;

        public Item(Composite parent, Document doc, Category curcat) {
            this.root = new Composite(parent, 4);
            this.root.setLayoutData((Object)new RowData(-1, -1));
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            this.root.setLayout((Layout)gl);
            this.root.setBackground(parent.getBackground());
            String text = "";
            if (doc != null) {
                this.document = doc;
                text = LabNotePlugin.getTitle(doc);
            } else {
                this.document = LabNotePlugin.createDocument();
                text = defaultTitle;
                LabNotePlugin.setTitle(this.document, text);
                if (curcat != null) {
                    LabNotePlugin.setCategory(this.document, curcat.name);
                }
                LabNotePlugin.setDate(this.document, String.valueOf(String.valueOf(CalItem.this.year)) + "-" + String.valueOf(CalItem.this.month) + "-" + String.valueOf(CalItem.this.day));
            }
            this.titlectrl = new CLabel(this.root, 0);
            this.titlectrl.setLayoutData((Object)new GridData(768));
            this.titlectrl.setFont(CalItem.this.labelfont);
            this.titlectrl.setBackground(this.root.getBackground());
            this.titlectrl.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (e.button != 1) {
                        return;
                    }
                    CalItem.this.itemselect = Item.this;
                    Item.this.openDialog();
                    CalItem.this.droot.setFocus();
                }

                public void mouseDown(MouseEvent e) {
                    CalItem.this.itemselect = Item.this;
                    int i = 0;
                    while (i < CalItem.this.listeners.size()) {
                        MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                        e.data = CalItem.this;
                        ml.mouseDown(e);
                        ++i;
                    }
                }
            });
            this.titlectrl.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                    Point p = Item.this.root.getSize();
                    CalItem.this.tooltip.setLocation(Item.this.root.toDisplay(p.x / 2, p.y / 2));
                }

                public void mouseEnter(MouseEvent e) {
                    Document doc = Item.this.document;
                    if (doc == null) {
                        CalItem.this.tooltip.setVisible(false);
                        return;
                    }
                    String str = "";
                    String txt = LabNotePlugin.getTitle(doc);
                    String val = LabNotePlugin.getCommentAsString(doc);
                    if (val != null && val.length() != 0) {
                        int len = val.length() > 40 ? 40 : val.length();
                        String ppp = len < 40 ? "" : "...";
                        str = String.valueOf(val.substring(0, len)) + ppp;
                    }
                    if (txt.length() > 0) {
                        CalItem.this.tooltip.setText(txt);
                    } else {
                        CalItem.this.tooltip.setText(Item.defaultTitle);
                    }
                    CalItem.this.tooltip.setMessage(str);
                    Point p = Item.this.root.getSize();
                    CalItem.this.tooltip.setLocation(Item.this.root.toDisplay(p.x / 2, p.y / 2));
                    CalItem.this.tooltip.setVisible(true);
                }

                public void mouseExit(MouseEvent e) {
                    CalItem.this.tooltip.setVisible(false);
                }
            });
            this.listener = new LabnoteDialogListener(){

                public void saveClicked(Document doc) {
                    if (doc != Item.this.document) {
                        return;
                    }
                    Item.this.save();
                }

                public void closeClicked(Document doc) {
                    if (doc != Item.this.document) {
                        return;
                    }
                    Item.this.save();
                }
            };
            this.update();
        }

        public void setEnabled(boolean en) {
            this.titlectrl.setEnabled(en);
            if (this.document != null && en) {
                this.update();
            } else {
                GraphicUtil.setForeground((Control)this.titlectrl, (int)15);
                this.titlectrl.setImage(CategoryViewer.getImage(CategoryViewer.UNKNOWN.colorid));
            }
        }

        public void setBackground(Color color) {
            this.root.setBackground(color);
            this.titlectrl.setBackground(color);
        }

        public void setTitle(String title) {
            LabNotePlugin.setTitle(this.document, title);
        }

        public String getTitle() {
            return LabNotePlugin.getTitle(this.document);
        }

        public int openDialog() {
            this.root.layout();
            CalItem.this.dialog.setDocument(this.document);
            CalItem.this.dialog.setLabnoteDialogListener(this.listener);
            return CalItem.this.dialog.open();
        }

        public void update() {
            String cs = LabNotePlugin.getCategory(this.document);
            Category cat = CalItem.this.catviewer.getCategory(cs);
            this.titlectrl.setForeground(CategoryViewer.getColor(cat.colorid));
            this.titlectrl.setImage(CategoryViewer.getImage(cat.colorid));
        }

        public void dispose() {
            if (this.root != null) {
                this.root.dispose();
            }
        }

        private void save() {
            if (this.root.isDisposed()) {
                return;
            }
            this.root.layout();
            this.update();
        }
    }
}

