/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.spreadsheet;

import com.google.gdata.client.Query;
import java.net.URL;

public class ListQuery
extends Query {
    public static final String SPREADSHEET_QUERY = "sq";
    public static final String ORDERBY = "orderby";
    public static final String ORDERBY_COLUMN = "column";
    public static final String ORDERBY_POSITION = "position";
    public static final String REVERSE = "reverse";

    public ListQuery(URL uRL) {
        super(uRL);
    }

    public void setSpreadsheetQuery(String string) {
        this.setStringCustomParameter(SPREADSHEET_QUERY, string);
    }

    public String getSpreadsheetQuery() {
        return this.getStringCustomParameter(SPREADSHEET_QUERY);
    }

    public void setFullTextQuery(String string) {
        super.setFullTextQuery(string);
    }

    public void setSortColumn(String string) {
        if (string == null || string.split("\\s").length > 1) {
            this.setOrderBy(null);
        } else {
            this.setOrderBy("column:" + string);
        }
    }

    public void setOrderBy(String string) {
        if (string == null || string.equals(ORDERBY_POSITION) || string.startsWith(ORDERBY_COLUMN) && string.split("\\s").length == 1) {
            this.setStringCustomParameter(ORDERBY, string);
        }
    }

    public String getOrderBy() {
        return this.getStringCustomParameter(ORDERBY);
    }

    public void setReverse(boolean bl) {
        this.setStringCustomParameter(REVERSE, bl ? "true" : null);
    }

    public boolean isReverse() {
        return this.getStringCustomParameter(REVERSE) != null;
    }
}

